/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.design.IStiDefault;
import com.stimulsoft.base.drawing.StiAdvancedBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.enums.StiHighlightState;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;

public class StiBorder
implements Cloneable,
IStiSerializable,
IStiSerializableToString,
IStiDefault {
    private static final double SHADOW_SIZE_DEFAULT = 4.0;
    private StiBrush shadowBrush = new StiSolidBrush(StiColor.Black);
    private StiColor color;
    private double size = 1.0;
    private StiPenStyle style = StiPenStyle.Solid;
    private double shadowSize = 4.0;
    private boolean dropShadow;
    private boolean topmost;
    public StiEnumSet<StiBorderSides> side = StiEnumSet.of(StiBorderSides.None);

    public StiBorder() {
        this(StiEnumSet.of(StiBorderSides.None), new StiColor(StiColorEnum.Black), 1.0, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(StiColorEnum.Black));
    }

    public StiBorder(StiBorderSides side, StiColor color, double size, StiPenStyle style) {
        this(StiEnumSet.of(side), color, size, style, false, 4.0, (StiBrush)new StiSolidBrush(StiColorEnum.Black));
    }

    public StiBorder(StiBorderSides side, StiColor color, double size, StiPenStyle style, Boolean topmost) {
        this(side, color, size, style);
        this.topmost = topmost;
    }

    public StiBorder(StiEnumSet<StiBorderSides> side, StiColor color, double size, StiPenStyle style, boolean dropShadow, double shadowSize, StiBrush shadowBrush) {
        this(side, color, size, style, dropShadow, shadowSize, shadowBrush, false);
    }

    public StiBorder(StiEnumSet<StiBorderSides> side, StiColor color, double size, StiPenStyle style, boolean dropShadow, double shadowSize, StiBrush shadowBrush, boolean topmost) {
        this.side = side;
        this.color = color;
        this.size = size;
        this.style = style;
        this.shadowSize = shadowSize;
        this.dropShadow = dropShadow;
        this.topmost = topmost;
        this.shadowBrush = shadowBrush;
    }

    public StiBorder(StiEnumSet<StiBorderSides> side, StiColor color, int size, StiPenStyle style, boolean dropShadow, double shadowSize, StiBrush shadowBrush) {
        this.side = side;
        this.color = color;
        this.size = size;
        this.style = style;
        this.shadowSize = shadowSize;
        this.dropShadow = dropShadow;
        this.shadowBrush = shadowBrush;
    }

    public StiBorder(StiBorderSides side, StiColor color, double size, StiPenStyle style, boolean dropShadow, double shadowSize, StiBrush shadowBrush) {
        this(StiEnumSet.of(side), color, size, style, dropShadow, shadowSize, shadowBrush);
    }

    public StiBorder(StiEnumSet<StiBorderSides> side, StiColor color, double size, StiPenStyle style) {
        this(side, color, size, style, false, 0.0, null);
    }

    public static boolean isDefault(StiBorderSides side, StiColor color, double size, StiPenStyle style, boolean dropShadow, double shadowSize, boolean topmost) {
        return color.is(StiColorEnum.Black) && !dropShadow && !topmost && shadowSize == 4.0 && side == StiBorderSides.None && size == 1.0 && style == StiPenStyle.Solid;
    }

    public Object clone() {
        StiBorder border = null;
        try {
            border = (StiBorder)this.getClass().newInstance();
        }
        catch (Exception e) {
            border = new StiBorder();
        }
        border.setColor(this.color.clone());
        border.setDropShadow(this.dropShadow);
        border.setShadowBrush((StiBrush)this.shadowBrush.clone());
        border.setShadowSize(this.shadowSize);
        border.setSide(StiEnumSet.stringToEnums(StiBorderSides.class, this.getSide().toString()));
        border.setSize(this.size);
        border.setStyle(this.getStyle());
        border.setTopmost(this.getTopmost());
        return border;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        StiBorder border = (StiBorder)(obj instanceof StiBorder ? obj : null);
        if (border == null) {
            return false;
        }
        return this.style == border.style && this.shadowSize == border.shadowSize && this.size == border.size && this.dropShadow == border.dropShadow && this.topmost == border.topmost && StiValidationUtil.equals((Object)this.color, (Object)border.color) && StiValidationUtil.equals((Object)this.shadowBrush, (Object)border.shadowBrush) && this.side.getIntValue() == border.getSide().getIntValue();
    }

    public final void draw(StiGraphics g, StiRectangle rect, double zoom, StiColor emptyColor, StiHighlightState highlightState, Boolean isPrinting, Boolean isThumbPaint, double pageZoom) {
        StiBorder border = this;
        if (border != null) {
            StiAdvancedBorder advancedBorder;
            if (emptyColor == null) {
                emptyColor = StiColorEnum.White.color();
            }
            Double left = 0.0;
            Double right = 0.0;
            Double top = 0.0;
            Double bottom = 0.0;
            StiPen pen = null;
            StiRectangle transformedRect = g.transformRectRound(rect);
            StiRectangle rectIn = transformedRect.clone();
            StiRectangle rectOut = transformedRect.clone();
            rectIn.inflate(-zoom * 2.0, -zoom * 2.0);
            if (border.getDropShadow()) {
                Double dist = border.getShadowSize() * zoom;
                StiBrush brush = border.getShadowBrush();
                if (rect.getHeight() > dist) {
                    g.setTransformedClip(new StiRectangle(rect.getRight(), rect.getTop() + dist, dist, rect.getHeight() - dist));
                    g.drawRectangle(new StiRectangle(rect.getLeft() + dist, rect.getTop() + dist, rect.getWidth(), rect.getHeight()), null, brush, 0.0, zoom, pageZoom);
                    g.restoreClip();
                }
                g.setTransformedClip(new StiRectangle(rect.getLeft() + dist, rect.getBottom(), rect.getWidth(), dist));
                g.drawRectangle(new StiRectangle(rect.getLeft() + dist, rect.getTop() + dist, rect.getWidth(), rect.getHeight()), null, brush, 0.0, zoom, pageZoom);
                g.restoreClip();
            }
            StiAdvancedBorder stiAdvancedBorder = advancedBorder = border instanceof StiAdvancedBorder ? (StiAdvancedBorder)border : null;
            if (highlightState == StiHighlightState.Hide || isPrinting.booleanValue() || isThumbPaint.booleanValue()) {
                if (advancedBorder == null) {
                    pen = this.createBorderPen(border.getSize(), border.getColor(), border.getStyle());
                }
                if (border.isTopBorderSidePresent()) {
                    left = rectIn.getLeft();
                    right = rectIn.getRight();
                    if (advancedBorder != null) {
                        pen = this.createBorderPen(advancedBorder.getTopSide().getSize(), advancedBorder.getTopSide().getColor(), advancedBorder.getTopSide().getStyle());
                    }
                    if (!border.isLeftBorderSidePresent()) {
                        left = rectOut.getLeft();
                    }
                    if (!border.isRightBorderSidePresent()) {
                        right = rectOut.getRight();
                    }
                    if (pen.getDashStyle().equals((Object)StiPenStyle.Double)) {
                        g.drawLineXY(left, rectIn.getTop(), right, rectIn.getTop(), pen, zoom, false);
                        g.drawLineXY(rectOut.getLeft(), rectOut.getTop(), rectOut.getRight(), rectOut.getTop(), pen, zoom, false);
                    } else {
                        g.drawLineXY(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getTop(), pen, zoom);
                    }
                }
                if (border.isLeftBorderSidePresent()) {
                    top = rectIn.getTop();
                    bottom = rectIn.getBottom();
                    if (advancedBorder != null) {
                        pen = this.createBorderPen(advancedBorder.getLeftSide().getSize(), advancedBorder.getLeftSide().getColor(), advancedBorder.getLeftSide().getStyle());
                    }
                    if (!border.isTopBorderSidePresent()) {
                        top = rectOut.getTop();
                    }
                    if (!border.isBottomBorderSidePresent()) {
                        bottom = rectOut.getBottom();
                    }
                    if (pen.getDashStyle().equals((Object)StiPenStyle.Double)) {
                        g.drawLineXY(rectIn.getLeft(), top, rectIn.getLeft(), bottom, pen, zoom, false);
                        g.drawLineXY(rectOut.getLeft(), rectOut.getTop(), rectOut.getLeft(), rectOut.getBottom(), pen, zoom, false);
                    } else {
                        g.drawLineXY(rect.getLeft(), rect.getTop(), rect.getLeft(), rect.getBottom(), pen, zoom);
                    }
                }
                if (border.isBottomBorderSidePresent()) {
                    left = rectIn.getLeft();
                    right = rectIn.getRight();
                    if (advancedBorder != null) {
                        pen = this.createBorderPen(advancedBorder.getBottomSide().getSize(), advancedBorder.getBottomSide().getColor(), advancedBorder.getBottomSide().getStyle());
                    }
                    if (!border.isLeftBorderSidePresent()) {
                        left = rectOut.getLeft();
                    }
                    if (!border.isRightBorderSidePresent()) {
                        right = rectOut.getRight();
                    }
                    if (pen.getDashStyle().equals((Object)StiPenStyle.Double)) {
                        g.drawLineXY(left, rectIn.getBottom(), right, rectIn.getBottom(), pen, zoom, false);
                        g.drawLineXY(rectOut.getLeft(), rectOut.getBottom(), rectOut.getRight(), rectOut.getBottom(), pen, zoom, false);
                    } else {
                        g.drawLineXY(rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getBottom(), pen, zoom);
                    }
                }
                if (border.isRightBorderSidePresent()) {
                    top = rectIn.getTop();
                    bottom = rectIn.getBottom();
                    if (advancedBorder != null) {
                        pen = this.createBorderPen(advancedBorder.getRightSide().getSize(), advancedBorder.getRightSide().getColor(), advancedBorder.getRightSide().getStyle());
                    }
                    if (!border.isTopBorderSidePresent()) {
                        top = rectOut.getTop();
                    }
                    if (!border.isBottomBorderSidePresent()) {
                        bottom = rectOut.getBottom();
                    }
                    if (pen.getDashStyle().equals((Object)StiPenStyle.Double)) {
                        g.drawLineXY(rectIn.getRight(), top, rectIn.getRight(), bottom, pen, zoom, false);
                        g.drawLineXY(rectOut.getRight(), rectOut.getTop(), rectOut.getRight(), rectOut.getBottom(), pen, zoom, false);
                    } else {
                        g.drawLineXY(rect.getRight(), rect.getTop(), rect.getRight(), rect.getBottom(), pen, zoom);
                    }
                }
            } else {
                pen = new StiPen(highlightState == StiHighlightState.Active ? 1.5 : 1.0, StiColorEnum.Red.color(), StiPenStyle.Solid);
                g.drawLineXY(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getTop(), pen, zoom);
                g.drawLineXY(rect.getLeft(), rect.getTop(), rect.getLeft(), rect.getBottom(), pen, zoom);
                g.drawLineXY(rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getBottom(), pen, zoom);
                g.drawLineXY(rect.getRight(), rect.getTop(), rect.getRight(), rect.getBottom(), pen, zoom);
            }
        }
    }

    private StiPen createBorderPen(double width, StiColor color, StiPenStyle dashStyle) {
        StiPen pen = new StiPen(width, color, dashStyle);
        if (dashStyle == StiPenStyle.Solid) {
            pen.setCaps(2);
        }
        return pen;
    }

    public boolean isTopBorderSidePresent() {
        return this.side.contains(StiBorderSides.Top);
    }

    public boolean isBottomBorderSidePresent() {
        return this.side.contains(StiBorderSides.Bottom);
    }

    public boolean isLeftBorderSidePresent() {
        return this.side.contains(StiBorderSides.Left);
    }

    public boolean isRightBorderSidePresent() {
        return this.side.contains(StiBorderSides.Right);
    }

    public boolean isAllBorderSidesPresent() {
        return this.side.containsOnly(StiBorderSides.All);
    }

    private boolean isDefaultShadowBrush() {
        boolean isDefault = this.getColor().equals(StiColor.Black) && !this.dropShadow && this.shadowSize == 4.0 && this.side.containsOnly(StiBorderSides.None) && this.size == 1.0 && this.style == StiPenStyle.Solid && StiSolidBrush.class.isAssignableFrom(this.shadowBrush.getClass()) && ((StiSolidBrush)this.shadowBrush).getColor().equals(StiColor.Black) && !this.topmost;
        return isDefault;
    }

    public StiEnumSet<StiBorderSides> getSide() {
        return this.side;
    }

    public void setSide(StiEnumSet<StiBorderSides> value) {
        this.side = value;
    }

    public void setSide(StiBorderSides value) {
        this.side = StiEnumSet.of(value);
    }

    public StiColor getColor() {
        return this.color;
    }

    public void setColor(StiColor value) {
        this.color = value;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double value) {
        this.size = value;
    }

    public StiPenStyle getStyle() {
        return this.style;
    }

    public void setStyle(StiPenStyle value) {
        this.style = value;
    }

    public StiBrush getShadowBrush() {
        return this.shadowBrush;
    }

    public void setShadowBrush(StiBrush value) {
        this.shadowBrush = value;
    }

    public double getShadowSize() {
        return this.shadowSize;
    }

    public void setShadowSize(double value) {
        this.shadowSize = value;
    }

    public boolean getDropShadow() {
        return this.dropShadow;
    }

    public void setDropShadow(boolean value) {
        this.dropShadow = value;
    }

    public boolean getTopmost() {
        return this.topmost;
    }

    public void setTopmost(boolean value) {
        this.topmost = value;
    }

    @Override
    public boolean isDefault() {
        return this.isDefaultShadowBrush();
    }

    @Override
    public String serialize() {
        String sideToString = StiSerializTypeConverter.enumsToString(this.side);
        String data = String.format("%s;%s;%s;%s;%s;%s;%s", new Object[]{sideToString, this.color.serializeString(), this.size, this.style, StiSerializTypeConverter.booleanToString(this.dropShadow), this.shadowSize, this.shadowBrush.serialize()});
        if (this.topmost) {
            data = data.concat(";" + StiSerializTypeConverter.booleanToString(this.topmost));
        }
        return data;
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(";");
        this.side = StiEnumSet.stringToEnums(StiBorderSides.class, values[0]);
        this.color = StiColor.deserializeString(values[1]);
        this.size = Double.valueOf(values[2]);
        this.style = StiPenStyle.valueOf(values[3]);
        this.dropShadow = StiSerializTypeConverter.stringToBoolean(values[4]);
        this.shadowSize = Double.valueOf(values[5]);
        this.shadowBrush = StiSerializTypeConverter.deserializeStringToBrush(values[6]);
        if (values.length > 7) {
            this.topmost = StiSerializTypeConverter.stringToBoolean(values[7]);
        }
    }

    public void LoadFromJson(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Side")) {
                this.setSide(StiEnumSet.stringToEnums(StiBorderSides.class, property.Value.toString()));
                continue;
            }
            if (property.Name.equals("Color")) {
                this.setColor(StiJsonReportObjectHelper.Deserialize.Color(property.Value.toString()));
                continue;
            }
            if (property.Name.equals("Size")) {
                this.setSize(Double.parseDouble(property.Value.toString()));
                continue;
            }
            if (property.Name.equals("Style")) {
                this.setStyle(StiPenStyle.valueOf(property.Value.toString()));
                continue;
            }
            if (property.Name.equals("ShadowBrush")) {
                this.setShadowBrush(StiJsonReportObjectHelper.Deserialize.Brush(property));
                continue;
            }
            if (property.Name.equals("ShadowSize")) {
                this.setShadowSize(Double.parseDouble(property.Value.toString()));
                continue;
            }
            if (property.Name.equals("DropShadow")) {
                this.setDropShadow(Boolean.parseBoolean(property.Value.toString()));
                continue;
            }
            if (!property.Name.equals("Topmost")) continue;
            this.setTopmost(Boolean.parseBoolean(property.Value.toString()));
        }
    }
}

