/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.drawing.StiLineInfo;
import java.util.List;

public class StiBreakText {
    public static final StiBreakText EMPTY = new StiBreakText();
    private String placedString;
    private String notPlacedString;

    private StiBreakText() {
        this.placedString = "";
        this.notPlacedString = "";
    }

    public StiBreakText(String placedString, String notPlacedString) {
        this.placedString = placedString;
        this.notPlacedString = notPlacedString;
    }

    public StiBreakText(StringBuilder placedString, StringBuilder notPlacedString) {
        this.placedString = placedString.toString();
        this.notPlacedString = notPlacedString.toString();
    }

    public StiBreakText(List<StiLineInfo> lines, int maxHeight) {
        Double height;
        int placedCounLines;
        if (lines.size() == 0) {
            this.placedString = "";
            this.notPlacedString = "";
        }
        placedCounLines = (placedCounLines = (int)((double)maxHeight / (height = lines.get(0).getHeight()))) > lines.size() ? lines.size() : placedCounLines;
        StringBuilder placedSB = new StringBuilder();
        for (int i = 0; i < placedCounLines; ++i) {
            placedSB.append(lines.get(i).getText());
        }
        StringBuilder notPlacedSB = new StringBuilder();
        for (int i = placedCounLines; i < lines.size(); ++i) {
            notPlacedSB.append(lines.get(i).getText());
        }
        this.placedString = placedSB.toString();
        this.notPlacedString = notPlacedSB.toString();
    }

    public String getPlacedString() {
        return this.placedString;
    }

    public String getNotPlacedString() {
        return this.notPlacedString;
    }
}

