/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.StiHatchStyle;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiSerializerUtil;
import com.stimulsoft.base.system.geometry.StiRectangle;

public class StiGlassBrush
extends StiBrush {
    private StiColor color;
    private boolean drawHatch;
    private float blend;

    public final StiColor getColor() {
        return this.color;
    }

    public final void setColor(StiColor value) {
        this.color = value;
    }

    @Override
    public String serialize() {
        return StiSerializerUtil.serializFormat("GlassBrush,{0},{1},{2},", this.color.serializeString(), this.drawHatch, Float.valueOf(this.blend));
    }

    @Override
    public void deserialize(String value) {
        String[] values = value.split(",");
        this.color = StiColor.deserializeString(values[1]);
        this.drawHatch = StiSerializTypeConverter.stringToBoolean(values[2]);
        this.blend = Float.valueOf(values[3]).floatValue();
    }

    public boolean getDrawHatch() {
        return this.drawHatch;
    }

    public void setDrawHatch(boolean value) {
        this.drawHatch = value;
    }

    public float getBlend() {
        return this.blend;
    }

    public void setBlend(float blend) {
        this.blend = blend;
    }

    public StiRectangle getTopRectangle(StiRectangle rect) {
        StiRectangle rect1 = rect.clone();
        rect1.height /= 2.0;
        if (rect1.height * 2.0 < rect.height) {
            rect1.height += 1.0;
        }
        return rect1;
    }

    public StiRectangle getBottomRectangle(StiRectangle rect) {
        StiRectangle rect1 = this.getTopRectangle(rect);
        StiRectangle rect2 = rect;
        rect2.height = rect.height - rect1.height;
        rect2.y = rect1.getBottom();
        return rect2;
    }

    public final StiColor getTopColor() {
        return StiColorUtils.light(this.getColor(), (byte)(64.0f * this.getBlend()));
    }

    public final StiColor getTopColorLight() {
        return StiColorUtils.light(StiColorUtils.light(this.getColor(), (byte)(64.0f * this.getBlend())), 5);
    }

    public final StiColor getBottomColor() {
        return this.getColor();
    }

    public final StiColor getBottomColorLight() {
        return StiColorUtils.light(this.getBottomColor(), 2);
    }

    public final StiBrush getTopBrush() {
        if (this.getDrawHatch()) {
            return new StiHatchBrush(StiHatchStyle.DarkDownwardDiagonal, this.getTopColor(), this.getTopColorLight());
        }
        return new StiSolidBrush(this.getTopColor());
    }

    public final StiBrush getBottomBrush() {
        if (this.getDrawHatch()) {
            return new StiHatchBrush(StiHatchStyle.DarkDownwardDiagonal, this.getBottomColor(), this.getBottomColorLight());
        }
        return new StiSolidBrush(this.getBottomColor());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        StiGlassBrush brush = (StiGlassBrush)(obj instanceof StiGlassBrush ? obj : null);
        if (brush == null) {
            return false;
        }
        if (this.color != brush.color) {
            return false;
        }
        if (this.drawHatch != brush.drawHatch) {
            return false;
        }
        return this.blend == brush.blend;
    }

    public StiGlassBrush() {
        this.getColor();
        this.color = StiColor.Silver;
        this.drawHatch = true;
        this.blend = 0.2f;
        this.getColor();
        this.color = StiColor.Silver;
        this.drawHatch = true;
        this.blend = 0.2f;
    }

    public StiGlassBrush(StiColor color, boolean drawHatch, float blend) {
        this.getColor();
        this.color = StiColor.Silver;
        this.drawHatch = true;
        this.blend = 0.2f;
        this.color = color;
        this.drawHatch = drawHatch;
        this.blend = blend;
    }

    public void LoadValuesFromJson(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Color")) {
                this.setColor(StiJsonReportObjectHelper.Deserialize.Color(property.Value.toString()));
                continue;
            }
            if (property.Name.equals("DrawHatch")) {
                this.setDrawHatch((Boolean)property.Value);
                continue;
            }
            if (!property.Name.equals("Blend")) continue;
            this.blend = property.floatValue().floatValue();
        }
    }
}

