/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.enums.StiPenStyle;

public class StiPen {
    public static final StiPen BLACK = new StiPen(1.0, StiColorEnum.Black.color(), StiPenStyle.Solid);
    public static final StiPen GRAY = new StiPen(1.0, StiColorEnum.Gray.color(), StiPenStyle.Solid);
    public static final StiPen DIM_GRAY = new StiPen(1.0, StiColorEnum.DimGray.color(), StiPenStyle.Solid);
    public static final StiPen RED = new StiPen(1.0, StiColorEnum.Red.color(), StiPenStyle.Solid);
    public static final StiPen BLUE = new StiPen(1.0, StiColorEnum.Blue.color(), StiPenStyle.Solid);
    public static final StiPen TRANSPARENT = new StiPen(1.0, StiColorEnum.Transparent.color(), StiPenStyle.Solid);
    private int caps = 0;
    private int joints = 0;
    private Double width;
    private StiColor color;
    private StiBrush brush;
    private StiPenStyle dashStyle = StiPenStyle.Solid;

    public StiPen(double width, StiColor color, StiPenStyle dashStyle) {
        this.color = color;
        this.dashStyle = dashStyle;
        this.width = width;
    }

    public StiPen(double width, StiColor color) {
        this(width, color, StiPenStyle.Solid);
    }

    public StiPen clone() {
        StiPen result = new StiPen(this.getWidth(), this.getColor(), this.getDashStyle());
        result.setCaps(this.getCaps());
        result.setJoints(this.getJoints());
        result.setBrush(this.getBrush());
        return result;
    }

    public Boolean equals(StiPen object) {
        return super.equals(object) && this.width == object.getWidth() && this.color.equals(object.getColor()) && this.dashStyle == object.getDashStyle() && this.caps == object.getCaps() && this.joints == object.getJoints();
    }

    public int getCaps() {
        return this.caps;
    }

    public void setCaps(int caps) {
        this.caps = caps;
    }

    public int getJoints() {
        return this.joints;
    }

    public void setJoints(int joints) {
        this.joints = joints;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public StiColor getColor() {
        return this.color;
    }

    public void setColor(StiColor color) {
        this.color = color;
    }

    public StiBrush getBrush() {
        return this.brush;
    }

    public void setBrush(StiBrush brush) {
        this.brush = brush;
    }

    public StiPenStyle getDashStyle() {
        return this.dashStyle;
    }

    public void setDashStyle(StiPenStyle dashStyle) {
        this.dashStyle = dashStyle;
    }
}

