/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.design.IStiDefault;
import com.stimulsoft.base.drawing.enums.StiStringTrimming;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.system.StiHotkeyPrefix;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.text.MessageFormat;

public class StiTextOptions
implements IStiSerializable,
IStiSerializableToString,
Cloneable,
IStiDefault,
IStiJsonReportObject {
    private static final String SERIALIZE_PATTERN = "HotkeyPrefix={0}, LineLimit={1}, RightToLeft={2}, Trimming={3}, WordWrap={4}, Angle={5}, FirstTabOffset={6}, DistanceBetweenTabs={7},";
    private BitsTextOptions bits;
    private boolean wordWrap;

    public Object clone() {
        StiTextOptions textOptions = new StiTextOptions();
        if (this.bits != null) {
            Object tempVar = this.bits.clone();
            textOptions.bits = (BitsTextOptions)(tempVar instanceof BitsTextOptions ? tempVar : null);
        }
        textOptions.wordWrap = this.wordWrap;
        return textOptions;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        StiTextOptions options = (StiTextOptions)(obj instanceof StiTextOptions ? obj : null);
        if (options == null) {
            return false;
        }
        if (options.bits == null && this.bits == null) {
            return true;
        }
        if (options.bits != null && this.bits == null) {
            return false;
        }
        if (options.bits == null && this.bits != null) {
            return false;
        }
        if (!new Boolean(this.bits.RightToLeft).equals(options.bits.RightToLeft)) {
            return false;
        }
        if (this.bits.LineLimit != options.bits.LineLimit) {
            return false;
        }
        if (this.wordWrap != options.wordWrap) {
            return false;
        }
        if (this.bits.Angle != options.bits.Angle) {
            return false;
        }
        if (this.bits.FirstTabOffset != options.bits.FirstTabOffset) {
            return false;
        }
        if (this.bits.DistanceBetweenTabs != options.bits.DistanceBetweenTabs) {
            return false;
        }
        if (!this.bits.hotkeyPrefix.equals((Object)options.bits.hotkeyPrefix)) {
            return false;
        }
        return this.bits.trimming.equals((Object)options.bits.trimming);
    }

    public boolean getRightToLeft() {
        if (this.bits == null) {
            return false;
        }
        return this.bits.RightToLeft;
    }

    public void setRightToLeft(boolean value) {
        if (!value && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.RightToLeft = value;
        } else {
            this.bits = new BitsTextOptions(value, this.getLineLimit(), this.getAngle(), this.getFirstTabOffset(), this.getDistanceBetweenTabs(), this.getHotkeyPrefix(), this.getTrimming());
        }
    }

    public boolean getLineLimit() {
        if (this.bits == null) {
            return false;
        }
        return this.bits.LineLimit;
    }

    public void setLineLimit(boolean value) {
        if (!value && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.LineLimit = value;
        } else {
            this.bits = new BitsTextOptions(this.getRightToLeft(), value, this.getAngle(), this.getFirstTabOffset(), this.getDistanceBetweenTabs(), this.getHotkeyPrefix(), this.getTrimming());
        }
    }

    public boolean getWordWrap() {
        return this.wordWrap;
    }

    public void setWordWrap(boolean value) {
        this.wordWrap = value;
    }

    public float getAngle() {
        if (this.bits == null) {
            return 0.0f;
        }
        return this.bits.Angle;
    }

    public void setAngle(float value) {
        if (value == 0.0f && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.Angle = value;
        } else {
            this.bits = new BitsTextOptions(this.getRightToLeft(), this.getLineLimit(), value, this.getFirstTabOffset(), this.getDistanceBetweenTabs(), this.getHotkeyPrefix(), this.getTrimming());
        }
    }

    public float getFirstTabOffset() {
        if (this.bits == null) {
            return 40.0f;
        }
        return this.bits.FirstTabOffset;
    }

    public void setFirstTabOffset(float value) {
        if (value < 0.0f) {
            return;
        }
        if (value == 40.0f && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.FirstTabOffset = value;
        } else {
            this.bits = new BitsTextOptions(this.getRightToLeft(), this.getLineLimit(), this.getAngle(), value, this.getDistanceBetweenTabs(), this.getHotkeyPrefix(), this.getTrimming());
        }
    }

    public float getDistanceBetweenTabs() {
        if (this.bits == null) {
            return 20.0f;
        }
        return this.bits.DistanceBetweenTabs;
    }

    public void setDistanceBetweenTabs(float value) {
        if (value < 0.0f) {
            return;
        }
        if (value == 20.0f && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.DistanceBetweenTabs = value;
        } else {
            this.bits = new BitsTextOptions(this.getRightToLeft(), this.getLineLimit(), this.getAngle(), this.getFirstTabOffset(), value, this.getHotkeyPrefix(), this.getTrimming());
        }
    }

    public StiHotkeyPrefix getHotkeyPrefix() {
        if (this.bits == null) {
            return StiHotkeyPrefix.None;
        }
        return this.bits.hotkeyPrefix;
    }

    public void setHotkeyPrefix(StiHotkeyPrefix value) {
        if (value == StiHotkeyPrefix.None && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.hotkeyPrefix = value;
        } else {
            this.bits = new BitsTextOptions(this.getRightToLeft(), this.getLineLimit(), this.getAngle(), this.getFirstTabOffset(), this.getDistanceBetweenTabs(), value, this.getTrimming());
        }
    }

    public StiStringTrimming getTrimming() {
        if (this.bits == null) {
            return StiStringTrimming.None;
        }
        return this.bits.trimming;
    }

    public void setTrimming(StiStringTrimming value) {
        if (value == StiStringTrimming.None && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.trimming = value;
        } else {
            this.bits = new BitsTextOptions(this.getRightToLeft(), this.getLineLimit(), this.getAngle(), this.getFirstTabOffset(), this.getDistanceBetweenTabs(), this.getHotkeyPrefix(), value);
        }
    }

    @Override
    public boolean isDefault() {
        return !this.wordWrap && this.bits == null;
    }

    public StiTextOptions() {
    }

    public StiTextOptions(boolean rightToLeft, boolean lineLimit, boolean wordWrap, float angle, StiHotkeyPrefix hotkeyPrefix, StiStringTrimming trimming) {
        this(rightToLeft, lineLimit, wordWrap, angle, hotkeyPrefix, trimming, 40.0f, 20.0f);
    }

    /*
     * Enabled aggressive block sorting
     */
    public StiTextOptions(boolean rightToLeft, boolean lineLimit, boolean wordWrap, float angle, StiHotkeyPrefix hotkeyPrefix, StiStringTrimming trimming, float firstTabOffset, float distanceBetweenTabs) {
        this.wordWrap = wordWrap;
        if (!rightToLeft && !lineLimit && angle == 0.0f) {
            this.getHotkeyPrefix();
            if (hotkeyPrefix == StiHotkeyPrefix.None && trimming == StiStringTrimming.None && firstTabOffset == 40.0f && distanceBetweenTabs == 20.0f) {
                this.bits = null;
                return;
            }
        }
        this.bits = new BitsTextOptions(rightToLeft, lineLimit, angle, firstTabOffset, distanceBetweenTabs, hotkeyPrefix, trimming);
    }

    @Override
    public void deserialize(String stringValue) {
        this.deserializeString(stringValue);
    }

    public StiTextOptions deserializeString(String stringValue) {
        String[] values = stringValue.split(",");
        this.bits = new BitsTextOptions();
        try {
            this.bits.hotkeyPrefix = StiValidationUtil.isNotNullOrEmpty((String)values[0]) ? StiHotkeyPrefix.valueOf(this.getDeserializeValue(values[0])) : this.bits.hotkeyPrefix;
            this.bits.LineLimit = StiValidationUtil.isNotNullOrEmpty((String)values[1]) ? StiSerializTypeConverter.stringToBoolean(this.getDeserializeValue(values[1])) : this.bits.LineLimit;
            this.bits.RightToLeft = StiValidationUtil.isNotNullOrEmpty((String)values[2]) ? StiSerializTypeConverter.stringToBoolean(this.getDeserializeValue(values[2])) : this.bits.RightToLeft;
            this.bits.trimming = StiValidationUtil.isNotNullOrEmpty((String)values[3]) ? StiStringTrimming.valueOf(this.getDeserializeValue(values[3])) : this.bits.trimming;
            this.wordWrap = StiValidationUtil.isNotNullOrEmpty((String)values[4]) ? StiSerializTypeConverter.stringToBoolean(this.getDeserializeValue(values[4])) : this.wordWrap;
            this.bits.Angle = StiValidationUtil.isNotNullOrEmpty((String)values[5]) ? Float.valueOf(this.getDeserializeValue(values[5])).floatValue() : this.bits.Angle;
            this.bits.FirstTabOffset = StiValidationUtil.isNotNullOrEmpty((String)values[6]) ? Float.valueOf(this.getDeserializeValue(values[6])).floatValue() : this.bits.FirstTabOffset;
            this.bits.DistanceBetweenTabs = StiValidationUtil.isNotNullOrEmpty((String)values[7]) ? Float.valueOf(this.getDeserializeValue(values[7])).floatValue() : this.bits.DistanceBetweenTabs;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    private String getDeserializeValue(String value) {
        return value.substring(value.indexOf("=") + 1);
    }

    @Override
    public String serialize() {
        if (!this.isDefault()) {
            String data = MessageFormat.format(SERIALIZE_PATTERN, new Object[]{this.getHotkeyPrefix(), StiSerializTypeConverter.booleanToString(this.getLineLimit()), StiSerializTypeConverter.booleanToString(this.getRightToLeft()), this.getTrimming(), StiSerializTypeConverter.booleanToString(this.getWordWrap()), Float.valueOf(this.getAngle()), Float.valueOf(this.getFirstTabOffset()), Float.valueOf(this.getDistanceBetweenTabs())});
            return data;
        }
        return null;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyBool("RightToLeft", this.getRightToLeft());
        jObject.AddPropertyBool("LineLimit", this.getLineLimit());
        jObject.AddPropertyFloat("Angle", this.getAngle(), 0.0);
        jObject.AddPropertyFloat("FirstTabOffset", this.getFirstTabOffset(), 40.0);
        jObject.AddPropertyFloat("DistanceBetweenTabs", this.getDistanceBetweenTabs(), 20.0);
        jObject.AddPropertyEnum("HotkeyPrefix", this.getHotkeyPrefix(), StiHotkeyPrefix.None);
        jObject.AddPropertyEnum("Trimming", this.getTrimming(), StiStringTrimming.None);
        jObject.AddPropertyBool("WordWrap", this.getWordWrap());
        if (jObject.length() > 0) {
            return jObject;
        }
        return null;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("RightToLeft")) {
                this.setRightToLeft((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("LineLimit")) {
                this.setLineLimit((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("Angle")) {
                this.setAngle(property.floatValue().floatValue());
                continue;
            }
            if (property.Name.equals("FirstTabOffset")) {
                this.setFirstTabOffset(property.floatValue().floatValue());
                continue;
            }
            if (property.Name.equals("DistanceBetweenTabs")) {
                this.setDistanceBetweenTabs(property.floatValue().floatValue());
                continue;
            }
            if (property.Name.equals("HotkeyPrefix")) {
                this.setHotkeyPrefix(StiHotkeyPrefix.valueOf((String)property.Value));
                continue;
            }
            if (property.Name.equals("Trimming")) {
                this.setTrimming(StiStringTrimming.valueOf((String)property.Value));
                continue;
            }
            if (!property.Name.equals("WordWrap")) continue;
            this.setWordWrap((Boolean)property.Value);
        }
    }

    private static class BitsTextOptions
    implements Cloneable {
        public boolean RightToLeft = false;
        public boolean LineLimit = false;
        public float Angle = 0.0f;
        public float FirstTabOffset = 40.0f;
        public float DistanceBetweenTabs = 20.0f;
        public StiHotkeyPrefix hotkeyPrefix = StiHotkeyPrefix.None;
        public StiStringTrimming trimming = StiStringTrimming.None;

        public Object clone() {
            BitsTextOptions obj = new BitsTextOptions();
            obj.Angle = this.Angle;
            obj.DistanceBetweenTabs = this.DistanceBetweenTabs;
            obj.FirstTabOffset = this.FirstTabOffset;
            obj.hotkeyPrefix = this.hotkeyPrefix;
            obj.LineLimit = this.LineLimit;
            obj.trimming = this.trimming;
            return obj;
        }

        public BitsTextOptions(boolean rightToLeft, boolean lineLimit, float angle, float firstTabOffset, float distanceBetweenTabs, StiHotkeyPrefix hotkeyPrefix, StiStringTrimming trimming) {
            this.RightToLeft = rightToLeft;
            this.LineLimit = lineLimit;
            this.Angle = angle;
            this.FirstTabOffset = firstTabOffset;
            this.DistanceBetweenTabs = distanceBetweenTabs;
            this.hotkeyPrefix = hotkeyPrefix;
            this.trimming = trimming;
        }

        private BitsTextOptions() {
        }
    }
}

