/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.drawing.MeasureString;
import com.stimulsoft.base.drawing.StiBreakText;
import com.stimulsoft.base.drawing.StiLineInfo;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.List;

public class StiTextUtil {
    private static final int DEFAULT_MAX_WIDTH = 10000;
    private static final int DEFAULT_ANGLE = 0;

    private StiTextUtil() {
    }

    public static StiSize measureString(StiFont font, String text) {
        return StiTextUtil.measureString(10000.0, font, text, 0.0f);
    }

    public static StiSize measureString(double maxWidth, StiFont font, String text, float angle) {
        return StiTextUtil.measureString((int)maxWidth, font, text, angle, true);
    }

    public static StiSize measureString(StiFont font, String text, float angle) {
        MeasureString measureString = new MeasureString(text, font);
        StiSize size = measureString.getSize();
        StiTextUtil.processingAngle(angle, size);
        return size;
    }

    private static void processingAngle(float angle, StiSize size) {
        if (angle == 90.0f || angle == 180.0f) {
            size.rotation90();
        }
    }

    public static StiSize measureString(double maxWidth, StiFont stiFont, String text, float angle, boolean wordWrap) {
        MeasureString measureString = new MeasureString(text, MeasureString.createAnalogueSwingFont(stiFont), maxWidth, false, wordWrap, false);
        StiSize size = measureString.getSize();
        StiTextUtil.processingAngle(angle, size);
        return size;
    }

    public static StiBreakText breakText(int maxHeight, int maxWidth, StiFont stiFont, String text) {
        MeasureString measureString = new MeasureString(text, MeasureString.createAnalogueSwingFont(stiFont), maxWidth, false, true, true);
        List<StiLineInfo> lines = measureString.getLines();
        return new StiBreakText(lines, maxHeight);
    }

    private static Graphics2D createGraphics() {
        BufferedImage bi = new BufferedImage(5, 5, 1);
        return (Graphics2D)bi.getGraphics();
    }

    public static String toString(Object o) {
        if (o != null) {
            if (o.getClass() == String.class) {
                return String.valueOf(o);
            }
            if (o instanceof Double || o instanceof Float || o instanceof BigDecimal) {
                DecimalFormat f = (DecimalFormat)DecimalFormat.getInstance();
                DecimalFormatSymbols custom = new DecimalFormatSymbols();
                custom.setDecimalSeparator('.');
                f.setDecimalFormatSymbols(custom);
                f.setGroupingUsed(false);
                return f.format(o);
            }
            NumberFormat f = NumberFormat.getInstance();
            f.setGroupingUsed(false);
            return f.format(o);
        }
        return " ";
    }
}

