/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.helper;

import com.kitfox.svg.app.beans.SVGIcon;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;

public class StiSvgHelper {
    private static final int MaxSvgOffset = 1000;

    public static boolean isSvg(String data) {
        return StiSvgHelper.isSvg(StiBase64DecoderUtil.decode((String)data.substring(0, Math.min(1020, data.length()))));
    }

    public static boolean isSvg(byte[] data) {
        block7: {
            try {
                if (data.length > 5 && data[0] == 60 && data[1] == 115 && data[2] == 118 && data[3] == 103 && Character.isWhitespace((char)data[4])) {
                    return true;
                }
                Stack<Boolean> stack = new Stack<Boolean>();
                boolean flag1 = false;
                int level = 0;
                for (int pos = 0; pos < data.length - 5 && pos < 1000; ++pos) {
                    if (data[pos] == 60) {
                        if (level == 0 && data[pos + 1] == 115 && data[pos + 2] == 118 && data[pos + 3] == 103 && Character.isWhitespace((char)data[pos + 4])) {
                            return true;
                        }
                        if (data[pos + 1] == 47) {
                            --level;
                            flag1 = (Boolean)stack.pop();
                            continue;
                        }
                        ++level;
                        stack.push(flag1);
                        if (data[pos + 1] != 33 && data[pos + 1] != 63) continue;
                        flag1 = true;
                        continue;
                    }
                    if (data[pos] != 62 || (pos <= 1 || data[pos - 1] != 47) && !flag1) continue;
                    --level;
                    flag1 = (Boolean)stack.pop();
                }
            }
            catch (Exception e) {
                if (StiLoggingUtil.getLogLevel() < 10) break block7;
                e.printStackTrace();
            }
        }
        return false;
    }

    public static BufferedImage decodeSVG(String base64string, StiRectangle rect, double zoom) throws IOException {
        BufferedImage bi;
        SVGIcon icon = new SVGIcon();
        icon.setAntiAlias(true);
        icon.getSvgUniverse().clear();
        icon.setSvgURI(icon.getSvgUniverse().loadSVG((InputStream)new ByteArrayInputStream(StiBase64DecoderUtil.decode((String)base64string)), "file.svg"));
        if (rect != null) {
            icon.setScaleToFit(true);
            icon.setInterpolation(2);
            icon.setPreferredSize(new Dimension((int)(rect.width / zoom), (int)(rect.height / zoom)));
            bi = new BufferedImage((int)(rect.width / zoom), (int)(rect.height / zoom), 2);
        } else {
            bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        }
        Graphics2D ig2 = bi.createGraphics();
        icon.paintIcon(null, (Graphics)ig2, 0, 0);
        return bi;
    }
}

