/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.licenses;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.elements.StiPlanIdent;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONArray;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.licenses.StiLicenseObject;
import com.stimulsoft.base.licenses.StiLicenseProduct;
import com.stimulsoft.base.licenses.StiProductIdent;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.base64.StiBase64EncoderUtil;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class StiLicenseKey
extends StiLicenseObject {
    public StiDateTime activationDate;
    public String signature;
    public String owner = "";
    public String userName = "";
    public StiDateTime startDate;
    public StiDateTime endDate;
    public String deviceId;
    public StiPlanIdent planId;
    public List<StiLicenseProduct> products = new ArrayList<StiLicenseProduct>();
    public String productName;
    public byte[] productLogo;
    public byte[] productFavIcon;
    public String productDescription;
    public String productUrl;

    public Object clone() {
        StiLicenseKey newKey = new StiLicenseKey();
        try {
            newKey.loadFromString(this.saveToString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return newKey;
    }

    public boolean isServerLicense() {
        return this.planId != null;
    }

    public boolean isProductLicense() {
        return this.products != null && this.products.size() > 0;
    }

    public static StiLicenseKey get(byte[] bytes) {
        try {
            StiLicenseKey key = new StiLicenseKey();
            key.decryptFromBytes(bytes);
            return key;
        }
        catch (Exception e) {
            if (StiLoggingUtil.getLogLevel() >= 10) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static StiLicenseKey get(String str) {
        try {
            StiLicenseKey key = new StiLicenseKey();
            key.decryptFromString(str);
            return key;
        }
        catch (Exception e) {
            if (StiLoggingUtil.getLogLevel() >= 10) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public String getCSharpCode() throws InvalidKeyException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, JSONException, InvalidAlgorithmParameterException {
        StringBuilder sb = new StringBuilder();
        sb = sb.append("Stimulsoft.Base.StiLicense.Key = ");
        String str = this.encryptToString();
        while (str.length() > 100) {
            sb = sb.append(String.format("\"%s\"+\r\n", str.substring(0, 100)));
            str = str.substring(100);
        }
        sb = sb.append(String.format("\"%s\"", str));
        sb = sb.append(";");
        return sb.toString();
    }

    public StiLicenseKey() {
        this.activationDate = StiDateTime.currentDate();
    }

    @Override
    public String saveToString() throws JSONException {
        String str = "";
        str = str + "{\r\n";
        str = str + String.format("  \"ActivationDate\": \"%s\",\r\n", this.getActivationDate().toNetJsonString());
        if (this.getSignature() != null) {
            str = str + String.format("  \"Signature\": \"%s\",\r\n", this.getSignature());
        }
        str = str + String.format("  \"Owner\": \"%s\",\r\n", this.getOwner());
        str = str + String.format("  \"UserName\": \"%s\",\r\n", this.getUserName());
        str = str + "  \"Products\": [";
        if (this.getProducts().size() > 0) {
            str = str + "\r\n";
        }
        for (int i = 0; i < this.getProducts().size(); ++i) {
            str = str + "    {\r\n";
            str = str + String.format("      \"ExpirationDate\": \"%s\",\r\n", this.getProducts().get(i).getExpirationDate().toNetJsonString());
            str = str + String.format("      \"Ident\": \"%s\"\r\n", this.getProducts().get(i).getIdent().toString());
            str = i < this.getProducts().size() - 1 ? str + "    },\r\n" : str + "    }\r\n";
        }
        if (this.getProducts().size() > 0) {
            str = str + "  ";
        }
        str = str + "]\r\n}";
        return str;
    }

    @Override
    public void loadFromString(String str) throws JSONException {
        JSONObject obj = new JSONObject(str);
        this.setActivationDate(StiDateTime.fromNetJsonString(obj.getString("ActivationDate")));
        this.getProducts().clear();
        JSONArray prods = obj.getJSONArray("Products");
        for (int index = 0; index < prods.length(); ++index) {
            StiLicenseProduct prod = new StiLicenseProduct();
            this.getProducts().add(prod);
            prod.setExpirationDate(StiDateTime.fromNetJsonString(prods.getJSONObject(index).getString("ExpirationDate")));
            prod.setIdent(StiProductIdent.valueOf(prods.getJSONObject(index).getString("Ident")));
        }
        this.setOwner(obj.getString("Owner"));
        this.setUserName(obj.getString("UserName"));
        this.setSignature(obj.getString("Signature"));
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject rootJsonObject = new JSONObject();
        rootJsonObject.AddPropertyDateTime("ActivationDate", this.getActivationDate().calendar());
        rootJsonObject.AddPropertyStringNullOfEmpty("Signature", this.getSignature());
        rootJsonObject.AddPropertyStringNullOfEmpty("Owner", this.getOwner());
        rootJsonObject.AddPropertyStringNullOfEmpty("UserName", this.getUserName());
        if (this.getStartDate() != null) {
            rootJsonObject.AddPropertyDateTime("StartDate", this.getStartDate().calendar());
        }
        if (this.getEndDate() != null) {
            rootJsonObject.AddPropertyDateTime("EndDate", this.getEndDate().calendar());
        }
        rootJsonObject.AddPropertyStringNullOfEmpty("DeviceId", this.getDeviceId());
        rootJsonObject.AddPropertyStringNullOfEmpty("ProductName", this.getProductName());
        rootJsonObject.AddPropertyStringNullOfEmpty("ProductDescription", this.getProductDescription());
        rootJsonObject.AddPropertyStringNullOfEmpty("ProductUrl", this.getProductUrl());
        if (this.productLogo != null) {
            rootJsonObject.AddPropertyStringNullOfEmpty("ProductLogo", new String(StiBase64EncoderUtil.encode((byte[])this.productLogo)));
        }
        if (this.productFavIcon != null) {
            rootJsonObject.AddPropertyStringNullOfEmpty("ProductFavIcon", new String(StiBase64EncoderUtil.encode((byte[])this.productFavIcon)));
        }
        if (this.getPlanId() != null) {
            rootJsonObject.AddPropertyEnum("PlanId", this.getPlanId());
        }
        JSONArray prds = new JSONArray();
        for (StiLicenseProduct pr : this.getProducts()) {
            prds.put(pr.SaveToJsonObject(null));
        }
        rootJsonObject.put("Products", prds);
        return rootJsonObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            String name = property.Name;
            if ("ActivationDate".equals(name)) {
                this.setActivationDate(StiJsonReportObjectHelper.Deserialize.DateTime(property));
                continue;
            }
            if ("Signature".equals(name)) {
                this.setSignature(jObject.getString(name));
                continue;
            }
            if ("Owner".equals(name)) {
                this.setOwner(jObject.getString(name));
                continue;
            }
            if ("UserName".equals(name)) {
                this.setUserName(jObject.getString(name));
                continue;
            }
            if ("StartDate".equals(name)) {
                this.setStartDate(StiJsonReportObjectHelper.Deserialize.DateTime(property));
                continue;
            }
            if ("EndDate".equals(name)) {
                this.setEndDate(StiJsonReportObjectHelper.Deserialize.DateTime(property));
                continue;
            }
            if ("DeviceId".equals(name)) {
                this.setDeviceId(jObject.getString(name));
                continue;
            }
            if ("ProductName".equals(name)) {
                this.setProductName(jObject.getString(name));
                continue;
            }
            if ("ProductDescription".equals(name)) {
                this.setProductDescription(jObject.getString(name));
                continue;
            }
            if ("ProductUrl".equals(name)) {
                this.setProductUrl(jObject.getString(name));
                continue;
            }
            if ("ProductLogo".equals(name)) {
                this.setProductLogo(StiBase64DecoderUtil.decode((String)jObject.getString(name)));
                continue;
            }
            if ("ProductFavIcon".equals(name)) {
                this.setProductFavIcon(StiBase64DecoderUtil.decode((String)jObject.getString(name)));
                continue;
            }
            if ("PlanId".equals(name)) {
                StiPlanIdent.valueOf(jObject.getString(name));
                continue;
            }
            if (!"Products".equals(name)) continue;
            JSONArray prps = (JSONArray)property.Value;
            this.products.clear();
            for (int i = 0; i < prps.length(); ++i) {
                StiLicenseProduct product = new StiLicenseProduct();
                product.LoadFromJsonObject(prps.getJSONObject(i));
                this.products.add(product);
            }
        }
    }

    public StiDateTime getActivationDate() {
        return this.activationDate;
    }

    public void setActivationDate(StiDateTime activationDate) {
        this.activationDate = activationDate;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public StiDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(StiDateTime startDate) {
        this.startDate = startDate;
    }

    public StiDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(StiDateTime endDate) {
        this.endDate = endDate;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public StiPlanIdent getPlanId() {
        return this.planId;
    }

    public void setPlanId(StiPlanIdent planId) {
        this.planId = planId;
    }

    public List<StiLicenseProduct> getProducts() {
        return this.products;
    }

    public void setProducts(List<StiLicenseProduct> products) {
        this.products = products;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public byte[] getProductLogo() {
        return this.productLogo;
    }

    public void setProductLogo(byte[] productLogo) {
        this.productLogo = productLogo;
    }

    public byte[] getProductFavIcon() {
        return this.productFavIcon;
    }

    public void setProductFavIcon(byte[] productFavIcon) {
        this.productFavIcon = productFavIcon;
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    public String getProductUrl() {
        return this.productUrl;
    }

    public void setProductUrl(String productUrl) {
        this.productUrl = productUrl;
    }
}

