/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.localization;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.settings.StiConfig;
import com.stimulsoft.base.utils.StiXmlHelper;
import com.stimulsoft.base.utils.XmlObject;
import com.stimulsoft.lib.io.StiCloseUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@XmlRootElement(name="Localization")
@XmlAccessorType(value=XmlAccessType.NONE)
public class StiLocalization
extends XmlObject {
    public static final String CATEGORY_FORM_VIEW = "FormView";
    public static final String CATEGORY_FORM_VIEWER = "FormViewer";
    public static final String CATEGORY_FORM_VIEWER_FIND = "FormViewerFind";
    public static final String CATEGORY_HELP_VIEWER = "HelpViewer";
    public static final String CATEGORY_DIALOGS = "Dialogs";
    public static final String CATEGORY_COMPONENTS = "Components";
    public static final String CATEGORY_EXPORT = "Export";
    public static final String CATEGORY_MAIL = "Mail";
    public static final String CATEGORY_BUTTONS = "Buttons";
    public static final String CATEGORY_PROPERTY_MAIN = "PropertyMain";
    public static final String CATEGORY_REPORT = "Report";
    public static final String CATEGORY_FILE_FILTERS = "FileFilters";
    public static final String CATEGORY_EDITOR = "Editor";
    public static final String CATEGORY_WIZARDS = "Wizards";
    public static final String CATEGORY_FORM_DICTIONARY_DESIGNER = "FormDictionaryDesigner";
    public static final String CATEGORY_PASSWORD = "Password";
    public static boolean SearchLocalizationFromRegistry;
    public static String DirectoryLocalization;
    public static String Localization;
    private static StiLocalization localization;
    public Map<String, Map<String, String>> languageProp = new LinkedHashMap<String, Map<String, String>>();
    @XmlAttribute
    private String language;
    @XmlAttribute
    private String description;
    @XmlAttribute
    private String cultureName;

    public static void loadDefConfig() throws StiException {
        InputStream stream = StiConfig.class.getResourceAsStream("/com/stimulsoft/deflocalization.xml");
        if (stream != null) {
            StiLocalization.setLocalization(new StiLocalization());
            StiLocalization.getLocalization().loadLanguage(stream);
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCultureName() {
        return this.cultureName;
    }

    public void setCultureName(String cultureName) {
        this.cultureName = cultureName;
    }

    public void loadLanguage(File file) throws StiException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            this.loadLanguage(stream);
        }
        catch (Exception e) {
            try {
                throw new StiException(e);
            }
            catch (Throwable throwable) {
                StiCloseUtil.close(stream);
                throw throwable;
            }
        }
        StiCloseUtil.close((Closeable)stream);
    }

    public void addLanguageCategory(InputStream stream) throws StiException {
        try {
            Document doc = StiXmlHelper.loadXML(stream);
            this.loadCategory(doc);
        }
        catch (Exception e) {
            throw new StiException(e);
        }
    }

    public void loadLanguage(InputStream stream) throws StiException {
        try {
            this.languageProp.clear();
            Document doc = StiXmlHelper.loadXML(stream);
            NodeList attributeNode = doc.getElementsByTagName("Localization");
            NamedNodeMap attributes = attributeNode.item(0).getAttributes();
            this.language = attributes.getNamedItem("language").getNodeValue();
            this.description = attributes.getNamedItem("description").getNodeValue();
            this.cultureName = attributes.getNamedItem("cultureName").getNodeValue();
            this.loadCategory(doc);
        }
        catch (Exception e) {
            throw new StiException(e);
        }
    }

    private void loadCategory(Document doc) throws ParserConfigurationException, SAXException, IOException {
        NodeList nodeList = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node categoryNode = nodeList.item(i);
            if (categoryNode.getNodeType() != 1) continue;
            LinkedHashMap<String, String> keysMap = new LinkedHashMap<String, String>();
            this.languageProp.put(categoryNode.getNodeName(), keysMap);
            NodeList keysNodes = categoryNode.getChildNodes();
            for (int j = 0; j < keysNodes.getLength(); ++j) {
                Node keyNode = keysNodes.item(j);
                if (keyNode.getNodeType() != 1) continue;
                keysMap.put(keyNode.getNodeName(), keyNode.getTextContent());
            }
        }
    }

    @Deprecated
    public static String get(String string, String string2) {
        return string2;
    }

    public static String Get(String string, String string2) {
        return StiLocalization.getValue(string, string2);
    }

    public static String getValue(String category, String key) {
        return StiLocalization.getLocalization().languageProp.get(category) != null && StiLocalization.getLocalization().languageProp.get(category).get(key) != null ? StiLocalization.getLocalization().languageProp.get(category).get(key) : key;
    }

    public static String getFormatValue(String category, String key) {
        String result = StiLocalization.getValue(category, key);
        return result != null ? result.replaceAll("\\{\\d\\}", "%s") : "";
    }

    public static String getHingValue(String category, String key) {
        return StiLocalization.createHing(StiLocalization.getValue(category, key));
    }

    public static String createHing(String hint) {
        return hint != null ? hint.replaceAll("\\.\\.\\.", "").replaceAll("&", "").replaceAll(":", "") : "";
    }

    public static synchronized void setLocalization(StiLocalization localization) {
        if (StiLocalization.getLocalization() != null) {
            StiLocalization.getLocalization().languageProp.putAll(localization.languageProp);
            StiLocalization.getLocalization().setCultureName(localization.getCultureName());
            StiLocalization.getLocalization().setDescription(localization.getDescription());
            StiLocalization.getLocalization().setLanguage(localization.getLanguage());
        } else {
            StiLocalization.setLocalizationO(localization);
        }
    }

    public static synchronized void setLocalizationO(StiLocalization localization2) {
        localization = localization2;
    }

    public static StiLocalization getLocalization() {
        return localization;
    }

    public static String getLocalizationCultureName() {
        return StiConfig.getConfig().getProperty("Localizations.Localization");
    }

    public static String format(String category, String key, Object ... args) {
        String value = StiLocalization.getValue(category, key);
        int i = 0;
        while (value.indexOf("{" + i + "}") >= 0) {
            value = value.replace("{" + i + "}", "%s");
            ++i;
        }
        return String.format(value, args);
    }

    public static StiLocalization load(InputStream is) throws StiException {
        try {
            StiLocalization loc = new StiLocalization();
            loc.loadLanguage(is);
            return loc;
        }
        catch (Exception e) {
            throw new StiException(e);
        }
    }

    static {
        localization = new StiLocalization();
        try {
            StiLocalization.loadDefConfig();
        }
        catch (StiException e) {
            e.printStackTrace();
        }
    }
}

