/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.range;

import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;

public class CharRange
extends Range {
    public char From = (char)65;
    public char To = (char)90;

    @Override
    public String getRangeName() {
        return "CharRange";
    }

    @Override
    public StiSystemTypeEnum getRangeType() {
        return StiSystemTypeEnum.SystemChar;
    }

    @Override
    public Object getFromObject() {
        return Character.valueOf(this.From);
    }

    @Override
    public void setFromObject(Object value) {
        if (value instanceof Character) {
            this.From = ((Character)value).charValue();
        }
    }

    @Override
    public Object getToObject() {
        return Character.valueOf(this.To);
    }

    @Override
    public void setToObject(Object value) {
        if (value instanceof Character) {
            this.To = ((Character)value).charValue();
        }
    }

    public final boolean Contains(char value) {
        return this.From <= value && this.To >= value;
    }

    public CharRange() {
    }

    public CharRange(char from, char to) {
        this.From = from;
        this.To = to;
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        this.From = StiXMLConvert.decodeName(values[1]).charAt(0);
        this.To = StiXMLConvert.decodeName(values[2]).charAt(0);
    }

    @Override
    protected String getSerializeName() {
        return "Char";
    }

    public static CharRange fromSerializeValue(String str) {
        CharRange result = new CharRange();
        result.deserialize(str);
        return result;
    }
}

