/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.serializing;

import com.stimulsoft.base.IStiValueCollection;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.serializing.StiClassProperties;
import com.stimulsoft.base.serializing.StiDeserializerControler;
import com.stimulsoft.base.serializing.StiProperties;
import com.stimulsoft.base.serializing.StiProperty;
import com.stimulsoft.base.serializing.interfaceobject.IStiCanCreateSerializableInstance;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableRef;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiClassConverter;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiSerializerUtil;
import com.stimulsoft.lib.utils.StiXmlUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StiDeserializerReport {
    private final IStiSerializable instance;
    private final Node rootNode;
    protected StiProperties propertys;
    protected final StiDeserializerControler controler;
    private Node currentItem;
    private StiProperty currentProperty;
    private Hashtable<String, Object> memoryStore;

    public Hashtable<String, Object> getMemoryStore() {
        return this.memoryStore;
    }

    public void setMemoryStore(Hashtable<String, Object> memoryStore) {
        this.memoryStore = memoryStore;
    }

    public StiDeserializerReport(StiDeserializerControler controler, Class<? extends IStiSerializable> clazz, Node rootNode) {
        this(controler, StiDeserializerReport.newInstance(clazz), rootNode);
    }

    public StiDeserializerReport(StiDeserializerControler controler, IStiSerializable instance, Node rootNode) {
        this(controler, instance, rootNode, null);
    }

    public StiDeserializerReport(StiDeserializerControler controler, IStiSerializable instance, Node rootNode, Hashtable<String, Object> memoryStore) {
        this.controler = controler;
        this.instance = instance;
        this.rootNode = rootNode;
        this.memoryStore = memoryStore;
    }

    public <T extends IStiSerializable> T deserialize() {
        if (this.isSerialiToString()) {
            this.deserializeFromString();
        } else {
            Node isSubmitNode = this.rootNode.getAttributes().getNamedItem("isSubmit");
            if (isSubmitNode != null) {
                try {
                    this.propertys = StiClassProperties.getPropertys(this.instance.getClass());
                    this.currentProperty = this.propertys.getByName("IsSubmit");
                    this.setPropertyInInstance(Boolean.valueOf(isSubmitNode.getTextContent()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.deserializeChildren();
        }
        return (T)this.instance;
    }

    private boolean isSerialiToString() {
        return IStiSerializableToString.class.isAssignableFrom(this.instance.getClass());
    }

    private void deserializeFromString() {
        ((IStiSerializableToString)this.instance).deserialize(this.rootNode.getTextContent());
    }

    protected void deserializeChildren() {
        this.propertys = StiClassProperties.getPropertys(this.instance.getClass());
        NodeList childNodes = this.rootNode.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            Node node = childNodes.item(i);
            if (!StiXmlUtil.isElementNode((Node)node)) continue;
            this.currentItem = node;
            this.currentProperty = this.getProperty(this.currentItem);
            if (this.currentProperty == null) continue;
            Object item = this.deserializeChild();
            if (this.currentProperty.memoryStore()) {
                String guid = "";
                guid = this.currentProperty.isCollection() ? (String)((List)item).get(0) : (String)item;
                if (this.memoryStore != null && this.memoryStore.containsKey(guid)) {
                    item = this.memoryStore.get(guid);
                }
            }
            this.setPropertyInInstance(item);
        }
    }

    protected StiProperty getProperty(Node currentItem) {
        return this.propertys.getByName(currentItem.getNodeName());
    }

    private Object deserializeChild() {
        if (this.isReferenceToObject(this.currentItem)) {
            return this.processingIsRef();
        }
        if (this.currentProperty.isObject()) {
            return this.deserializeObject();
        }
        if (this.currentProperty.isCollection()) {
            return this.deserializeCollection();
        }
        return this.deserializePrimitiv();
    }

    private boolean isReferenceToObject(Node currentItem) {
        Node node = currentItem.getAttributes().getNamedItem("isRef");
        return node != null;
    }

    private Object processingIsRef() {
        this.controler.addReferenceToObject(this.instance, this.currentProperty, StiSerializerUtil.attributeValue(this.currentItem, "isRef"));
        return null;
    }

    private Object deserializeObject() {
        Class<? extends IStiSerializable> objectClass = this.getObjectClass(this.currentItem);
        if (StiSerializerUtil.isIgnoreType(objectClass)) {
            return null;
        }
        return this.deserializeObject(objectClass, this.currentItem);
    }

    protected IStiSerializable deserializeObject(Class<? extends IStiSerializable> javaClass, Node currentItem) {
        IStiSerializable newInstance = this.createInstance(javaClass, currentItem);
        if (this.isRefObject(javaClass)) {
            this.controler.addReferences(newInstance, StiSerializerUtil.attributeValue(currentItem, "Ref"));
        }
        return this.controler.deserializeBranch(newInstance, currentItem, this.memoryStore);
    }

    protected IStiSerializable createInstance(Class<? extends IStiSerializable> javaClass, Node currentItem) {
        IStiSerializable newInstance = javaClass == StiBorder.class ? StiSerializTypeConverter.getInstanceBorderBySerializString(this.getTextContent(currentItem)) : (javaClass == StiBrush.class ? StiSerializTypeConverter.getInstanceBrushBySerializString(this.getTextContent(currentItem)) : (this.canCreateSerializableInstance(javaClass) ? ((IStiCanCreateSerializableInstance)((Object)StiDeserializerReport.newInstance(javaClass))).getInstance(this.getTextContent(currentItem)) : StiDeserializerReport.newInstance(javaClass)));
        return newInstance;
    }

    private boolean canCreateSerializableInstance(Class<? extends IStiSerializable> javaClass) {
        return IStiCanCreateSerializableInstance.class.isAssignableFrom(javaClass);
    }

    private Object deserializeCollection() {
        NodeList childNodes = this.currentItem.getChildNodes();
        ArrayList<Object> result = new ArrayList();
        result = this.currentProperty.contentListIsPrimitive() ? this.listPrimitive(childNodes) : this.listObject(childNodes);
        return this.createList(result);
    }

    private ArrayList<Object> listPrimitive(NodeList childNodes) {
        ArrayList<Object> result = new ArrayList<Object>();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node item = childNodes.item(i);
            if (!StiXmlUtil.isElementNode((Node)item)) continue;
            Class<?> primitiveListClass = this.currentProperty.getPrimitiveListClass();
            Object primitiv = this.deserializePrimitiv(primitiveListClass, item.getTextContent());
            result.add(primitiv);
        }
        return result;
    }

    private ArrayList<Object> listObject(NodeList childNodes) {
        ArrayList<Object> result = new ArrayList<Object>();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node item = childNodes.item(i);
            if (!StiXmlUtil.isElementNode((Node)item)) continue;
            this.deserializObjectInList(item, result);
        }
        return result;
    }

    private void deserializObjectInList(Node item, ArrayList<Object> result) {
        if (this.isReferenceToObject(item)) {
            System.err.println("WARNING in the component contains 'isRef' " + item);
            return;
        }
        Class<? extends IStiSerializable> collectionType = this.getCollectionType(item);
        if (StiSerializerUtil.isIgnoreType(collectionType)) {
            return;
        }
        IStiSerializable object = this.deserializeObject(collectionType, item);
        result.add(object);
    }

    private Object deserializePrimitiv() {
        return this.deserializePrimitiv(this.currentProperty, this.currentItem, this.instance);
    }

    protected Object deserializePrimitiv(StiProperty property, Node propertyValue, IStiSerializable instance) {
        Class<?> propertyClass = property.returnClass();
        String strValue = this.getTextContent(propertyValue);
        StiEnumSet result = this.existAttribute("isNull") ? null : (propertyClass == StiEnumSet.class ? StiSerializTypeConverter.stringToEnums(property.getEnumClass(instance), strValue) : this.deserializePrimitiv(propertyClass, strValue));
        return result;
    }

    private Object deserializePrimitiv(Class<?> propertyClass, String strValue) {
        Object result = this.existAttribute("isNull") ? null : StiSerializTypeConverter.getDataFromString(propertyClass, strValue);
        return result;
    }

    private boolean existAttribute(String attributename) {
        return this.currentItem.getAttributes().getNamedItem(attributename) != null;
    }

    private Class<? extends IStiSerializable> getCollectionType(Node currentItem) {
        Class<?> result;
        if (this.currentProperty.isValueCollection()) {
            result = ((IStiValueCollection)this.currentProperty.getInstance()).getItemsType(this.getTextContent(currentItem));
        } else {
            String attributeValue = StiSerializerUtil.attributeValue(currentItem, "type");
            result = this.currentProperty.correctTypeForList(attributeValue);
        }
        return result;
    }

    private void setPropertyInInstance(Object propertyValue) {
        try {
            this.currentProperty.getSETMetod().invoke((Object)this.instance, propertyValue);
        }
        catch (Exception e) {
            throw new RuntimeException("\nCould not set value: '" + propertyValue + "' \u043a\u043b\u0430\u0441\u0441 '" + (propertyValue != null ? propertyValue.getClass() : "not defined") + "'\n method '" + this.currentProperty.getSETMetod() + "'", e);
        }
    }

    private List<Object> createList(ArrayList<Object> content) {
        if (this.currentProperty.returnClass() == List.class) {
            return content;
        }
        List result = (List)this.currentProperty.getInstance();
        result.addAll(content);
        return result;
    }

    private Class<? extends IStiSerializable> getObjectClass(Node currentItem) {
        Node type = currentItem.getAttributes().getNamedItem("type");
        Class<IStiSerializable> result = type != null ? StiClassConverter.getJavaClass(type.getNodeValue()) : this.currentProperty.returnClass();
        return result;
    }

    protected String getTextContent(Node currentItem) {
        return currentItem.getTextContent();
    }

    protected static IStiSerializable newInstance(Class<? extends IStiSerializable> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get an instance of the class " + clazz + e.getMessage(), e);
        }
    }

    public boolean isRefObject(Class<? extends IStiSerializable> clazz) {
        return IStiSerializableRef.class.isAssignableFrom(clazz);
    }

    public IStiSerializable getInstance() {
        return this.instance;
    }
}

