/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.serializing;

import com.stimulsoft.base.serializing.StiProperty;
import com.stimulsoft.base.system.StiCopyOnWriteArrayList;
import java.util.Comparator;
import java.util.logging.Logger;

public class StiProperties {
    private static final Logger LOG = Logger.getLogger(StiProperties.class.getName());
    private static final Comparator<StiProperty> BY_NAME = new Comparator<StiProperty>(){

        @Override
        public int compare(StiProperty value1, StiProperty value2) {
            return value1.getName().compareToIgnoreCase(value2.getName());
        }
    };
    private static final Comparator<StiProperty> BY_SHORT_NAME = new Comparator<StiProperty>(){

        @Override
        public int compare(StiProperty value1, StiProperty value2) {
            String name1 = value1.getShorNameOrName();
            String name2 = value2.getShorNameOrName();
            return name1.compareToIgnoreCase(name2);
        }
    };
    private final StiCopyOnWriteArrayList<StiProperty> properties = new StiCopyOnWriteArrayList();
    private final Class<?> clazz;

    public StiProperties(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void add(StiProperty property) {
        this.properties.add(property);
    }

    public StiProperty getByName(String name) {
        this.properties.sort(BY_NAME);
        for (StiProperty property : this.properties) {
            if (!name.equalsIgnoreCase(property.getName())) continue;
            return property;
        }
        return null;
    }

    public StiProperty getByShortName(String shortName) {
        this.properties.sort(BY_SHORT_NAME);
        for (StiProperty property : this.properties) {
            if (!shortName.equalsIgnoreCase(property.getShorNameOrName())) continue;
            return property;
        }
        return null;
    }

    public StiProperty getByShortNameOrName(String name) {
        this.properties.sort(BY_SHORT_NAME);
        for (StiProperty property : this.properties) {
            if (!name.equalsIgnoreCase(property.getShorNameOrName())) continue;
            return property;
        }
        return null;
    }

    private StiProperty getByKey(StiProperty keyInstance, Comparator<StiProperty> comparator) {
        return null;
    }

    public StiCopyOnWriteArrayList<StiProperty> getProperties() {
        return this.properties;
    }
}

