/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.system;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToXmlString;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.system.StiFontStyle;
import com.stimulsoft.base.system.StiGraphicsUnit;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.text.MessageFormat;
import java.util.Random;
import javax.swing.JLabel;

public class StiFont
implements IStiSerializableToString,
IStiSerializableToXmlString,
Cloneable {
    public double size = 8.0;
    private String name = "Arial";
    private int style;
    private StiGraphicsUnit unit;
    private String legalName;

    public StiFont() {
        this.style = StiFontStyle.Regular.intValue;
        this.unit = StiGraphicsUnit.Point;
    }

    public StiFont(String name, double size) {
        this.style = StiFontStyle.Regular.intValue;
        this.unit = StiGraphicsUnit.Point;
        this.name = name;
        this.size = size;
    }

    public StiFont(String name, double size, StiFontStyle style) {
        this(name, size);
        this.style = style.intValue;
    }

    public StiFont(String name, double size, StiEnumSet<StiFontStyle> style) {
        this(name, size);
        this.style = style.getValue();
    }

    public StiFont(String name, double size, StiFontStyle style, StiGraphicsUnit pixel) {
        this(name, size, style);
        this.unit = pixel;
    }

    public StiFont(String name, double size, int style, StiGraphicsUnit pixel) {
        this(name, size);
        this.unit = pixel;
        this.style = style;
    }

    public String toString() {
        return "Name=" + this.name + " Size=" + this.size + " Style=" + this.style;
    }

    public Double getSizeInPixel() {
        Double inch = this.size * 7200.0 / 75.0;
        switch (this.unit) {
            case Inch: {
                return inch;
            }
            case Point: {
                return inch / 72.0;
            }
            case Millimeter: {
                return inch / 25.4;
            }
            case Document: {
                return inch / 3.0;
            }
            case World: {
                return this.size;
            }
        }
        return this.size;
    }

    @Override
    public String serialize() {
        String data = this.serializeString();
        return this.serializeString();
    }

    public String serializeString() {
        if (this.style != StiFontStyle.Regular.intValue || this.unit != StiGraphicsUnit.Point) {
            String stylesStr = this.getStylesStr("| ");
            if (stylesStr.equals("")) {
                stylesStr = "Regular";
            }
            if (this.unit != StiGraphicsUnit.Point) {
                return MessageFormat.format("{0},{1},{2},{3}", new Object[]{this.name, this.sizeForSerialize(), stylesStr, this.unit});
            }
            return MessageFormat.format("{0},{1},{2}", this.name, this.sizeForSerialize(), stylesStr);
        }
        return MessageFormat.format("{0},{1}", this.name, this.sizeForSerialize());
    }

    public String getStylesStr(String regex) {
        StringBuilder stylesStr = new StringBuilder();
        if (this.bold()) {
            stylesStr.append("Bold" + regex);
        }
        if (this.italic()) {
            stylesStr.append("Italic" + regex);
        }
        if (this.underline()) {
            stylesStr.append("Underline" + regex);
        }
        if (this.strikeout()) {
            stylesStr.append("Strikeout" + regex);
        }
        return !stylesStr.equals("") && stylesStr.toString().trim().length() > 0 ? stylesStr.toString().trim().substring(0, stylesStr.length() - 2) : "";
    }

    private String sizeForSerialize() {
        return StiSerializTypeConverter.doubleToString(this.size);
    }

    @Override
    public void deserialize(String textContent) {
        this.deserializeString(textContent);
    }

    public static int deserializeStyle(String styleStr) {
        int style = StiFontStyle.Regular.intValue;
        if (styleStr.indexOf("Bold") >= 0) {
            style += StiFontStyle.Bold.intValue;
        }
        if (styleStr.indexOf("Italic") >= 0) {
            style += StiFontStyle.Italic.intValue;
        }
        if (styleStr.indexOf("Underline") >= 0) {
            style += StiFontStyle.Underline.intValue;
        }
        if (styleStr.indexOf("Strikeout") >= 0) {
            style += StiFontStyle.Strikeout.intValue;
        }
        return style;
    }

    public StiFont deserializeString(String textContent) {
        String[] values = textContent.split(",");
        this.name = values[0];
        this.size = StiSerializTypeConverter.stringToDouble(values[1]);
        if (values.length > 2) {
            this.style = StiFont.deserializeStyle(values[2]);
            if (values.length > 3) {
                this.unit = StiGraphicsUnit.valueOf(values[3]);
            }
        }
        return this;
    }

    public static StiFont getFont(String name, int size) {
        return new StiFont(name, size);
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public void setStyle(StiFontStyle style) {
        this.style = style.intValue;
    }

    public int getStyle() {
        return this.style;
    }

    public int getFontStyle() {
        int result = 0;
        if (this.bold()) {
            ++result;
        }
        if (this.italic()) {
            result += 2;
        }
        return result;
    }

    public String getFontStyleJSON() {
        String result = "";
        if (this.bold()) {
            result = result + "Bold";
        }
        if (this.italic()) {
            result = !"".equals(result) ? result + "|Italic" : result + "Italic";
        }
        if (this.underline()) {
            result = !"".equals(result) ? result + "|Underline" : result + "Underline";
        }
        if (this.strikeout()) {
            result = !"".equals(result) ? result + "|Strikeout" : result + "Strikeout";
        }
        return result;
    }

    public boolean bold() {
        return (this.style & StiFontStyle.Bold.intValue) != StiFontStyle.Regular.intValue;
    }

    public boolean italic() {
        return (this.style & StiFontStyle.Italic.intValue) != StiFontStyle.Regular.intValue;
    }

    public boolean underline() {
        return (this.style & StiFontStyle.Underline.intValue) != StiFontStyle.Regular.intValue;
    }

    public boolean strikeout() {
        return (this.style & StiFontStyle.Strikeout.intValue) != StiFontStyle.Regular.intValue;
    }

    public void setUnit(StiGraphicsUnit unit) {
        this.unit = unit;
    }

    public StiGraphicsUnit getUnit() {
        return this.unit;
    }

    public String getName() {
        return this.name;
    }

    public String getLegalName() {
        char[] chars = "abcdefghijklmnopqrstuvwxyz".toCharArray();
        Random random = new Random();
        if (this.legalName == null) {
            this.legalName = this.name.replaceAll("[^a-zA-Z0-9.-]\\s", "_");
            while (this.legalName.contains("_")) {
                this.legalName = this.legalName.replace('_', chars[random.nextInt(chars.length)]);
            }
        }
        return this.legalName;
    }

    public Font getAwtFont(double zoom) {
        int fontStyle = 0;
        if (this.bold()) {
            fontStyle |= 1;
        }
        if (this.italic()) {
            fontStyle |= 2;
        }
        return new Font(this.getName(), fontStyle, (int)Math.round(this.getSizeInPixel() * zoom));
    }

    @Override
    public String serializeToXmlString() {
        String stylesStr = this.getStylesStr(", ");
        if (stylesStr != "") {
            stylesStr = "style=" + stylesStr;
        }
        String stringSize = String.valueOf(this.size);
        stringSize = this.unit == StiGraphicsUnit.Pixel ? stringSize + "px" : (this.unit == StiGraphicsUnit.Inch ? stringSize + "in" : (this.unit == StiGraphicsUnit.Millimeter ? stringSize + "mm" : stringSize + "pt"));
        if (stylesStr.length() > 0) {
            return MessageFormat.format("{0}, {1}, {2}", this.name, stringSize, stylesStr);
        }
        return MessageFormat.format("{0}, {1}", this.name, stringSize);
    }

    @Override
    public void deserializeFromXmlString(String textContent) {
        String[] values = textContent.split(",");
        this.name = values[0];
        String sizeStr = values[1].substring(0, values[1].length() - 2);
        this.size = StiSerializTypeConverter.stringToDouble(sizeStr);
        if (values.length > 2) {
            this.unit = values[1].endsWith("px") ? StiGraphicsUnit.Pixel : (values[1].endsWith("in") ? StiGraphicsUnit.Inch : (values[1].endsWith("mm") ? StiGraphicsUnit.Millimeter : StiGraphicsUnit.Point));
            String styles = textContent.substring(textContent.indexOf("=") + 1);
            this.style = StiFontStyle.Regular.intValue;
            if (styles.indexOf("Bold") >= 0) {
                this.style += StiFontStyle.Bold.intValue;
            }
            if (styles.indexOf("Italic") >= 0) {
                this.style += StiFontStyle.Italic.intValue;
            }
            if (styles.indexOf("Underline") >= 0) {
                this.style += StiFontStyle.Underline.intValue;
            }
            if (styles.indexOf("Strikeout") >= 0) {
                this.style += StiFontStyle.Strikeout.intValue;
            }
        }
    }

    public Object clone() {
        return new StiFont(this.name, this.size, this.style, this.unit);
    }

    public double getHeight() {
        JLabel label = new JLabel("Wy");
        FontMetrics fm = label.getFontMetrics(this.getAwtFont(1.0));
        return fm.getAscent() + fm.getDescent() + fm.getLeading();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StiFont)) {
            return false;
        }
        StiFont font = (StiFont)obj;
        return font.style == this.style && StiValidationUtil.equals((Object)font.name, (Object)this.name) && font.unit == this.unit;
    }
}

