/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.system;

import java.util.Calendar;

public class StiTimeSpan {
    public static final StiTimeSpan ZERO = new StiTimeSpan();
    private long ticks;

    public StiTimeSpan(long ticks) {
        this.ticks = ticks;
    }

    public StiTimeSpan(int hours, int minutes, int seconds) {
        this.ticks = this.millisecondsInHours(hours) + (long)(minutes * 1000 * 60) + (long)(seconds * 1000);
    }

    public StiTimeSpan(int days, int hours, int minutes, int seconds) {
        this.ticks = this.millisecondsInDay(days) + this.millisecondsInHours(hours) + (long)(minutes * 1000 * 60) + (long)(seconds * 1000);
    }

    public StiTimeSpan(int days, int hours, int minutes, int seconds, int milliseconds) {
        this.ticks = this.millisecondsInDay(days) + this.millisecondsInHours(hours) + (long)(minutes * 1000 * 60) + (long)(seconds * 1000) + (long)milliseconds;
    }

    private long millisecondsInDay(int days) {
        return (long)days * 1000L * 60L * 60L * 24L;
    }

    private long millisecondsInHours(int hours) {
        return (long)hours * 1000L * 60L * 60L;
    }

    public StiTimeSpan() {
        this.ticks = 0L;
    }

    public StiTimeSpan(float ticks) {
        this.ticks = (long)ticks;
    }

    public static StiTimeSpan FromSeconds(float seconds) {
        return new StiTimeSpan(seconds * 1000.0f);
    }

    public static StiTimeSpan valueOf(String str) {
        try {
            if (str.contains(":")) {
                String[] time = str.split(":");
                String[] daysHours = time[0].split("\\.");
                String days = daysHours.length == 2 ? daysHours[0] : String.valueOf(0);
                String hours = time.length == 3 ? daysHours[daysHours.length - 1] : String.valueOf(0);
                String minutes = time.length > 1 ? time[time.length - 2] : String.valueOf(0);
                String[] mSeconds = time[time.length - 1].split("\\.");
                String seconds = mSeconds.length == 2 ? mSeconds[0] : time[time.length - 1];
                return new StiTimeSpan(Integer.valueOf(days), Integer.valueOf(hours), Integer.valueOf(minutes), Integer.valueOf(seconds));
            }
            return new StiTimeSpan(Long.valueOf(str));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("For input string: " + str);
        }
    }

    public double getTotalYear() {
        return new Double(this.ticks) / 3.1104E10;
    }

    public double getTotalMonth() {
        return new Double(this.ticks) / 2.592E9;
    }

    public double getTotalDays() {
        return new Double(this.ticks) / 8.64E7;
    }

    public double getTotalHours() {
        return new Double(this.ticks) / 3600000.0;
    }

    public double getTotalMinutes() {
        return new Double(this.ticks) / 60000.0;
    }

    public double getTotalSeconds() {
        return new Double(this.ticks) / 1000.0;
    }

    public double getTotalMilliseconds() {
        return this.ticks;
    }

    public String formatString() {
        int day = this.getDay();
        int hours = this.getHours();
        int minutes = this.getMinutes();
        int seconds = this.getSeconds();
        int mseconds = this.getMilisecond();
        return String.format("%d.%02d:%02d:%02d %dms", day, hours, minutes, seconds, mseconds);
    }

    private int getMilisecond() {
        return (int)(new Double(this.ticks) % 1000.0);
    }

    public int getSeconds() {
        return (int)(new Double(this.ticks) / 1000.0 % 60.0);
    }

    public int getMinutes() {
        return (int)(new Double(this.ticks) / 60000.0 % 60.0);
    }

    public int getHours() {
        return (int)(new Double(this.ticks) / 3600000.0 % 24.0);
    }

    public int getDay() {
        return (int)(new Double(this.ticks) / 8.64E7);
    }

    public String toString() {
        return String.format("%02d:%02d:%02d", this.getHours(), this.getMinutes(), this.getSeconds());
    }

    public static StiTimeSpan fromInterval(Calendar dateBegin, Calendar dateEnd) {
        long ticks = dateEnd.getTimeInMillis() - dateBegin.getTimeInMillis();
        return new StiTimeSpan(ticks);
    }

    public void setTicks(long ticks) {
        this.ticks = ticks;
    }

    public long getTicks() {
        return this.ticks;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof StiTimeSpan && ((StiTimeSpan)obj).ticks == this.ticks;
    }
}

