/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.system.geometry;

import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiSerializerUtil;
import com.stimulsoft.base.utils.StiMath;

public class StiPoint
implements IStiSerializableToString {
    public double x;
    public double y;

    public StiPoint() {
        this(0.0, 0.0);
    }

    public StiPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public String serialize() {
        return StiSerializerUtil.serializFormat("{0}, {1}", this.x, this.y);
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(", ");
        this.x = StiSerializTypeConverter.stringToDouble(values[0]);
        this.y = StiSerializTypeConverter.stringToDouble(values[1]);
    }

    public StiPoint round(double digits) {
        this.x = StiMath.round((Double)this.x, digits);
        this.y = StiMath.round((Double)this.y, digits);
        return this;
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    public static StiPoint getEmpty() {
        return new StiPoint(0.0, 0.0);
    }

    public StiPoint getValue() {
        return this.clone();
    }

    public StiPoint clone() {
        return new StiPoint(this.x, this.y);
    }

    public boolean equals(Object obj) {
        StiPoint point = obj instanceof StiPoint ? (StiPoint)obj : null;
        return point != null && point.x == this.x && point.y == this.y;
    }

    public String toString() {
        return "x=" + this.x + ", y=" + this.y;
    }
}

