/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class StiLoggingUtil {
    static Logger LOG = Logger.getLogger("com.stimulsoft.base.utils.StiLoggingUtil");

    public static void showWarning(String message, Exception r) {
        LOG.warning(StiLoggingUtil.getHtmlError(message, r));
    }

    public static void uppendException(Exception e, String className, String methodName) {
        ArrayList<StackTraceElement> el = new ArrayList<StackTraceElement>(Arrays.asList(e.getStackTrace()));
        el.add(0, new StackTraceElement(className, methodName, "", 0));
        e.setStackTrace(el.toArray(new StackTraceElement[0]));
    }

    public static String getHtmlError(String message, Exception r) {
        StringBuilder info2 = new StringBuilder();
        info2.append(message).append("\n");
        info2.append(r.getMessage()).append("\n");
        int max = r.getStackTrace().length >= 10 ? 10 : r.getStackTrace().length;
        for (int i = 0; i < max; ++i) {
            info2.append(r.getStackTrace()[i].toString()).append("\n");
        }
        return info2.toString();
    }

    public static int getLogLevel() {
        try {
            Object engineObj = Class.forName("com.stimulsoft.report.StiOptions").getField("Engine").get(null);
            return Class.forName("com.stimulsoft.report.options.EngineOptions").getField("logLevel").getInt(engineObj);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

