/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.utils;

import com.stimulsoft.base.utils.StiXmlHelper;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;

public class StiZipWriter20 {
    private OutputStream fos;
    private ZipOutputStream zos;
    private List<String> entryCache = new ArrayList<String>();

    public StiZipWriter20(File zipFile) throws FileNotFoundException {
        this.fos = new FileOutputStream(zipFile);
        this.zos = new ZipOutputStream(this.fos);
    }

    public StiZipWriter20(OutputStream outputStream) throws FileNotFoundException {
        this.fos = outputStream;
        this.zos = new ZipOutputStream(this.fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(String path, String fileName, Document doc) throws IOException, TransformerException {
        this.putNexEntry(path);
        try {
            this.zos.putNextEntry(new ZipEntry(path + fileName));
            this.zos.write(StiXmlHelper.serialize(doc).getBytes("UTF-8"));
        }
        finally {
            this.zos.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(String path, String fileName, byte[] bytes) throws IOException {
        this.putNexEntry(path);
        try {
            this.zos.putNextEntry(new ZipEntry(path + fileName));
            this.zos.write(bytes);
        }
        finally {
            this.zos.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNexEntry(String path) throws IOException {
        if (StiValidationUtil.isNotNullOrEmpty((String)path) && !this.entryCache.contains(path)) {
            try {
                this.zos.putNextEntry(new ZipEntry(path));
                this.entryCache.add(path);
            }
            finally {
                this.zos.closeEntry();
            }
        }
    }

    public void finish() throws IOException {
        this.zos.close();
        this.fos.close();
    }
}

