/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oceanbase;

import com.oceanbase.clogproxy.client.config.ClientConf;
import com.oceanbase.clogproxy.client.config.ObReaderConfig;
import com.oceanbase.clogproxy.client.util.ClientIdGenerator;
import com.ververica.cdc.connectors.oceanbase.source.OceanBaseRichSourceFunction;
import com.ververica.cdc.connectors.oceanbase.table.OceanBaseDeserializationSchema;
import com.ververica.cdc.connectors.oceanbase.table.StartupMode;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class OceanBaseSource {
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private StartupMode startupMode;
        private String username;
        private String password;
        private String tenantName;
        private String databaseName;
        private String tableName;
        private String tableList;
        private String serverTimeZone;
        private Duration connectTimeout;
        private String hostname;
        private Integer port;
        private String logProxyHost;
        private Integer logProxyPort;
        private String logProxyClientId;
        private Long startupTimestamp;
        private String rsList;
        private String configUrl;
        private String workingMode;
        private OceanBaseDeserializationSchema<T> deserializer;

        public Builder<T> startupMode(StartupMode startupMode) {
            this.startupMode = startupMode;
            return this;
        }

        public Builder<T> username(String username) {
            this.username = username;
            return this;
        }

        public Builder<T> password(String password) {
            this.password = password;
            return this;
        }

        public Builder<T> tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public Builder<T> databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder<T> tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder<T> tableList(String tableList) {
            this.tableList = tableList;
            return this;
        }

        public Builder<T> serverTimeZone(String serverTimeZone) {
            this.serverTimeZone = serverTimeZone;
            return this;
        }

        public Builder<T> connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder<T> hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder<T> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<T> logProxyHost(String logProxyHost) {
            this.logProxyHost = logProxyHost;
            return this;
        }

        public Builder<T> logProxyPort(int logProxyPort) {
            this.logProxyPort = logProxyPort;
            return this;
        }

        public Builder<T> logProxyClientId(String logProxyClientId) {
            this.logProxyClientId = logProxyClientId;
            return this;
        }

        public Builder<T> startupTimestamp(Long startupTimestamp) {
            this.startupTimestamp = startupTimestamp;
            return this;
        }

        public Builder<T> rsList(String rsList) {
            this.rsList = rsList;
            return this;
        }

        public Builder<T> configUrl(String configUrl) {
            this.configUrl = configUrl;
            return this;
        }

        public Builder<T> workingMode(String workingMode) {
            this.workingMode = workingMode;
            return this;
        }

        public Builder<T> deserializer(OceanBaseDeserializationSchema<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public SourceFunction<T> build() {
            switch (this.startupMode) {
                case INITIAL: {
                    Preconditions.checkNotNull((Object)this.hostname, (String)"hostname shouldn't be null on startup mode 'initial'");
                    Preconditions.checkNotNull((Object)this.port, (String)"port shouldn't be null on startup mode 'initial'");
                    this.startupTimestamp = 0L;
                    break;
                }
                case LATEST_OFFSET: {
                    this.startupTimestamp = 0L;
                    break;
                }
                case TIMESTAMP: {
                    Preconditions.checkNotNull((Object)this.startupTimestamp, (String)"startupTimestamp shouldn't be null on startup mode 'timestamp'");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException((Object)((Object)this.startupMode) + " mode is not supported.");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)this.databaseName) || StringUtils.isNotEmpty((CharSequence)this.tableName)) {
                if (StringUtils.isEmpty((CharSequence)this.databaseName) || StringUtils.isEmpty((CharSequence)this.tableName)) {
                    throw new IllegalArgumentException("'database-name' and 'table-name' should be configured at the same time");
                }
            } else {
                Preconditions.checkNotNull((Object)this.tableList, (String)"'database-name', 'table-name' or 'table-list' should be configured");
            }
            if (this.serverTimeZone == null) {
                this.serverTimeZone = "+00:00";
            }
            if (this.connectTimeout == null) {
                this.connectTimeout = Duration.ofSeconds(30L);
            }
            if (this.logProxyClientId == null) {
                this.logProxyClientId = String.format("%s_%s_%s", ClientIdGenerator.generate(), Thread.currentThread().getId(), Preconditions.checkNotNull((Object)this.tenantName));
            }
            ClientConf clientConf = ClientConf.builder().clientId(this.logProxyClientId).connectTimeoutMs((int)this.connectTimeout.toMillis()).build();
            ObReaderConfig obReaderConfig = new ObReaderConfig();
            if (StringUtils.isNotEmpty((CharSequence)this.rsList)) {
                obReaderConfig.setRsList(this.rsList);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.configUrl)) {
                obReaderConfig.setClusterUrl(this.configUrl);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.workingMode)) {
                obReaderConfig.setWorkingMode(this.workingMode);
            }
            obReaderConfig.setUsername(this.username);
            obReaderConfig.setPassword(this.password);
            obReaderConfig.setStartTimestamp(this.startupTimestamp);
            obReaderConfig.setTimezone(this.serverTimeZone);
            return new OceanBaseRichSourceFunction<T>(StartupMode.INITIAL.equals((Object)this.startupMode), this.username, this.password, this.tenantName, this.databaseName, this.tableName, this.tableList, this.connectTimeout, this.hostname, this.port, this.logProxyHost, this.logProxyPort, clientConf, obReaderConfig, this.deserializer);
        }
    }
}

