/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oceanbase.source;

import com.oceanbase.clogproxy.client.LogProxyClient;
import com.oceanbase.clogproxy.client.config.AbstractConnectionConfig;
import com.oceanbase.clogproxy.client.config.ClientConf;
import com.oceanbase.clogproxy.client.config.ObReaderConfig;
import com.oceanbase.clogproxy.client.exception.LogProxyClientException;
import com.oceanbase.clogproxy.client.listener.RecordListener;
import com.oceanbase.oms.logmessage.DataMessage;
import com.oceanbase.oms.logmessage.LogMessage;
import com.ververica.cdc.connectors.oceanbase.source.OceanBaseConnection;
import com.ververica.cdc.connectors.oceanbase.table.OceanBaseDeserializationSchema;
import com.ververica.cdc.connectors.oceanbase.table.OceanBaseRecord;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.state.CheckpointListener;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.source.RichSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.util.Collector;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OceanBaseRichSourceFunction<T>
extends RichSourceFunction<T>
implements CheckpointListener,
CheckpointedFunction,
ResultTypeQueryable<T> {
    private static final long serialVersionUID = 2844054619864617340L;
    private static final Logger LOG = LoggerFactory.getLogger(OceanBaseRichSourceFunction.class);
    private final boolean snapshot;
    private final String username;
    private final String password;
    private final String tenantName;
    private final String databaseName;
    private final String tableName;
    private final String tableList;
    private final Duration connectTimeout;
    private final String hostname;
    private final Integer port;
    private final String logProxyHost;
    private final int logProxyPort;
    private final ClientConf logProxyClientConf;
    private final ObReaderConfig obReaderConfig;
    private final OceanBaseDeserializationSchema<T> deserializer;
    private final AtomicBoolean snapshotCompleted = new AtomicBoolean(false);
    private final List<LogMessage> logMessageBuffer = new LinkedList<LogMessage>();
    private transient Set<String> tableSet;
    private volatile transient long resolvedTimestamp;
    private volatile transient OceanBaseConnection snapshotConnection;
    private transient LogProxyClient logProxyClient;
    private transient ListState<Long> offsetState;
    private transient OutputCollector<T> outputCollector;

    public OceanBaseRichSourceFunction(boolean snapshot, String username, String password, String tenantName, String databaseName, String tableName, String tableList, Duration connectTimeout, String hostname, Integer port, String logProxyHost, int logProxyPort, ClientConf logProxyClientConf, ObReaderConfig obReaderConfig, OceanBaseDeserializationSchema<T> deserializer) {
        this.snapshot = (Boolean)Preconditions.checkNotNull((Object)snapshot);
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.password = (String)Preconditions.checkNotNull((Object)password);
        this.tenantName = (String)Preconditions.checkNotNull((Object)tenantName);
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.tableList = tableList;
        this.connectTimeout = (Duration)Preconditions.checkNotNull((Object)connectTimeout);
        this.hostname = hostname;
        this.port = port;
        this.logProxyHost = (String)Preconditions.checkNotNull((Object)logProxyHost);
        this.logProxyPort = (Integer)Preconditions.checkNotNull((Object)logProxyPort);
        this.logProxyClientConf = (ClientConf)Preconditions.checkNotNull((Object)logProxyClientConf);
        this.obReaderConfig = (ObReaderConfig)Preconditions.checkNotNull((Object)obReaderConfig);
        this.deserializer = (OceanBaseDeserializationSchema)Preconditions.checkNotNull(deserializer);
    }

    public void open(Configuration config) throws Exception {
        super.open(config);
        this.outputCollector = new OutputCollector();
        this.resolvedTimestamp = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(SourceFunction.SourceContext<T> ctx) throws Exception {
        ((OutputCollector)this.outputCollector).context = ctx;
        LOG.info("Start to initial table whitelist");
        this.initTableWhiteList();
        LOG.info("Start readChangeRecords process");
        this.readChangeRecords();
        if (this.shouldReadSnapshot()) {
            Object object = ctx.getCheckpointLock();
            synchronized (object) {
                try {
                    this.readSnapshotRecords();
                }
                finally {
                    this.closeSnapshotConnection();
                }
                LOG.info("Snapshot reading finished");
            }
        }
        LOG.info("Skip snapshot reading");
        this.logProxyClient.join();
    }

    private boolean shouldReadSnapshot() {
        return this.resolvedTimestamp == -1L && this.snapshot;
    }

    private OceanBaseConnection getSnapshotConnection() {
        if (this.snapshotConnection == null) {
            this.snapshotConnection = new OceanBaseConnection(this.hostname, this.port, this.username, this.password, this.connectTimeout, ((Object)((Object)this)).getClass().getClassLoader());
        }
        return this.snapshotConnection;
    }

    private void closeSnapshotConnection() {
        if (this.snapshotConnection != null) {
            try {
                this.snapshotConnection.close();
            }
            catch (SQLException e) {
                LOG.error("Failed to close snapshotConnection", (Throwable)e);
            }
            this.snapshotConnection = null;
        }
    }

    private void initTableWhiteList() {
        if (this.tableSet != null && !this.tableSet.isEmpty()) {
            return;
        }
        HashSet<String> localTableSet = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)this.tableList)) {
            for (String s : this.tableList.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                String[] schema = s.split("\\.");
                localTableSet.add(String.format("%s.%s", schema[0].trim(), schema[1].trim()));
            }
        }
        if (this.shouldReadSnapshot() && StringUtils.isNotBlank((CharSequence)this.databaseName) && StringUtils.isNotBlank((CharSequence)this.tableName)) {
            try {
                String sql = String.format("SELECT TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE='BASE TABLE' and TABLE_SCHEMA REGEXP '%s' and TABLE_NAME REGEXP '%s'", this.databaseName, this.tableName);
                this.getSnapshotConnection().query(sql, rs -> {
                    while (rs.next()) {
                        localTableSet.add(String.format("%s.%s", rs.getString(1), rs.getString(2)));
                    }
                });
            }
            catch (SQLException e) {
                LOG.error("Query database and table name failed", (Throwable)e);
                throw new FlinkRuntimeException((Throwable)e);
            }
        }
        if (localTableSet.isEmpty()) {
            throw new FlinkRuntimeException("No valid table found");
        }
        this.tableSet = localTableSet;
        this.obReaderConfig.setTableWhiteList(localTableSet.stream().map(table -> String.format("%s.%s", this.tenantName, table)).collect(Collectors.joining("|")));
    }

    protected void readSnapshotRecords() {
        this.tableSet.forEach(table -> {
            String[] schema = table.split("\\.");
            this.readSnapshotRecordsByTable(schema[0], schema[1]);
        });
        this.snapshotCompleted.set(true);
    }

    private void readSnapshotRecordsByTable(String databaseName, String tableName) {
        OceanBaseRecord.SourceInfo sourceInfo = new OceanBaseRecord.SourceInfo(this.tenantName, databaseName, tableName, this.resolvedTimestamp);
        String fullName = String.format("`%s`.`%s`", databaseName, tableName);
        String selectSql = "SELECT * FROM " + fullName;
        try {
            LOG.info("Start to read snapshot from {}", (Object)fullName);
            this.getSnapshotConnection().query(selectSql, rs -> {
                ResultSetMetaData metaData = rs.getMetaData();
                while (rs.next()) {
                    HashMap<String, Object> fieldMap = new HashMap<String, Object>();
                    for (int i = 0; i < metaData.getColumnCount(); ++i) {
                        fieldMap.put(metaData.getColumnName(i + 1), rs.getObject(i + 1));
                    }
                    OceanBaseRecord record = new OceanBaseRecord(sourceInfo, fieldMap);
                    try {
                        this.deserializer.deserialize(record, this.outputCollector);
                    }
                    catch (Exception e) {
                        LOG.error("Deserialize snapshot record failed ", (Throwable)e);
                        throw new FlinkRuntimeException((Throwable)e);
                    }
                }
            });
            LOG.info("Read snapshot from {} finished", (Object)fullName);
        }
        catch (SQLException e) {
            LOG.error("Read snapshot from table " + fullName + " failed", (Throwable)e);
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    protected void readChangeRecords() throws InterruptedException, TimeoutException {
        if (this.resolvedTimestamp > 0L) {
            this.obReaderConfig.updateCheckpoint(Long.toString(this.resolvedTimestamp));
            LOG.info("Read change events from resolvedTimestamp: {}", (Object)this.resolvedTimestamp);
        }
        this.logProxyClient = new LogProxyClient(this.logProxyHost, this.logProxyPort, (AbstractConnectionConfig)this.obReaderConfig, this.logProxyClientConf);
        final CountDownLatch latch = new CountDownLatch(1);
        this.logProxyClient.addListener(new RecordListener(){
            boolean started = false;

            public void notify(LogMessage message) {
                switch (message.getOpt()) {
                    case HEARTBEAT: 
                    case BEGIN: {
                        if (this.started) break;
                        this.started = true;
                        latch.countDown();
                        break;
                    }
                    case INSERT: 
                    case UPDATE: 
                    case DELETE: {
                        if (!this.started) break;
                        OceanBaseRichSourceFunction.this.logMessageBuffer.add(message);
                        break;
                    }
                    case COMMIT: {
                        if (OceanBaseRichSourceFunction.this.shouldReadSnapshot() && !OceanBaseRichSourceFunction.this.snapshotCompleted.get()) break;
                        OceanBaseRichSourceFunction.this.logMessageBuffer.forEach(msg -> {
                            try {
                                OceanBaseRichSourceFunction.this.deserializer.deserialize(OceanBaseRichSourceFunction.this.getChangeRecord(msg), OceanBaseRichSourceFunction.this.outputCollector);
                            }
                            catch (Exception e) {
                                throw new FlinkRuntimeException((Throwable)e);
                            }
                        });
                        OceanBaseRichSourceFunction.this.logMessageBuffer.clear();
                        long timestamp = OceanBaseRichSourceFunction.this.getCheckpointTimestamp(message);
                        if (timestamp <= OceanBaseRichSourceFunction.this.resolvedTimestamp) break;
                        OceanBaseRichSourceFunction.this.resolvedTimestamp = timestamp;
                        break;
                    }
                    case DDL: {
                        LOG.trace("Ddl: {}", (Object)((DataMessage.Record.Field)message.getFieldList().get(0)).getValue().toString());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported type: " + message.getOpt());
                    }
                }
            }

            public void onException(LogProxyClientException e) {
                LOG.error("LogProxyClient exception", (Throwable)e);
                OceanBaseRichSourceFunction.this.logProxyClient.stop();
            }
        });
        this.logProxyClient.start();
        LOG.info("LogProxyClient started");
        if (!latch.await(this.connectTimeout.getSeconds(), TimeUnit.SECONDS)) {
            throw new TimeoutException("Timeout to receive messages in RecordListener");
        }
        LOG.info("LogProxyClient packet processing started");
    }

    private OceanBaseRecord getChangeRecord(LogMessage message) {
        String databaseName = message.getDbName().replace(this.tenantName + ".", "");
        OceanBaseRecord.SourceInfo sourceInfo = new OceanBaseRecord.SourceInfo(this.tenantName, databaseName, message.getTableName(), this.getCheckpointTimestamp(message));
        return new OceanBaseRecord(sourceInfo, message.getOpt(), message.getFieldList());
    }

    private long getCheckpointTimestamp(LogMessage message) {
        long timestamp = -1L;
        try {
            timestamp = DataMessage.Record.Type.HEARTBEAT.equals((Object)message.getOpt()) ? Long.parseLong(message.getTimestamp()) : message.getFileNameOffset();
        }
        catch (Throwable t) {
            LOG.error("Failed to get checkpoint from log message", t);
        }
        return timestamp;
    }

    public void notifyCheckpointComplete(long l) {
    }

    public TypeInformation<T> getProducedType() {
        return this.deserializer.getProducedType();
    }

    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        LOG.info("snapshotState checkpoint: {} at resolvedTimestamp: {}", (Object)context.getCheckpointId(), (Object)this.resolvedTimestamp);
        this.offsetState.clear();
        this.offsetState.add((Object)this.resolvedTimestamp);
    }

    public void initializeState(FunctionInitializationContext context) throws Exception {
        Iterator iterator;
        LOG.info("initialize checkpoint");
        this.offsetState = context.getOperatorStateStore().getListState(new ListStateDescriptor("resolvedTimestampState", (TypeSerializer)LongSerializer.INSTANCE));
        if (context.isRestored() && (iterator = ((Iterable)this.offsetState.get()).iterator()).hasNext()) {
            Long offset = (Long)iterator.next();
            this.resolvedTimestamp = offset;
            LOG.info("Restore State from resolvedTimestamp: {}", (Object)this.resolvedTimestamp);
            return;
        }
    }

    public void cancel() {
        this.closeSnapshotConnection();
        if (this.logProxyClient != null) {
            this.logProxyClient.stop();
        }
    }

    private static class OutputCollector<T>
    implements Collector<T> {
        private SourceFunction.SourceContext<T> context;

        private OutputCollector() {
        }

        public void collect(T record) {
            this.context.collect(record);
        }

        public void close() {
        }
    }
}

