/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oceanbase.source;

import com.oceanbase.oms.logmessage.ByteString;
import com.ververica.cdc.connectors.oceanbase.source.OceanBaseDeserializationRuntimeConverter;
import com.ververica.cdc.connectors.oceanbase.table.OceanBaseAppendMetadataCollector;
import com.ververica.cdc.connectors.oceanbase.table.OceanBaseDeserializationSchema;
import com.ververica.cdc.connectors.oceanbase.table.OceanBaseMetadataConverter;
import com.ververica.cdc.connectors.oceanbase.table.OceanBaseRecord;
import com.ververica.cdc.debezium.utils.TemporalConversions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class RowDataOceanBaseDeserializationSchema
implements OceanBaseDeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final TypeInformation<RowData> resultTypeInfo;
    private final OceanBaseDeserializationRuntimeConverter physicalConverter;
    private final boolean hasMetadata;
    private final OceanBaseAppendMetadataCollector appendMetadataCollector;

    public static Builder newBuilder() {
        return new Builder();
    }

    RowDataOceanBaseDeserializationSchema(RowType physicalDataType, OceanBaseMetadataConverter[] metadataConverters, TypeInformation<RowData> resultTypeInfo, ZoneId serverTimeZone) {
        this.hasMetadata = ((OceanBaseMetadataConverter[])Preconditions.checkNotNull((Object)metadataConverters)).length > 0;
        this.appendMetadataCollector = new OceanBaseAppendMetadataCollector(metadataConverters);
        this.physicalConverter = RowDataOceanBaseDeserializationSchema.createConverter((LogicalType)Preconditions.checkNotNull((Object)physicalDataType), serverTimeZone);
        this.resultTypeInfo = (TypeInformation)Preconditions.checkNotNull(resultTypeInfo);
    }

    @Override
    public void deserialize(OceanBaseRecord record, Collector<RowData> out) throws Exception {
        if (record.isSnapshotRecord()) {
            GenericRowData physicalRow = (GenericRowData)this.physicalConverter.convert(record.getJdbcFields());
            physicalRow.setRowKind(RowKind.INSERT);
            this.emit(record, (RowData)physicalRow, out);
        } else {
            switch (record.getOpt()) {
                case INSERT: {
                    GenericRowData physicalRow = (GenericRowData)this.physicalConverter.convert(record.getLogMessageFieldsAfter());
                    physicalRow.setRowKind(RowKind.INSERT);
                    this.emit(record, (RowData)physicalRow, out);
                    break;
                }
                case DELETE: {
                    GenericRowData physicalRow = (GenericRowData)this.physicalConverter.convert(record.getLogMessageFieldsBefore());
                    physicalRow.setRowKind(RowKind.DELETE);
                    this.emit(record, (RowData)physicalRow, out);
                    break;
                }
                case UPDATE: {
                    GenericRowData physicalRow = (GenericRowData)this.physicalConverter.convert(record.getLogMessageFieldsBefore());
                    physicalRow.setRowKind(RowKind.UPDATE_BEFORE);
                    this.emit(record, (RowData)physicalRow, out);
                    physicalRow = (GenericRowData)this.physicalConverter.convert(record.getLogMessageFieldsAfter());
                    physicalRow.setRowKind(RowKind.UPDATE_AFTER);
                    this.emit(record, (RowData)physicalRow, out);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported log message record type: " + record.getOpt());
                }
            }
        }
    }

    private void emit(OceanBaseRecord row, RowData physicalRow, Collector<RowData> collector) {
        if (!this.hasMetadata) {
            collector.collect((Object)physicalRow);
            return;
        }
        this.appendMetadataCollector.inputRecord = row;
        this.appendMetadataCollector.outputCollector = collector;
        this.appendMetadataCollector.collect(physicalRow);
    }

    public TypeInformation<RowData> getProducedType() {
        return this.resultTypeInfo;
    }

    private static OceanBaseDeserializationRuntimeConverter createConverter(LogicalType type, ZoneId serverTimeZone) {
        return RowDataOceanBaseDeserializationSchema.wrapIntoNullableConverter(RowDataOceanBaseDeserializationSchema.createNotNullConverter(type, serverTimeZone));
    }

    private static OceanBaseDeserializationRuntimeConverter wrapIntoNullableConverter(final OceanBaseDeserializationRuntimeConverter converter) {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object) throws Exception {
                if (object == null) {
                    return null;
                }
                return converter.convert(object);
            }
        };
    }

    public static OceanBaseDeserializationRuntimeConverter createNotNullConverter(LogicalType type, ZoneId serverTimeZone) {
        switch (type.getTypeRoot()) {
            case ROW: {
                return RowDataOceanBaseDeserializationSchema.createRowConverter((RowType)type, serverTimeZone);
            }
            case NULL: {
                return RowDataOceanBaseDeserializationSchema.convertToNull();
            }
            case BOOLEAN: {
                return RowDataOceanBaseDeserializationSchema.convertToBoolean();
            }
            case TINYINT: {
                return RowDataOceanBaseDeserializationSchema.convertToTinyInt();
            }
            case SMALLINT: {
                return RowDataOceanBaseDeserializationSchema.convertToSmallInt();
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return RowDataOceanBaseDeserializationSchema.convertToInt();
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return RowDataOceanBaseDeserializationSchema.convertToLong();
            }
            case DATE: {
                return RowDataOceanBaseDeserializationSchema.convertToDate();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return RowDataOceanBaseDeserializationSchema.convertToTime();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return RowDataOceanBaseDeserializationSchema.convertToTimestamp();
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return RowDataOceanBaseDeserializationSchema.convertToLocalTimeZoneTimestamp(serverTimeZone);
            }
            case FLOAT: {
                return RowDataOceanBaseDeserializationSchema.convertToFloat();
            }
            case DOUBLE: {
                return RowDataOceanBaseDeserializationSchema.convertToDouble();
            }
            case CHAR: 
            case VARCHAR: {
                return RowDataOceanBaseDeserializationSchema.convertToString();
            }
            case BINARY: {
                return RowDataOceanBaseDeserializationSchema.convertToBinary();
            }
            case VARBINARY: {
                return RowDataOceanBaseDeserializationSchema.convertToBytes();
            }
            case DECIMAL: {
                return RowDataOceanBaseDeserializationSchema.createDecimalConverter((DecimalType)type);
            }
            case ARRAY: {
                return RowDataOceanBaseDeserializationSchema.createArrayConverter();
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private static OceanBaseDeserializationRuntimeConverter createRowConverter(RowType rowType, ZoneId serverTimeZone) {
        final OceanBaseDeserializationRuntimeConverter[] fieldConverters = (OceanBaseDeserializationRuntimeConverter[])rowType.getFields().stream().map(RowType.RowField::getType).map(logicType -> RowDataOceanBaseDeserializationSchema.createConverter(logicType, serverTimeZone)).toArray(OceanBaseDeserializationRuntimeConverter[]::new);
        final String[] fieldNames = rowType.getFieldNames().toArray(new String[0]);
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object) throws Exception {
                int arity = fieldNames.length;
                GenericRowData row = new GenericRowData(arity);
                Map fieldMap = (Map)object;
                for (int i = 0; i < arity; ++i) {
                    String fieldName = fieldNames[i];
                    row.setField(i, fieldConverters[i].convert(fieldMap.get(fieldName)));
                }
                return row;
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter convertToNull() {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object) {
                return null;
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter convertToBoolean() {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convertSnapshotEvent(Object object) {
                if (object instanceof byte[]) {
                    return "1".equals(new String((byte[])object, StandardCharsets.UTF_8));
                }
                return Boolean.parseBoolean(object.toString()) || "1".equals(object.toString());
            }

            @Override
            public Object convertChangeEvent(String string) {
                return "1".equals(string);
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter convertToTinyInt() {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convertSnapshotEvent(Object object) {
                return Byte.parseByte(object.toString());
            }

            @Override
            public Object convertChangeEvent(String string) {
                return Byte.parseByte(string);
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter convertToSmallInt() {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convertSnapshotEvent(Object object) {
                return Short.parseShort(object.toString());
            }

            @Override
            public Object convertChangeEvent(String string) {
                return Short.parseShort(string);
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter convertToInt() {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convertSnapshotEvent(Object object) {
                if (object instanceof Integer) {
                    return object;
                }
                if (object instanceof Long) {
                    return ((Long)object).intValue();
                }
                if (object instanceof Date) {
                    return ((Date)object).toLocalDate().getYear();
                }
                return Integer.parseInt(object.toString());
            }

            @Override
            public Object convertChangeEvent(String string) {
                return Integer.parseInt(string);
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter convertToLong() {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convertSnapshotEvent(Object object) {
                if (object instanceof Integer) {
                    return ((Integer)object).longValue();
                }
                if (object instanceof Long) {
                    return object;
                }
                return Long.parseLong(object.toString());
            }

            @Override
            public Object convertChangeEvent(String string) {
                return Long.parseLong(string);
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter convertToDouble() {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convertSnapshotEvent(Object object) {
                if (object instanceof Float) {
                    return ((Float)object).doubleValue();
                }
                if (object instanceof Double) {
                    return object;
                }
                return Double.parseDouble(object.toString());
            }

            @Override
            public Object convertChangeEvent(String string) {
                return Double.parseDouble(string);
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter convertToFloat() {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convertSnapshotEvent(Object object) {
                if (object instanceof Float) {
                    return object;
                }
                if (object instanceof Double) {
                    return Float.valueOf(((Double)object).floatValue());
                }
                return Float.valueOf(Float.parseFloat(object.toString()));
            }

            @Override
            public Object convertChangeEvent(String string) {
                return Float.valueOf(Float.parseFloat(string));
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter convertToDate() {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convertSnapshotEvent(Object object) {
                return (int)TemporalConversions.toLocalDate((Object)object).toEpochDay();
            }

            @Override
            public Object convertChangeEvent(String string) {
                return (int)Date.valueOf(string).toLocalDate().toEpochDay();
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter convertToTime() {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convertSnapshotEvent(Object object) {
                if (object instanceof Long) {
                    return (int)((Long)object / 1000000L);
                }
                return TemporalConversions.toLocalTime((Object)object).toSecondOfDay() * 1000;
            }

            @Override
            public Object convertChangeEvent(String string) {
                return TemporalConversions.toLocalTime((Object)Time.valueOf(string)).toSecondOfDay() * 1000;
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter convertToTimestamp() {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convertSnapshotEvent(Object object) {
                if (object instanceof Timestamp) {
                    return TimestampData.fromLocalDateTime((LocalDateTime)((Timestamp)object).toLocalDateTime());
                }
                throw new IllegalArgumentException("Unable to convert to TimestampData from unexpected value '" + object + "' of type " + object.getClass().getName());
            }

            @Override
            public Object convertChangeEvent(String string) {
                return TimestampData.fromLocalDateTime((LocalDateTime)Timestamp.valueOf(string).toLocalDateTime());
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter convertToLocalTimeZoneTimestamp(final ZoneId serverTimeZone) {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convertSnapshotEvent(Object object) {
                if (object instanceof Timestamp) {
                    return TimestampData.fromInstant((Instant)((Timestamp)object).toLocalDateTime().atZone(serverTimeZone).toInstant());
                }
                throw new IllegalArgumentException("Unable to convert to TimestampData from unexpected value '" + object + "' of type " + object.getClass().getName());
            }

            @Override
            public Object convertChangeEvent(String string) {
                return TimestampData.fromInstant((Instant)Timestamp.valueOf(string).toLocalDateTime().atZone(serverTimeZone).toInstant());
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter convertToString() {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convertSnapshotEvent(Object object) {
                return StringData.fromString((String)object.toString());
            }

            @Override
            public Object convertChangeEvent(String string) {
                return StringData.fromString((String)string);
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter convertToBinary() {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convertSnapshotEvent(Object object) {
                if (object instanceof byte[]) {
                    String str = new String((byte[])object, StandardCharsets.US_ASCII);
                    return str.getBytes(StandardCharsets.UTF_8);
                }
                if (object instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)object;
                    byte[] bytes = new byte[byteBuffer.remaining()];
                    byteBuffer.get(bytes);
                    return bytes;
                }
                throw new UnsupportedOperationException("Unsupported BINARY value type: " + object.getClass().getSimpleName());
            }

            @Override
            public Object convertChangeEvent(String string) {
                try {
                    int i;
                    long v = Long.parseLong(string);
                    byte[] bytes = ByteBuffer.allocate(8).putLong(v).array();
                    for (i = 0; i < 7 && bytes[i] == 0; ++i) {
                    }
                    return Arrays.copyOfRange(bytes, i, 8);
                }
                catch (NumberFormatException e) {
                    return string.getBytes(StandardCharsets.UTF_8);
                }
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter convertToBytes() {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convertSnapshotEvent(Object object) {
                if (object instanceof byte[]) {
                    return object;
                }
                if (object instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)object;
                    byte[] bytes = new byte[byteBuffer.remaining()];
                    byteBuffer.get(bytes);
                    return bytes;
                }
                throw new UnsupportedOperationException("Unsupported BYTES value type: " + object.getClass().getSimpleName());
            }

            @Override
            public Object convertChangeEvent(String string) {
                return string.getBytes(StandardCharsets.UTF_8);
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter createDecimalConverter(DecimalType decimalType) {
        final int precision = decimalType.getPrecision();
        final int scale = decimalType.getScale();
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convertSnapshotEvent(Object object) {
                BigDecimal bigDecimal;
                if (object instanceof String) {
                    bigDecimal = new BigDecimal((String)object);
                } else if (object instanceof Long) {
                    bigDecimal = new BigDecimal((Long)object);
                } else if (object instanceof BigInteger) {
                    bigDecimal = new BigDecimal((BigInteger)object);
                } else if (object instanceof Double) {
                    bigDecimal = BigDecimal.valueOf((Double)object);
                } else if (object instanceof BigDecimal) {
                    bigDecimal = (BigDecimal)object;
                } else {
                    throw new IllegalArgumentException("Unable to convert to decimal from unexpected value '" + object + "' of type " + object.getClass());
                }
                return DecimalData.fromBigDecimal((BigDecimal)bigDecimal, (int)precision, (int)scale);
            }

            @Override
            public Object convertChangeEvent(String string) {
                return DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(string), (int)precision, (int)scale);
            }
        };
    }

    private static OceanBaseDeserializationRuntimeConverter createArrayConverter() {
        return new OceanBaseDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object) {
                String s = object instanceof ByteString ? ((ByteString)object).toString(StandardCharsets.UTF_8.name()) : object.toString();
                String[] strArray = s.split(",");
                Object[] stringDataArray = new StringData[strArray.length];
                for (int i = 0; i < strArray.length; ++i) {
                    stringDataArray[i] = StringData.fromString((String)strArray[i]);
                }
                return new GenericArrayData(stringDataArray);
            }
        };
    }

    public static class Builder {
        private RowType physicalRowType;
        private TypeInformation<RowData> resultTypeInfo;
        private OceanBaseMetadataConverter[] metadataConverters = new OceanBaseMetadataConverter[0];
        private ZoneId serverTimeZone = ZoneId.of("UTC");

        public Builder setPhysicalRowType(RowType physicalRowType) {
            this.physicalRowType = physicalRowType;
            return this;
        }

        public Builder setMetadataConverters(OceanBaseMetadataConverter[] metadataConverters) {
            this.metadataConverters = metadataConverters;
            return this;
        }

        public Builder setResultTypeInfo(TypeInformation<RowData> resultTypeInfo) {
            this.resultTypeInfo = resultTypeInfo;
            return this;
        }

        public Builder setServerTimeZone(ZoneId serverTimeZone) {
            this.serverTimeZone = serverTimeZone;
            return this;
        }

        public RowDataOceanBaseDeserializationSchema build() {
            return new RowDataOceanBaseDeserializationSchema(this.physicalRowType, this.metadataConverters, this.resultTypeInfo, this.serverTimeZone);
        }
    }
}

