/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oceanbase.table;

import com.ververica.cdc.connectors.oceanbase.table.OceanBaseMetadataConverter;
import com.ververica.cdc.connectors.oceanbase.table.OceanBaseRecord;
import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.util.Collector;

@Internal
public class OceanBaseAppendMetadataCollector
implements Collector<RowData>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final OceanBaseMetadataConverter[] metadataConverters;
    public transient OceanBaseRecord inputRecord;
    public transient Collector<RowData> outputCollector;

    public OceanBaseAppendMetadataCollector(OceanBaseMetadataConverter[] metadataConverters) {
        this.metadataConverters = metadataConverters;
    }

    public void collect(RowData physicalRow) {
        GenericRowData metaRow = new GenericRowData(this.metadataConverters.length);
        for (int i = 0; i < this.metadataConverters.length; ++i) {
            Object meta = this.metadataConverters[i].read(this.inputRecord);
            metaRow.setField(i, meta);
        }
        JoinedRowData outRow = new JoinedRowData(physicalRow.getRowKind(), physicalRow, (RowData)metaRow);
        this.outputCollector.collect((Object)outRow);
    }

    public void close() {
    }
}

