/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oceanbase.table;

import com.ververica.cdc.connectors.oceanbase.table.OceanBaseMetadataConverter;
import com.ververica.cdc.connectors.oceanbase.table.OceanBaseRecord;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;

public enum OceanBaseReadableMetadata {
    TENANT("tenant_name", (DataType)DataTypes.STRING().notNull(), new OceanBaseMetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(OceanBaseRecord record) {
            return StringData.fromString((String)record.getSourceInfo().getTenant());
        }
    }),
    DATABASE("database_name", (DataType)DataTypes.STRING().notNull(), new OceanBaseMetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(OceanBaseRecord record) {
            return StringData.fromString((String)record.getSourceInfo().getDatabase());
        }
    }),
    TABLE("table_name", (DataType)DataTypes.STRING().notNull(), new OceanBaseMetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(OceanBaseRecord record) {
            return StringData.fromString((String)record.getSourceInfo().getTable());
        }
    }),
    OP_TS("op_ts", (DataType)DataTypes.TIMESTAMP_LTZ((int)3).notNull(), new OceanBaseMetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(OceanBaseRecord record) {
            return TimestampData.fromEpochMillis((long)(record.getSourceInfo().getTimestampS() * 1000L));
        }
    });

    private final String key;
    private final DataType dataType;
    private final OceanBaseMetadataConverter converter;

    private OceanBaseReadableMetadata(String key, DataType dataType, OceanBaseMetadataConverter converter) {
        this.key = key;
        this.dataType = dataType;
        this.converter = converter;
    }

    public String getKey() {
        return this.key;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public OceanBaseMetadataConverter getConverter() {
        return this.converter;
    }
}

