/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oceanbase.table;

import com.oceanbase.oms.logmessage.ByteString;
import com.oceanbase.oms.logmessage.DataMessage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OceanBaseRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SourceInfo sourceInfo;
    private final boolean isSnapshotRecord;
    private Map<String, Object> jdbcFields;
    private DataMessage.Record.Type opt;
    private Map<String, ByteString> logMessageFieldsBefore;
    private Map<String, ByteString> logMessageFieldsAfter;

    public OceanBaseRecord(SourceInfo sourceInfo, Map<String, Object> jdbcFields) {
        this.sourceInfo = sourceInfo;
        this.isSnapshotRecord = true;
        this.jdbcFields = jdbcFields;
    }

    public OceanBaseRecord(SourceInfo sourceInfo, DataMessage.Record.Type opt, List<DataMessage.Record.Field> logMessageFieldList) {
        this.sourceInfo = sourceInfo;
        this.isSnapshotRecord = false;
        this.opt = opt;
        this.logMessageFieldsBefore = new HashMap<String, ByteString>();
        this.logMessageFieldsAfter = new HashMap<String, ByteString>();
        for (DataMessage.Record.Field field : logMessageFieldList) {
            if (field.isPrev()) {
                this.logMessageFieldsBefore.put(field.getFieldname(), field.getValue());
                continue;
            }
            this.logMessageFieldsAfter.put(field.getFieldname(), field.getValue());
        }
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public boolean isSnapshotRecord() {
        return this.isSnapshotRecord;
    }

    public Map<String, Object> getJdbcFields() {
        return this.jdbcFields;
    }

    public DataMessage.Record.Type getOpt() {
        return this.opt;
    }

    public Map<String, ByteString> getLogMessageFieldsBefore() {
        return this.logMessageFieldsBefore;
    }

    public Map<String, ByteString> getLogMessageFieldsAfter() {
        return this.logMessageFieldsAfter;
    }

    public static class SourceInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String tenant;
        private final String database;
        private final String table;
        private final long timestampS;

        public SourceInfo(String tenant, String database, String table, long timestampS) {
            this.tenant = tenant;
            this.database = database;
            this.table = table;
            this.timestampS = timestampS;
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getTable() {
            return this.table;
        }

        public long getTimestampS() {
            return this.timestampS;
        }
    }
}

