/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oceanbase.table;

import com.ververica.cdc.connectors.oceanbase.table.OceanBaseTableSource;
import com.ververica.cdc.connectors.oceanbase.table.StartupMode;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;

public class OceanBaseTableSourceFactory
implements DynamicTableSourceFactory {
    private static final String IDENTIFIER = "oceanbase-cdc";
    public static final ConfigOption<String> SCAN_STARTUP_MODE = ConfigOptions.key((String)"scan.startup.mode").stringType().noDefaultValue().withDescription("Optional startup mode for OceanBase CDC consumer, valid enumerations are \"initial\", \"latest-offset\" or \"timestamp\"");
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("Username to be used when connecting to OceanBase.");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("Password to be used when connecting to OceanBase.");
    public static final ConfigOption<String> TENANT_NAME = ConfigOptions.key((String)"tenant-name").stringType().noDefaultValue().withDescription("Tenant name of OceanBase to monitor.");
    public static final ConfigOption<String> DATABASE_NAME = ConfigOptions.key((String)"database-name").stringType().noDefaultValue().withDescription("Database name of OceanBase to monitor, should be regular expression. Only can be used with 'initial' mode.");
    public static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("Table name of OceanBase to monitor, should be regular expression. Only can be used with 'initial' mode.");
    public static final ConfigOption<String> TABLE_LIST = ConfigOptions.key((String)"table-list").stringType().noDefaultValue().withDescription("List of full names of tables, separated by commas, e.g. \"db1.table1, db2.table2\".");
    public static final ConfigOption<String> SERVER_TIME_ZONE = ConfigOptions.key((String)"server-time-zone").stringType().defaultValue((Object)"+00:00").withDescription("The session time zone in database server.");
    public static final ConfigOption<Duration> CONNECT_TIMEOUT = ConfigOptions.key((String)"connect.timeout").durationType().defaultValue((Object)Duration.ofSeconds(30L)).withDescription("The maximum time that the connector should wait after trying to connect to the database server or log proxy server before timing out.");
    public static final ConfigOption<String> HOSTNAME = ConfigOptions.key((String)"hostname").stringType().noDefaultValue().withDescription("IP address or hostname of the OceanBase database server or OceanBase proxy server.");
    public static final ConfigOption<Integer> PORT = ConfigOptions.key((String)"port").intType().noDefaultValue().withDescription("Integer port number of OceanBase database server or OceanBase proxy server.");
    public static final ConfigOption<String> LOG_PROXY_HOST = ConfigOptions.key((String)"logproxy.host").stringType().noDefaultValue().withDescription("Hostname or IP address of OceanBase log proxy service.");
    public static final ConfigOption<Integer> LOG_PROXY_PORT = ConfigOptions.key((String)"logproxy.port").intType().noDefaultValue().withDescription("Port number of OceanBase log proxy service.");
    public static final ConfigOption<String> LOG_PROXY_CLIENT_ID = ConfigOptions.key((String)"logproxy.client.id").stringType().noDefaultValue().withDescription("Id of log proxy client, used to distinguish different connections.");
    public static final ConfigOption<Long> SCAN_STARTUP_TIMESTAMP = ConfigOptions.key((String)"scan.startup.timestamp").longType().noDefaultValue().withDescription("Optional timestamp in seconds used in case of \"timestamp\" startup mode.");
    public static final ConfigOption<String> RS_LIST = ConfigOptions.key((String)"rootserver-list").stringType().noDefaultValue().withDescription("The semicolon-separated list of root servers in format `ip:rpc_port:sql_port`, corresponding to the parameter 'rootservice_list' in the database.");
    public static final ConfigOption<String> CONFIG_URL = ConfigOptions.key((String)"config-url").stringType().noDefaultValue().withDescription("The url used to get root servers list, corresponding to the parameter 'obconfig_url' in the database.");
    public static final ConfigOption<String> WORKING_MODE = ConfigOptions.key((String)"working-mode").stringType().defaultValue((Object)"storage").withDescription("The working mode of 'obcdc', can be `storage` (default value, supported from `obcdc` 3.1.3) or `memory`.");

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validate();
        ResolvedSchema physicalSchema = context.getCatalogTable().getResolvedSchema();
        ReadableConfig config = helper.getOptions();
        StartupMode startupMode = StartupMode.getStartupMode((String)config.get(SCAN_STARTUP_MODE));
        String username = (String)config.get(USERNAME);
        String password = (String)config.get(PASSWORD);
        String tenantName = (String)config.get(TENANT_NAME);
        String databaseName = (String)config.get(DATABASE_NAME);
        String tableName = (String)config.get(TABLE_NAME);
        String tableList = (String)config.get(TABLE_LIST);
        String serverTimeZone = (String)config.get(SERVER_TIME_ZONE);
        Duration connectTimeout = (Duration)config.get(CONNECT_TIMEOUT);
        String hostname = (String)config.get(HOSTNAME);
        Integer port = (Integer)config.get(PORT);
        String logProxyHost = (String)config.get(LOG_PROXY_HOST);
        Integer logProxyPort = (Integer)config.get(LOG_PROXY_PORT);
        String logProxyClientId = (String)config.get(LOG_PROXY_CLIENT_ID);
        Long startupTimestamp = (Long)config.get(SCAN_STARTUP_TIMESTAMP);
        String rsList = (String)config.get(RS_LIST);
        String configUrl = (String)config.get(CONFIG_URL);
        String workingMode = (String)config.get(WORKING_MODE);
        return new OceanBaseTableSource(physicalSchema, startupMode, username, password, tenantName, databaseName, tableName, tableList, serverTimeZone, connectTimeout, hostname, port, logProxyHost, logProxyPort, logProxyClientId, startupTimestamp, rsList, configUrl, workingMode);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(SCAN_STARTUP_MODE);
        options.add(USERNAME);
        options.add(PASSWORD);
        options.add(TENANT_NAME);
        options.add(LOG_PROXY_HOST);
        options.add(LOG_PROXY_PORT);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(SCAN_STARTUP_TIMESTAMP);
        options.add(DATABASE_NAME);
        options.add(TABLE_NAME);
        options.add(TABLE_LIST);
        options.add(HOSTNAME);
        options.add(PORT);
        options.add(CONNECT_TIMEOUT);
        options.add(SERVER_TIME_ZONE);
        options.add(LOG_PROXY_CLIENT_ID);
        options.add(RS_LIST);
        options.add(CONFIG_URL);
        options.add(WORKING_MODE);
        return options;
    }
}

