/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.client.config;

import com.oceanbase.clogproxy.client.config.AbstractConnectionConfig;
import com.oceanbase.clogproxy.client.util.Validator;
import com.oceanbase.clogproxy.common.config.SharedConf;
import com.oceanbase.clogproxy.common.packet.LogType;
import com.oceanbase.clogproxy.common.util.CryptoUtil;
import com.oceanbase.clogproxy.common.util.Hex;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObReaderConfig
extends AbstractConnectionConfig {
    private static final Logger logger = LoggerFactory.getLogger(ObReaderConfig.class);
    private static final AbstractConnectionConfig.ConfigItem<String> RS_LIST = new AbstractConnectionConfig.ConfigItem<String>("rootserver_list", "");
    private static final AbstractConnectionConfig.ConfigItem<String> CLUSTER_USER = new AbstractConnectionConfig.ConfigItem<String>("cluster_user", "");
    private static final AbstractConnectionConfig.ConfigItem<String> CLUSTER_PASSWORD = new AbstractConnectionConfig.ConfigItem<String>("cluster_password", "");
    private static final AbstractConnectionConfig.ConfigItem<String> TABLE_WHITE_LIST = new AbstractConnectionConfig.ConfigItem<String>("tb_white_list", "");
    private static final AbstractConnectionConfig.ConfigItem<Long> START_TIMESTAMP = new AbstractConnectionConfig.ConfigItem<Long>("first_start_timestamp", 0L);

    public ObReaderConfig() {
        super(new HashMap<String, String>());
    }

    public ObReaderConfig(Map<String, String> allConfigs) {
        super(allConfigs);
    }

    @Override
    public LogType getLogType() {
        return LogType.OCEANBASE;
    }

    @Override
    public boolean valid() {
        try {
            Validator.notEmpty((String)ObReaderConfig.RS_LIST.val, "invalid rsList");
            Validator.notEmpty((String)ObReaderConfig.CLUSTER_USER.val, "invalid clusterUser");
            Validator.notEmpty((String)ObReaderConfig.CLUSTER_PASSWORD.val, "invalid clusterPassword");
            if ((Long)ObReaderConfig.START_TIMESTAMP.val < 0L) {
                throw new IllegalArgumentException("invalid startTimestamp");
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    @Override
    public String generateConfigurationString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : configs.entrySet()) {
            String value = ((AbstractConnectionConfig.ConfigItem)entry.getValue()).val.toString();
            if (ObReaderConfig.CLUSTER_PASSWORD.key.equals(entry.getKey()) && SharedConf.AUTH_PASSWORD_HASH) {
                value = Hex.str(CryptoUtil.sha1(value));
            }
            sb.append((String)entry.getKey()).append("=").append(value).append(" ");
        }
        for (Map.Entry entry : this.extraConfigs.entrySet()) {
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append(" ");
        }
        return sb.toString();
    }

    @Override
    public void updateCheckpoint(String checkpoint) {
        try {
            START_TIMESTAMP.set(Long.parseLong(checkpoint));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return "rootserver_list=" + RS_LIST + ", cluster_user=" + CLUSTER_USER + ", cluster_password=******, tb_white_list=" + TABLE_WHITE_LIST + ", start_timestamp=" + START_TIMESTAMP;
    }

    public void setRsList(String rsList) {
        RS_LIST.set(rsList);
    }

    public void setUsername(String clusterUser) {
        CLUSTER_USER.set(clusterUser);
    }

    public void setPassword(String clusterPassword) {
        CLUSTER_PASSWORD.set(clusterPassword);
    }

    public void setTableWhiteList(String tableWhiteList) {
        TABLE_WHITE_LIST.set(tableWhiteList);
    }

    public void setStartTimestamp(Long startTimestamp) {
        START_TIMESTAMP.set(startTimestamp);
    }
}

