/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.oms.logmessage.typehelper;

import com.oceanbase.oms.logmessage.DataMessage;
import com.oceanbase.oms.logmessage.enums.DBType;
import com.oceanbase.oms.logmessage.typehelper.LogTypeHelper;
import org.apache.commons.lang3.StringUtils;

public class OBLogTypeHelper
extends LogTypeHelper {
    public static final OBLogTypeHelper OB_LOG_TYPE_HELPER = new OBLogTypeHelper();
    private static final String DEFAULT_ENCODING = "";

    public OBLogTypeHelper() {
        super(DBType.OCEANBASE1);
    }

    @Override
    public String correctEncoding(int typeCode, String realEncoding) {
        switch (typeCode) {
            case 253: 
            case 254: {
                return realEncoding;
            }
        }
        if (StringUtils.equals(realEncoding, "binary")) {
            return DEFAULT_ENCODING;
        }
        return realEncoding;
    }

    @Override
    public int correctCode(int typeCode, String encoding) {
        switch (typeCode) {
            case 249: 
            case 250: 
            case 251: 
            case 252: {
                if (StringUtils.isEmpty(encoding) || StringUtils.equals(encoding, "binary")) break;
                return 211;
            }
            case 253: {
                if (StringUtils.isEmpty(encoding) || StringUtils.equals(encoding, "binary")) {
                    return 198;
                }
                return 15;
            }
            case 254: {
                if (!StringUtils.isEmpty(encoding) && !StringUtils.equals(encoding, "binary")) break;
                return 199;
            }
        }
        return typeCode;
    }

    @Override
    public void correctField(DataMessage.Record.Field f, String realEncoding) {
        switch (f.type) {
            case 249: 
            case 250: 
            case 251: 
            case 252: {
                if (StringUtils.isEmpty(f.encoding) || StringUtils.equals(f.encoding, "binary")) break;
                f.type = 211;
                break;
            }
            case 253: {
                if (StringUtils.isEmpty(f.encoding) || StringUtils.equals(f.encoding, "binary")) {
                    f.type = 198;
                    break;
                }
                f.type = 15;
                break;
            }
            case 254: {
                if (!StringUtils.isEmpty(f.encoding) && !StringUtils.equals(f.encoding, "binary")) break;
                f.type = 199;
                break;
            }
            default: {
                f.encoding = DEFAULT_ENCODING;
            }
        }
    }
}

