/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.util;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.SslConfigs;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.types.Password;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.WorkerConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SSLUtils {
    private static final Pattern COMMA_WITH_WHITESPACE = Pattern.compile("\\s*,\\s*");

    public static SslContextFactory createServerSideSslContextFactory(WorkerConfig config, String prefix) {
        Map<String, Object> sslConfigValues = config.valuesWithPrefixAllOrNothing(prefix);
        SslContextFactory.Server ssl = new SslContextFactory.Server();
        SSLUtils.configureSslContextFactoryKeyStore((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryTrustStore((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryAlgorithms((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryAuthentication(ssl, sslConfigValues);
        return ssl;
    }

    public static SslContextFactory createServerSideSslContextFactory(WorkerConfig config) {
        return SSLUtils.createServerSideSslContextFactory(config, "listeners.https.");
    }

    public static SslContextFactory createClientSideSslContextFactory(WorkerConfig config) {
        Map<String, Object> sslConfigValues = config.valuesWithPrefixAllOrNothing("listeners.https.");
        SslContextFactory.Client ssl = new SslContextFactory.Client();
        SSLUtils.configureSslContextFactoryKeyStore((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryTrustStore((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryAlgorithms((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryEndpointIdentification((SslContextFactory)ssl, sslConfigValues);
        return ssl;
    }

    protected static void configureSslContextFactoryKeyStore(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        Password sslKeyPassword;
        Password sslKeystorePassword;
        ssl.setKeyStoreType((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.keystore.type", "JKS"));
        String sslKeystoreLocation = (String)sslConfigValues.get("ssl.keystore.location");
        if (sslKeystoreLocation != null) {
            ssl.setKeyStorePath(sslKeystoreLocation);
        }
        if ((sslKeystorePassword = (Password)sslConfigValues.get("ssl.keystore.password")) != null) {
            ssl.setKeyStorePassword(sslKeystorePassword.value());
        }
        if ((sslKeyPassword = (Password)sslConfigValues.get("ssl.key.password")) != null) {
            ssl.setKeyManagerPassword(sslKeyPassword.value());
        }
    }

    protected static Object getOrDefault(Map<String, Object> configMap, String key, Object defaultValue) {
        if (configMap.containsKey(key)) {
            return configMap.get(key);
        }
        return defaultValue;
    }

    protected static void configureSslContextFactoryTrustStore(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        Password sslTruststorePassword;
        ssl.setTrustStoreType((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.truststore.type", "JKS"));
        String sslTruststoreLocation = (String)sslConfigValues.get("ssl.truststore.location");
        if (sslTruststoreLocation != null) {
            ssl.setTrustStorePath(sslTruststoreLocation);
        }
        if ((sslTruststorePassword = (Password)sslConfigValues.get("ssl.truststore.password")) != null) {
            ssl.setTrustStorePassword(sslTruststorePassword.value());
        }
    }

    protected static void configureSslContextFactoryAlgorithms(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        List sslEnabledProtocols = (List)SSLUtils.getOrDefault(sslConfigValues, "ssl.enabled.protocols", Arrays.asList(COMMA_WITH_WHITESPACE.split(SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS)));
        ssl.setIncludeProtocols(sslEnabledProtocols.toArray(new String[sslEnabledProtocols.size()]));
        String sslProvider = (String)sslConfigValues.get("ssl.provider");
        if (sslProvider != null) {
            ssl.setProvider(sslProvider);
        }
        ssl.setProtocol((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.protocol", SslConfigs.DEFAULT_SSL_PROTOCOL));
        List sslCipherSuites = (List)sslConfigValues.get("ssl.cipher.suites");
        if (sslCipherSuites != null) {
            ssl.setIncludeCipherSuites(sslCipherSuites.toArray(new String[sslCipherSuites.size()]));
        }
        ssl.setKeyManagerFactoryAlgorithm((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.keymanager.algorithm", SslConfigs.DEFAULT_SSL_KEYMANGER_ALGORITHM));
        String sslSecureRandomImpl = (String)sslConfigValues.get("ssl.secure.random.implementation");
        if (sslSecureRandomImpl != null) {
            ssl.setSecureRandomAlgorithm(sslSecureRandomImpl);
        }
        ssl.setTrustManagerFactoryAlgorithm((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.trustmanager.algorithm", SslConfigs.DEFAULT_SSL_TRUSTMANAGER_ALGORITHM));
    }

    protected static void configureSslContextFactoryEndpointIdentification(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        String sslEndpointIdentificationAlg = (String)sslConfigValues.get("ssl.endpoint.identification.algorithm");
        if (sslEndpointIdentificationAlg != null) {
            ssl.setEndpointIdentificationAlgorithm(sslEndpointIdentificationAlg);
        }
    }

    protected static void configureSslContextFactoryAuthentication(SslContextFactory.Server ssl, Map<String, Object> sslConfigValues) {
        String sslClientAuth;
        switch (sslClientAuth = (String)SSLUtils.getOrDefault(sslConfigValues, "ssl.client.auth", "none")) {
            case "requested": {
                ssl.setWantClientAuth(true);
                break;
            }
            case "required": {
                ssl.setNeedClientAuth(true);
                break;
            }
            default: {
                ssl.setNeedClientAuth(false);
                ssl.setWantClientAuth(false);
            }
        }
    }
}

