/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.context;

import cn.hutool.core.util.StrUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.yomahub.tlog.context.TLogContext;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class SpanIdGenerator {
    public static volatile TransmittableThreadLocal<String> currentSpanIdTL = new TransmittableThreadLocal();
    public static volatile TransmittableThreadLocal<AtomicInteger> spanIndex = new TransmittableThreadLocal();

    public static void putSpanId(String spanId) {
        if (StringUtils.isBlank((CharSequence)spanId)) {
            spanId = "0";
        }
        currentSpanIdTL.set((Object)spanId);
        spanIndex.set((Object)new AtomicInteger(0));
    }

    public static String getSpanId() {
        return (String)currentSpanIdTL.get();
    }

    public static void removeSpanId() {
        currentSpanIdTL.remove();
    }

    public static String generateNextSpanId() {
        String currentSpanId = TLogContext.getSpanId();
        int currentSpanIndex = ((AtomicInteger)spanIndex.get()).incrementAndGet();
        return StrUtil.format((CharSequence)"{}.{}", (Object[])new Object[]{currentSpanId, currentSpanIndex});
    }
}

