/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment;

import edu.cmu.sphinx.util.Range;
import edu.cmu.sphinx.util.Utilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.TreeSet;

public class LongTextAligner {
    private final int tupleSize;
    private final List<String> reftup;
    private final HashMap<String, ArrayList<Integer>> tupleIndex;
    private List<String> refWords;

    public LongTextAligner(List<String> list, int n) {
        assert (list != null);
        assert (n > 0);
        this.tupleSize = n;
        this.refWords = list;
        int n2 = 0;
        this.reftup = this.getTuples(list);
        this.tupleIndex = new HashMap();
        for (String string : this.reftup) {
            ArrayList<Integer> arrayList = this.tupleIndex.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.tupleIndex.put(string, arrayList);
            }
            arrayList.add(n2++);
        }
    }

    public int[] align(List<String> list) {
        return this.align(list, new Range(0, this.refWords.size()));
    }

    public int[] align(List<String> list, Range range) {
        if (range.upperEndpoint() - range.lowerEndpoint() < this.tupleSize || list.size() < this.tupleSize) {
            return LongTextAligner.alignTextSimple(this.refWords.subList(range.lowerEndpoint(), range.upperEndpoint()), list, range.lowerEndpoint());
        }
        int[] nArray = new int[list.size()];
        Arrays.fill(nArray, -1);
        int n = 0;
        for (Alignment.Node node : new Alignment(this.getTuples(list), range).getIndices()) {
            for (n = Math.max(n, node.getQueryIndex()); n < node.getQueryIndex() + this.tupleSize; ++n) {
                nArray[n] = node.getDatabaseIndex() + n - node.getQueryIndex();
            }
        }
        return nArray;
    }

    private List<String> getTuples(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator<String> iterator = list.iterator();
        for (int i = 0; i < this.tupleSize - 1; ++i) {
            linkedList.add(iterator.next());
        }
        while (iterator.hasNext()) {
            linkedList.addLast(iterator.next());
            arrayList.add(Utilities.join(linkedList));
            linkedList.removeFirst();
        }
        return arrayList;
    }

    static int[] alignTextSimple(List<String> list, List<String> list2, int n) {
        int n2;
        int n3 = list.size() + 1;
        int n4 = list2.size() + 1;
        int[][] nArray = new int[n3][n4];
        nArray[0][0] = 0;
        for (n2 = 1; n2 < n3; ++n2) {
            nArray[n2][0] = n2;
        }
        for (n2 = 1; n2 < n4; ++n2) {
            nArray[0][n2] = n2;
        }
        for (n2 = 1; n2 < n3; ++n2) {
            for (int i = 1; i < n4; ++i) {
                String string;
                int n5 = nArray[n2 - 1][i - 1];
                String string2 = list.get(n2 - 1);
                if (!string2.equals(string = list2.get(i - 1))) {
                    ++n5;
                }
                int n6 = nArray[n2][i - 1] + 1;
                int n7 = nArray[n2 - 1][i] + 1;
                nArray[n2][i] = Math.min(n5, Math.min(n6, n7));
            }
        }
        --n3;
        int[] nArray2 = new int[--n4];
        Arrays.fill(nArray2, -1);
        while (n4 > 0) {
            if (n3 == 0) {
                --n4;
                continue;
            }
            String string = list.get(n3 - 1);
            String string3 = list2.get(n4 - 1);
            if (nArray[n3 - 1][n4 - 1] <= nArray[n3 - 1][n4 - 1] && nArray[n3 - 1][n4 - 1] <= nArray[n3][n4 - 1] && string.equals(string3)) {
                nArray2[--n4] = --n3 + n;
                continue;
            }
            if (nArray[n3 - 1][n4] < nArray[n3][n4 - 1]) {
                --n3;
                continue;
            }
            --n4;
        }
        return nArray2;
    }

    private final class Alignment {
        private final List<Integer> shifts;
        private final List<String> query;
        private final List<Integer> indices;
        private final List<Node> alignment;

        public Alignment(List<String> list, Range range) {
            Serializable serializable2;
            this.query = list;
            this.indices = new ArrayList<Integer>();
            TreeSet<Serializable> treeSet = new TreeSet<Serializable>();
            for (int i = 0; i < list.size(); ++i) {
                if (!LongTextAligner.this.tupleIndex.containsKey(list.get(i))) continue;
                this.indices.add(i);
                for (Serializable serializable2 : (ArrayList)LongTextAligner.this.tupleIndex.get(list.get(i))) {
                    if (!range.contains((Integer)serializable2)) continue;
                    treeSet.add(serializable2);
                }
            }
            this.shifts = new ArrayList<Integer>(treeSet);
            final HashMap<Node, Integer> hashMap = new HashMap<Node, Integer>();
            PriorityQueue<Node> priorityQueue = new PriorityQueue<Node>(1, new Comparator<Node>(){

                @Override
                public int compare(Node node, Node node2) {
                    return ((Integer)hashMap.get(node)).compareTo((Integer)hashMap.get(node2));
                }
            });
            serializable2 = new HashSet();
            HashMap<Node, Node> hashMap2 = new HashMap<Node, Node>();
            Node node = new Node(0, 0);
            hashMap.put(node, 0);
            priorityQueue.add(node);
            while (!priorityQueue.isEmpty()) {
                Node node2 = (Node)priorityQueue.poll();
                if (serializable2.contains(node2)) continue;
                if (node2.isTarget()) {
                    ArrayList arrayList = new ArrayList();
                    while (hashMap2.containsKey(node2)) {
                        if (!node2.isBoundary() && node2.hasMatch()) {
                            arrayList.add(node2);
                        }
                        node2 = (Node)hashMap2.get(node2);
                    }
                    this.alignment = new ArrayList<Node>(arrayList);
                    Collections.reverse(this.alignment);
                    return;
                }
                serializable2.add(node2);
                for (Node node3 : node2.adjacent()) {
                    int n;
                    if (serializable2.contains(node3)) continue;
                    int n2 = Math.abs(this.indices.size() - this.shifts.size() - node2.queryIndex + node2.databaseIndex) - Math.abs(this.indices.size() - this.shifts.size() - node3.queryIndex + node3.databaseIndex);
                    Integer n3 = (Integer)hashMap.get(node3);
                    Integer n4 = (Integer)hashMap.get(node2);
                    if (n3 == null) {
                        n3 = Integer.MAX_VALUE;
                    }
                    if (n4 == null) {
                        n4 = Integer.MAX_VALUE;
                    }
                    if ((n = n4 + node3.getValue() - n2) >= n3) continue;
                    hashMap.put(node3, n);
                    priorityQueue.add(node3);
                    hashMap2.put(node3, node2);
                }
            }
            this.alignment = Collections.emptyList();
        }

        public List<Node> getIndices() {
            return this.alignment;
        }

        public final class Node {
            private final int databaseIndex;
            private final int queryIndex;

            private Node(int n, int n2) {
                this.databaseIndex = n2;
                this.queryIndex = n;
            }

            public int getDatabaseIndex() {
                return (Integer)Alignment.this.shifts.get(this.databaseIndex - 1);
            }

            public int getQueryIndex() {
                return (Integer)Alignment.this.indices.get(this.queryIndex - 1);
            }

            public String getQueryWord() {
                if (this.queryIndex > 0) {
                    return (String)Alignment.this.query.get(this.getQueryIndex());
                }
                return null;
            }

            public String getDatabaseWord() {
                if (this.databaseIndex > 0) {
                    return (String)LongTextAligner.this.reftup.get(this.getDatabaseIndex());
                }
                return null;
            }

            public int getValue() {
                if (this.isBoundary()) {
                    return Math.max(this.queryIndex, this.databaseIndex);
                }
                return this.hasMatch() ? 0 : 1;
            }

            public boolean hasMatch() {
                return this.getQueryWord().equals(this.getDatabaseWord());
            }

            public boolean isBoundary() {
                return this.queryIndex == 0 || this.databaseIndex == 0;
            }

            public boolean isTarget() {
                return this.queryIndex == Alignment.this.indices.size() && this.databaseIndex == Alignment.this.shifts.size();
            }

            public List<Node> adjacent() {
                ArrayList<Node> arrayList = new ArrayList<Node>(3);
                if (this.queryIndex < Alignment.this.indices.size() && this.databaseIndex < Alignment.this.shifts.size()) {
                    arrayList.add(new Node(this.queryIndex + 1, this.databaseIndex + 1));
                }
                if (this.databaseIndex < Alignment.this.shifts.size()) {
                    arrayList.add(new Node(this.queryIndex, this.databaseIndex + 1));
                }
                if (this.queryIndex < Alignment.this.indices.size()) {
                    arrayList.add(new Node(this.queryIndex + 1, this.databaseIndex));
                }
                return arrayList;
            }

            public boolean equals(Object object) {
                if (!(object instanceof Node)) {
                    return false;
                }
                Node node = (Node)object;
                return this.queryIndex == node.queryIndex && this.databaseIndex == node.databaseIndex;
            }

            public int hashCode() {
                return 31 * (31 * this.queryIndex + this.databaseIndex);
            }

            public String toString() {
                return String.format("[%d %d]", this.queryIndex, this.databaseIndex);
            }
        }
    }
}

