/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment;

import edu.cmu.sphinx.alignment.TextTokenizer;
import edu.cmu.sphinx.alignment.UsEnglish;
import edu.cmu.sphinx.alignment.tokenizer.CharTokenizer;
import edu.cmu.sphinx.alignment.tokenizer.DecisionTree;
import edu.cmu.sphinx.alignment.tokenizer.FeatureSet;
import edu.cmu.sphinx.alignment.tokenizer.Item;
import edu.cmu.sphinx.alignment.tokenizer.NumberExpander;
import edu.cmu.sphinx.alignment.tokenizer.PrefixFSM;
import edu.cmu.sphinx.alignment.tokenizer.PronounceableFSM;
import edu.cmu.sphinx.alignment.tokenizer.Relation;
import edu.cmu.sphinx.alignment.tokenizer.SuffixFSM;
import edu.cmu.sphinx.alignment.tokenizer.Utterance;
import edu.cmu.sphinx.alignment.tokenizer.WordRelation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class USEnglishTokenizer
implements TextTokenizer {
    private static final Pattern alphabetPattern;
    private static final Pattern commaIntPattern;
    private static final Pattern digits2DashPattern;
    private static final Pattern digitsPattern;
    private static final Pattern digitsSlashDigitsPattern;
    private static final Pattern dottedAbbrevPattern;
    private static final Pattern doublePattern;
    private static final Pattern drStPattern;
    private static final Pattern fourDigitsPattern;
    private static final Pattern illionPattern;
    private static final Pattern numberTimePattern;
    private static final Pattern numessPattern;
    private static final Pattern ordinalPattern;
    private static final Pattern romanNumbersPattern;
    private static final Pattern sevenPhoneNumberPattern;
    private static final Pattern threeDigitsPattern;
    private static final Pattern usMoneyPattern;
    private static final String[] kingNames;
    private static final String[] kingTitles;
    private static final String[] sectionTypes;
    private static Map<String, String> kingSectionLikeMap;
    private static final String KING_NAMES = "kingNames";
    private static final String KING_TITLES = "kingTitles";
    private static final String SECTION_TYPES = "sectionTypes";
    private PronounceableFSM prefixFSM = null;
    private PronounceableFSM suffixFSM = null;
    private static final String[][] usStates;
    private static Map<String, String[]> usStatesMap;
    private WordRelation wordRelation;
    private Item tokenItem;
    private DecisionTree cart;

    public USEnglishTokenizer() {
        try {
            this.cart = new DecisionTree(this.getClass().getResource("nums_cart.txt"));
            this.prefixFSM = new PrefixFSM(this.getClass().getResource("prefix_fsm.txt"));
            this.suffixFSM = new SuffixFSM(this.getClass().getResource("suffix_fsm.txt"));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("resources not found", iOException);
        }
    }

    public Item getTokenItem() {
        return this.tokenItem;
    }

    @Override
    public List<String> expand(String string) {
        Object object;
        Object object2;
        String string2 = this.simplifyChars(string);
        CharTokenizer charTokenizer = new CharTokenizer();
        charTokenizer.setWhitespaceSymbols(" \t\n\r");
        charTokenizer.setSingleCharSymbols("");
        charTokenizer.setPrepunctuationSymbols("\"'`({[");
        charTokenizer.setPostpunctuationSymbols("\"'`.,:;!?(){}[]");
        charTokenizer.setInputText(string2);
        Utterance utterance = new Utterance(charTokenizer);
        Relation relation = utterance.getRelation("Token");
        if (relation == null) {
            throw new IllegalStateException("token relation does not exist");
        }
        this.wordRelation = WordRelation.createWordRelation(utterance, this);
        this.tokenItem = relation.getHead();
        while (this.tokenItem != null) {
            object2 = this.tokenItem.getFeatures();
            object = ((FeatureSet)object2).getString("name");
            this.tokenToWords((String)object);
            this.tokenItem = this.tokenItem.getNext();
        }
        object2 = new ArrayList();
        for (object = utterance.getRelation("Word").getHead(); object != null; object = ((Item)object).getNext()) {
            if (((Item)object).toString().isEmpty() || ((Item)object).toString().contains("#")) continue;
            object2.add(((Item)object).toString());
        }
        return object2;
    }

    private String simplifyChars(String string) {
        string = string.replace('\u2019', '\'');
        string = string.replace('\u2018', '\'');
        string = string.replace('\u201d', '\"');
        string = string.replace('\u201c', '\"');
        string = string.replace('\u00bb', '\"');
        string = string.replace('\u00ab', '\"');
        string = string.replace('\u2013', '-');
        string = string.replace('\u2014', ' ');
        string = string.replace('\u2026', ' ');
        string = string.replace('\f', ' ');
        return string;
    }

    private boolean matchesPartPhoneNumber(String string) {
        String string2 = (String)this.tokenItem.findFeature("n.name");
        String string3 = (String)this.tokenItem.findFeature("n.n.name");
        String string4 = (String)this.tokenItem.findFeature("p.name");
        String string5 = (String)this.tokenItem.findFeature("p.p.name");
        boolean bl = USEnglishTokenizer.matches(threeDigitsPattern, string4);
        return USEnglishTokenizer.matches(threeDigitsPattern, string) && (!USEnglishTokenizer.matches(digitsPattern, string4) && USEnglishTokenizer.matches(threeDigitsPattern, string2) && USEnglishTokenizer.matches(fourDigitsPattern, string3) || USEnglishTokenizer.matches(sevenPhoneNumberPattern, string2) || !USEnglishTokenizer.matches(digitsPattern, string5) && bl && USEnglishTokenizer.matches(fourDigitsPattern, string2)) || USEnglishTokenizer.matches(fourDigitsPattern, string) && !USEnglishTokenizer.matches(digitsPattern, string2) && bl && USEnglishTokenizer.matches(threeDigitsPattern, string5);
    }

    private void tokenToWords(String string) {
        FeatureSet featureSet = this.tokenItem.getFeatures();
        String string2 = featureSet.getString("name");
        int n = string.length();
        if (featureSet.isPresent("phones")) {
            this.wordRelation.addWord(string);
        } else if (!(!string.equals("a") && !string.equals("A") || this.tokenItem.getNext() != null && string.equals(string2) && ((String)this.tokenItem.findFeature("punc")).equals(""))) {
            this.wordRelation.addWord("_a");
        } else if (USEnglishTokenizer.matches(alphabetPattern, string)) {
            if (USEnglishTokenizer.matches(romanNumbersPattern, string)) {
                this.romanToWords(string);
            } else if (USEnglishTokenizer.matches(illionPattern, string) && USEnglishTokenizer.matches(usMoneyPattern, (String)this.tokenItem.findFeature("p.name"))) {
                this.wordRelation.addWord(string);
                this.wordRelation.addWord("dollars");
            } else if (USEnglishTokenizer.matches(drStPattern, string)) {
                this.drStToWords(string);
            } else if (string.equals("Mr")) {
                this.tokenItem.getFeatures().setString("punc", "");
                this.wordRelation.addWord("mister");
            } else if (string.equals("Mrs")) {
                this.tokenItem.getFeatures().setString("punc", "");
                this.wordRelation.addWord("missus");
            } else if (n == 1 && Character.isUpperCase(string.charAt(0)) && ((String)this.tokenItem.findFeature("n.whitespace")).equals(" ") && Character.isUpperCase(((String)this.tokenItem.findFeature("n.name")).charAt(0))) {
                featureSet.setString("punc", "");
                String string3 = string.toLowerCase();
                if (string3.equals("a")) {
                    this.wordRelation.addWord("_a");
                } else {
                    this.wordRelation.addWord(string3);
                }
            } else if (!this.isStateName(string)) {
                if (n > 1 && !this.isPronounceable(string)) {
                    NumberExpander.expandLetters(string, this.wordRelation);
                } else {
                    this.wordRelation.addWord(string.toLowerCase());
                }
            }
        } else if (USEnglishTokenizer.matches(dottedAbbrevPattern, string)) {
            NumberExpander.expandLetters(string.replace(".", ""), this.wordRelation);
        } else if (USEnglishTokenizer.matches(commaIntPattern, string)) {
            NumberExpander.expandReal(string.replace(",", "").replace("'", ""), this.wordRelation);
        } else if (USEnglishTokenizer.matches(sevenPhoneNumberPattern, string)) {
            int n2 = string.indexOf(45);
            String string4 = string.substring(0, n2);
            String string5 = string.substring(n2 + 1);
            NumberExpander.expandDigits(string4, this.wordRelation);
            this.wordRelation.addBreak();
            NumberExpander.expandDigits(string5, this.wordRelation);
        } else if (this.matchesPartPhoneNumber(string)) {
            String string6 = (String)this.tokenItem.findFeature("punc");
            if (string6.equals("")) {
                this.tokenItem.getFeatures().setString("punc", ",");
            }
            NumberExpander.expandDigits(string, this.wordRelation);
            this.wordRelation.addBreak();
        } else if (USEnglishTokenizer.matches(numberTimePattern, string)) {
            int n3 = string.indexOf(58);
            String string7 = string.substring(0, n3);
            String string8 = string.substring(n3 + 1);
            NumberExpander.expandNumber(string7, this.wordRelation);
            if (!string8.equals("00")) {
                NumberExpander.expandID(string8, this.wordRelation);
            }
        } else if (USEnglishTokenizer.matches(digits2DashPattern, string)) {
            this.digitsDashToWords(string);
        } else if (USEnglishTokenizer.matches(digitsPattern, string)) {
            this.digitsToWords(string);
        } else if (n == 1 && Character.isUpperCase(string.charAt(0)) && ((String)this.tokenItem.findFeature("n.whitespace")).equals(" ") && Character.isUpperCase(((String)this.tokenItem.findFeature("n.name")).charAt(0))) {
            featureSet.setString("punc", "");
            String string9 = string.toLowerCase();
            if (string9.equals("a")) {
                this.wordRelation.addWord("_a");
            } else {
                this.wordRelation.addWord(string9);
            }
        } else if (USEnglishTokenizer.matches(doublePattern, string)) {
            NumberExpander.expandReal(string, this.wordRelation);
        } else if (USEnglishTokenizer.matches(ordinalPattern, string)) {
            String string10 = string.substring(0, n - 2);
            NumberExpander.expandOrdinal(string10, this.wordRelation);
        } else if (USEnglishTokenizer.matches(usMoneyPattern, string)) {
            this.usMoneyToWords(string);
        } else if (n > 0 && string.charAt(n - 1) == '%') {
            this.tokenToWords(string.substring(0, n - 1));
            this.wordRelation.addWord("percent");
        } else if (USEnglishTokenizer.matches(numessPattern, string)) {
            NumberExpander.expandNumess(string.substring(0, n - 1), this.wordRelation);
        } else if (USEnglishTokenizer.matches(digitsSlashDigitsPattern, string) && string.equals(string2)) {
            this.digitsSlashDigitsToWords(string);
        } else if (string.indexOf(45) != -1) {
            this.dashToWords(string);
        } else if (n > 1 && !USEnglishTokenizer.matches(alphabetPattern, string)) {
            this.notJustAlphasToWords(string);
        } else if (string.equals("&")) {
            this.wordRelation.addWord("and");
        } else if (!string.equals("-")) {
            this.wordRelation.addWord(string.toLowerCase());
        }
    }

    private void digitsDashToWords(String string) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i <= n; ++i) {
            if (i != n && string.charAt(i) != '-') continue;
            String string2 = string.substring(n2, i);
            NumberExpander.expandDigits(string2, this.wordRelation);
            this.wordRelation.addBreak();
            n2 = i + 1;
        }
    }

    private void digitsToWords(String string) {
        FeatureSet featureSet = this.tokenItem.getFeatures();
        String string2 = "";
        if (featureSet.isPresent("nsw")) {
            string2 = featureSet.getString("nsw");
        }
        if (string2.equals("nide")) {
            NumberExpander.expandID(string, this.wordRelation);
        } else {
            String string3 = featureSet.getString("name");
            String string4 = null;
            if (string.equals(string3)) {
                string4 = (String)this.cart.interpret(this.tokenItem);
            } else {
                featureSet.setString("name", string);
                string4 = (String)this.cart.interpret(this.tokenItem);
                featureSet.setString("name", string3);
            }
            if (string4.equals("ordinal")) {
                NumberExpander.expandOrdinal(string, this.wordRelation);
            } else if (string4.equals("digits")) {
                NumberExpander.expandDigits(string, this.wordRelation);
            } else if (string4.equals("year")) {
                NumberExpander.expandID(string, this.wordRelation);
            } else {
                NumberExpander.expandNumber(string, this.wordRelation);
            }
        }
    }

    private void romanToWords(String string) {
        String string2 = (String)this.tokenItem.findFeature("p.punc");
        if (string2.equals("")) {
            String string3 = String.valueOf(NumberExpander.expandRoman(string));
            if (USEnglishTokenizer.kingLike(this.tokenItem)) {
                this.wordRelation.addWord("the");
                NumberExpander.expandOrdinal(string3, this.wordRelation);
            } else if (USEnglishTokenizer.sectionLike(this.tokenItem)) {
                NumberExpander.expandNumber(string3, this.wordRelation);
            } else {
                NumberExpander.expandLetters(string, this.wordRelation);
            }
        } else {
            NumberExpander.expandLetters(string, this.wordRelation);
        }
    }

    private static boolean inKingSectionLikeMap(String string, String string2) {
        if (kingSectionLikeMap.containsKey(string)) {
            return kingSectionLikeMap.get(string).equals(string2);
        }
        return false;
    }

    public static boolean kingLike(Item item) {
        String string = ((String)item.findFeature("p.name")).toLowerCase();
        if (USEnglishTokenizer.inKingSectionLikeMap(string, KING_NAMES)) {
            return true;
        }
        String string2 = ((String)item.findFeature("p.p.name")).toLowerCase();
        return USEnglishTokenizer.inKingSectionLikeMap(string2, KING_TITLES);
    }

    public static boolean sectionLike(Item item) {
        String string = ((String)item.findFeature("p.name")).toLowerCase();
        return USEnglishTokenizer.inKingSectionLikeMap(string, SECTION_TYPES);
    }

    private void drStToWords(String string) {
        String string2 = null;
        String string3 = null;
        char c = string.charAt(0);
        if (c == 's' || c == 'S') {
            string2 = "street";
            string3 = "saint";
        } else {
            string2 = "drive";
            string3 = "doctor";
        }
        FeatureSet featureSet = this.tokenItem.getFeatures();
        String string4 = featureSet.getString("punc");
        String string5 = (String)this.tokenItem.findFeature("punc");
        if (this.tokenItem.getNext() == null || string4.indexOf(44) != -1) {
            this.wordRelation.addWord(string2);
        } else if (string5.equals(",")) {
            this.wordRelation.addWord(string3);
        } else {
            String string6 = (String)this.tokenItem.findFeature("p.name");
            String string7 = (String)this.tokenItem.findFeature("n.name");
            char c2 = string6.charAt(0);
            char c3 = string7.charAt(0);
            if (Character.isUpperCase(c2) && Character.isLowerCase(c3)) {
                this.wordRelation.addWord(string2);
            } else if (Character.isDigit(c2) && Character.isLowerCase(c3)) {
                this.wordRelation.addWord(string2);
            } else if (Character.isLowerCase(c2) && Character.isUpperCase(c3)) {
                this.wordRelation.addWord(string3);
            } else {
                String string8 = (String)this.tokenItem.findFeature("n.whitespace");
                if (string8.equals(" ")) {
                    this.wordRelation.addWord(string3);
                } else {
                    this.wordRelation.addWord(string2);
                }
            }
        }
        if (string4 != null && string4.equals(".")) {
            featureSet.setString("punc", "");
        }
    }

    private void usMoneyToWords(String string) {
        int n = string.indexOf(46);
        if (USEnglishTokenizer.matches(illionPattern, (String)this.tokenItem.findFeature("n.name"))) {
            NumberExpander.expandReal(string.substring(1), this.wordRelation);
        } else if (n == -1) {
            String string2 = string.substring(1);
            this.tokenToWords(string2);
            if (string2.equals("1")) {
                this.wordRelation.addWord("dollar");
            } else {
                this.wordRelation.addWord("dollars");
            }
        } else if (n == string.length() - 1 || string.length() - n > 3) {
            NumberExpander.expandReal(string.substring(1), this.wordRelation);
            this.wordRelation.addWord("dollars");
        } else {
            String string3 = string.substring(1, n).replace(",", "");
            String string4 = string.substring(n + 1);
            NumberExpander.expandNumber(string3, this.wordRelation);
            if (string3.equals("1")) {
                this.wordRelation.addWord("dollar");
            } else {
                this.wordRelation.addWord("dollars");
            }
            if (!string4.equals("00")) {
                NumberExpander.expandNumber(string4, this.wordRelation);
                if (string4.equals("01")) {
                    this.wordRelation.addWord("cent");
                } else {
                    this.wordRelation.addWord("cents");
                }
            }
        }
    }

    private void digitsSlashDigitsToWords(String string) {
        int n = string.indexOf(47);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (USEnglishTokenizer.matches(digitsPattern, (String)this.tokenItem.findFeature("p.name")) && this.tokenItem.getPrevious() != null) {
            this.wordRelation.addWord("and");
        }
        if (string2.equals("1") && string3.equals("2")) {
            this.wordRelation.addWord("a");
            this.wordRelation.addWord("half");
        } else {
            int n2 = Integer.parseInt(string2);
            if (n2 < Integer.parseInt(string3)) {
                NumberExpander.expandNumber(string2, this.wordRelation);
                NumberExpander.expandOrdinal(string3, this.wordRelation);
                if (n2 > 1) {
                    this.wordRelation.addWord("'s");
                }
            } else {
                NumberExpander.expandNumber(string2, this.wordRelation);
                this.wordRelation.addWord("slash");
                NumberExpander.expandNumber(string3, this.wordRelation);
            }
        }
    }

    private void dashToWords(String string) {
        int n = string.indexOf(45);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        if (USEnglishTokenizer.matches(digitsPattern, string2) && USEnglishTokenizer.matches(digitsPattern, string3)) {
            FeatureSet featureSet = this.tokenItem.getFeatures();
            featureSet.setString("name", string2);
            this.tokenToWords(string2);
            this.wordRelation.addWord("to");
            featureSet.setString("name", string3);
            this.tokenToWords(string3);
            featureSet.setString("name", "");
        } else {
            this.tokenToWords(string2);
            this.tokenToWords(string3);
        }
    }

    private void notJustAlphasToWords(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 - 1 && !USEnglishTokenizer.isTextSplitable(string, n); ++n) {
        }
        if (n == n2 - 1) {
            this.wordRelation.addWord(string.toLowerCase());
            return;
        }
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1, n2);
        FeatureSet featureSet = this.tokenItem.getFeatures();
        featureSet.setString("nsw", "nide");
        this.tokenToWords(string2);
        this.tokenToWords(string3);
    }

    public boolean isPronounceable(String string) {
        String string2 = string.toLowerCase();
        return this.prefixFSM.accept(string2) && this.suffixFSM.accept(string2);
    }

    private boolean isStateName(String string) {
        String[] stringArray = usStatesMap.get(string);
        if (stringArray != null) {
            boolean bl = false;
            if (stringArray[1].equals("ambiguous")) {
                boolean bl2;
                String string2 = (String)this.tokenItem.findFeature("p.name");
                String string3 = (String)this.tokenItem.findFeature("n.name");
                int n = string3.length();
                FeatureSet featureSet = this.tokenItem.getFeatures();
                boolean bl3 = Character.isUpperCase(string2.charAt(0)) && string2.length() > 2 && USEnglishTokenizer.matches(alphabetPattern, string2) && this.tokenItem.findFeature("p.punc").equals(",");
                boolean bl4 = bl2 = Character.isLowerCase(string3.charAt(0)) || this.tokenItem.getNext() == null || featureSet.getString("punc").equals(".") || (n == 5 || n == 10) && USEnglishTokenizer.matches(digitsPattern, string3);
                bl = bl3 && bl2;
            } else {
                bl = true;
            }
            if (bl) {
                for (int i = 2; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) continue;
                    this.wordRelation.addWord(stringArray[i]);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean matches(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    private static boolean isTextSplitable(String string, int n) {
        char c = string.charAt(n);
        char c2 = string.charAt(n + 1);
        if (Character.isLetter(c) && Character.isLetter(c2)) {
            return false;
        }
        if (Character.isDigit(c) && Character.isDigit(c2)) {
            return false;
        }
        if (c == '\'' || Character.isLetter(c2)) {
            return false;
        }
        return c2 != '\'' && !Character.isLetter(c);
    }

    static {
        int n;
        alphabetPattern = Pattern.compile(UsEnglish.RX_ALPHABET);
        commaIntPattern = Pattern.compile(UsEnglish.RX_COMMAINT);
        digits2DashPattern = Pattern.compile("[0-9]+(-[0-9]+)(-[0-9]+)+");
        digitsPattern = Pattern.compile(UsEnglish.RX_DIGITS);
        digitsSlashDigitsPattern = Pattern.compile("[0-9]+/[0-9]+");
        dottedAbbrevPattern = Pattern.compile(UsEnglish.RX_DOTTED_ABBREV);
        doublePattern = Pattern.compile(UsEnglish.RX_DOUBLE);
        drStPattern = Pattern.compile("([dD][Rr]|[Ss][Tt])");
        fourDigitsPattern = Pattern.compile("[0-9][0-9][0-9][0-9]");
        Pattern.compile(".*[aeiouAEIOU].*");
        illionPattern = Pattern.compile(".*illion");
        numberTimePattern = Pattern.compile("((0[0-2])|(1[0-9])):([0-5][0-9])");
        numessPattern = Pattern.compile("[0-9]+s");
        ordinalPattern = Pattern.compile(UsEnglish.RX_ORDINAL_NUMBER);
        romanNumbersPattern = Pattern.compile("(II?I?|IV|VI?I?I?|IX|X[VIX]*)");
        sevenPhoneNumberPattern = Pattern.compile("[0-9][0-9][0-9]-[0-9][0-9][0-9][0-9]");
        threeDigitsPattern = Pattern.compile("[0-9][0-9][0-9]");
        usMoneyPattern = Pattern.compile("\\$[0-9,]+(\\.[0-9]+)?");
        kingNames = new String[]{"louis", "henry", "charles", "philip", "george", "edward", "pius", "william", "richard", "ptolemy", "john", "paul", "peter", "nicholas", "frederick", "james", "alfonso", "ivan", "napoleon", "leo", "gregory", "catherine", "alexandria", "pierre", "elizabeth", "mary", "elmo", "erasmus"};
        kingTitles = new String[]{"king", "queen", "pope", "duke", "tsar", "emperor", "shah", "caesar", "duchess", "tsarina", "empress", "baron", "baroness", "sultan", "count", "countess"};
        sectionTypes = new String[]{"section", "chapter", "part", "phrase", "verse", "scene", "act", "book", "volume", "chap", "war", "apollo", "trek", "fortran"};
        kingSectionLikeMap = new HashMap<String, String>();
        for (n = 0; n < kingNames.length; ++n) {
            kingSectionLikeMap.put(kingNames[n], KING_NAMES);
        }
        for (n = 0; n < kingTitles.length; ++n) {
            kingSectionLikeMap.put(kingTitles[n], KING_TITLES);
        }
        for (n = 0; n < sectionTypes.length; ++n) {
            kingSectionLikeMap.put(sectionTypes[n], SECTION_TYPES);
        }
        usStates = new String[][]{{"AL", "ambiguous", "alabama"}, {"Al", "ambiguous", "alabama"}, {"Ala", "", "alabama"}, {"AK", "", "alaska"}, {"Ak", "", "alaska"}, {"AZ", "", "arizona"}, {"Az", "", "arizona"}, {"CA", "", "california"}, {"Ca", "", "california"}, {"Cal", "ambiguous", "california"}, {"Calif", "", "california"}, {"CO", "ambiguous", "colorado"}, {"Co", "ambiguous", "colorado"}, {"Colo", "", "colorado"}, {"DC", "", "d", "c"}, {"DE", "", "delaware"}, {"De", "ambiguous", "delaware"}, {"Del", "ambiguous", "delaware"}, {"FL", "", "florida"}, {"Fl", "ambiguous", "florida"}, {"Fla", "", "florida"}, {"GA", "", "georgia"}, {"Ga", "", "georgia"}, {"HI", "ambiguous", "hawaii"}, {"Hi", "ambiguous", "hawaii"}, {"IA", "", "iowa"}, {"Ia", "ambiguous", "iowa"}, {"IN", "ambiguous", "indiana"}, {"In", "ambiguous", "indiana"}, {"Ind", "ambiguous", "indiana"}, {"ID", "ambiguous", "idaho"}, {"IL", "ambiguous", "illinois"}, {"Il", "ambiguous", "illinois"}, {"ILL", "ambiguous", "illinois"}, {"KS", "", "kansas"}, {"Ks", "", "kansas"}, {"Kans", "", "kansas"}, {"KY", "ambiguous", "kentucky"}, {"Ky", "ambiguous", "kentucky"}, {"LA", "ambiguous", "louisiana"}, {"La", "ambiguous", "louisiana"}, {"Lou", "ambiguous", "louisiana"}, {"Lous", "ambiguous", "louisiana"}, {"MA", "ambiguous", "massachusetts"}, {"Mass", "ambiguous", "massachusetts"}, {"Ma", "ambiguous", "massachusetts"}, {"MD", "ambiguous", "maryland"}, {"Md", "ambiguous", "maryland"}, {"ME", "ambiguous", "maine"}, {"Me", "ambiguous", "maine"}, {"MI", "", "michigan"}, {"Mi", "ambiguous", "michigan"}, {"Mich", "ambiguous", "michigan"}, {"MN", "ambiguous", "minnestota"}, {"Minn", "ambiguous", "minnestota"}, {"MS", "ambiguous", "mississippi"}, {"Miss", "ambiguous", "mississippi"}, {"MT", "ambiguous", "montanna"}, {"Mt", "ambiguous", "montanna"}, {"MO", "ambiguous", "missouri"}, {"Mo", "ambiguous", "missouri"}, {"NC", "ambiguous", "north", "carolina"}, {"ND", "ambiguous", "north", "dakota"}, {"NE", "ambiguous", "nebraska"}, {"Ne", "ambiguous", "nebraska"}, {"Neb", "ambiguous", "nebraska"}, {"NH", "ambiguous", "new", "hampshire"}, {"NV", "", "nevada"}, {"Nev", "", "nevada"}, {"NY", "", "new", "york"}, {"OH", "ambiguous", "ohio"}, {"OK", "ambiguous", "oklahoma"}, {"Okla", "", "oklahoma"}, {"OR", "ambiguous", "oregon"}, {"Or", "ambiguous", "oregon"}, {"Ore", "ambiguous", "oregon"}, {"PA", "ambiguous", "pennsylvania"}, {"Pa", "ambiguous", "pennsylvania"}, {"Penn", "ambiguous", "pennsylvania"}, {"RI", "ambiguous", "rhode", "island"}, {"SC", "ambiguous", "south", "carlolina"}, {"SD", "ambiguous", "south", "dakota"}, {"TN", "ambiguous", "tennesee"}, {"Tn", "ambiguous", "tennesee"}, {"Tenn", "ambiguous", "tennesee"}, {"TX", "ambiguous", "texas"}, {"Tx", "ambiguous", "texas"}, {"Tex", "ambiguous", "texas"}, {"UT", "ambiguous", "utah"}, {"VA", "ambiguous", "virginia"}, {"WA", "ambiguous", "washington"}, {"Wa", "ambiguous", "washington"}, {"Wash", "ambiguous", "washington"}, {"WI", "ambiguous", "wisconsin"}, {"Wi", "ambiguous", "wisconsin"}, {"WV", "ambiguous", "west", "virginia"}, {"WY", "ambiguous", "wyoming"}, {"Wy", "ambiguous", "wyoming"}, {"Wyo", "", "wyoming"}, {"PR", "ambiguous", "puerto", "rico"}};
        usStatesMap = new HashMap<String, String[]>();
        for (n = 0; n < usStates.length; ++n) {
            usStatesMap.put(usStates[n][0], usStates[n]);
        }
    }
}

