/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment.tokenizer;

import edu.cmu.sphinx.alignment.Token;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

public class CharTokenizer
implements Iterator<Token> {
    public static final int EOF = -1;
    public static final String DEFAULT_WHITESPACE_SYMBOLS = " \t\n\r";
    public static final String DEFAULT_SINGLE_CHAR_SYMBOLS = "(){}[]";
    public static final String DEFAULT_PREPUNCTUATION_SYMBOLS = "\"'`({[";
    public static final String DEFAULT_POSTPUNCTUATION_SYMBOLS = "\"'`.,:;!?(){}[]";
    private int lineNumber;
    private String inputText;
    private Reader reader;
    private int currentChar;
    private int currentPosition;
    private String whitespaceSymbols = " \t\n\r";
    private String singleCharSymbols = "(){}[]";
    private String prepunctuationSymbols = "\"'`({[";
    private String postpunctuationSymbols = "\"'`.,:;!?(){}[]";
    private String errorDescription;
    private Token token;
    private Token lastToken;

    public CharTokenizer() {
    }

    public CharTokenizer(String string) {
        this.setInputText(string);
    }

    public CharTokenizer(Reader reader) {
        this.setInputReader(reader);
    }

    public void setWhitespaceSymbols(String string) {
        this.whitespaceSymbols = string;
    }

    public void setSingleCharSymbols(String string) {
        this.singleCharSymbols = string;
    }

    public void setPrepunctuationSymbols(String string) {
        this.prepunctuationSymbols = string;
    }

    public void setPostpunctuationSymbols(String string) {
        this.postpunctuationSymbols = string;
    }

    public void setInputText(String string) {
        this.inputText = string;
        this.currentPosition = 0;
        if (this.inputText != null) {
            this.getNextChar();
        }
    }

    public void setInputReader(Reader reader) {
        this.reader = reader;
        this.getNextChar();
    }

    @Override
    public Token next() {
        this.lastToken = this.token;
        this.token = new Token();
        this.token.setWhitespace(this.getTokenOfCharClass(this.whitespaceSymbols));
        this.token.setPrepunctuation(this.getTokenOfCharClass(this.prepunctuationSymbols));
        if (this.singleCharSymbols.indexOf(this.currentChar) != -1) {
            this.token.setWord(String.valueOf((char)this.currentChar));
            this.getNextChar();
        } else {
            this.token.setWord(this.getTokenNotOfCharClass(this.whitespaceSymbols));
        }
        this.token.setPosition(this.currentPosition);
        this.token.setLineNumber(this.lineNumber);
        this.removeTokenPostpunctuation();
        return this.token;
    }

    @Override
    public boolean hasNext() {
        int n = this.currentChar;
        return n != -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private int getNextChar() {
        block8: {
            if (this.reader != null) {
                try {
                    int n = this.reader.read();
                    if (n == -1) {
                        this.currentChar = -1;
                        break block8;
                    }
                    this.currentChar = (char)n;
                }
                catch (IOException iOException) {
                    this.currentChar = -1;
                    this.errorDescription = iOException.getMessage();
                }
            } else if (this.inputText != null) {
                this.currentChar = this.currentPosition < this.inputText.length() ? (int)this.inputText.charAt(this.currentPosition) : -1;
            }
        }
        if (this.currentChar != -1) {
            ++this.currentPosition;
        }
        if (this.currentChar == 10) {
            ++this.lineNumber;
        }
        return this.currentChar;
    }

    private String getTokenOfCharClass(String string) {
        return this.getTokenByCharClass(string, true);
    }

    private String getTokenNotOfCharClass(String string) {
        return this.getTokenByCharClass(string, false);
    }

    private String getTokenByCharClass(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        while (string.indexOf(this.currentChar) != -1 == bl && this.singleCharSymbols.indexOf(this.currentChar) == -1 && this.currentChar != -1) {
            stringBuilder.append((char)this.currentChar);
            this.getNextChar();
        }
        return stringBuilder.toString();
    }

    private void removeTokenPostpunctuation() {
        int n;
        if (this.token == null) {
            return;
        }
        String string = this.token.getWord();
        int n2 = string.length();
        for (n = n2 - 1; n > 0 && this.postpunctuationSymbols.indexOf(string.charAt(n)) != -1; --n) {
        }
        if (n2 - 1 != n) {
            this.token.setPostpunctuation(string.substring(n + 1));
            this.token.setWord(string.substring(0, n + 1));
        } else {
            this.token.setPostpunctuation("");
        }
    }

    public boolean hasErrors() {
        return this.errorDescription != null;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public boolean isSentenceSeparator() {
        String string = this.token.getWhitespace();
        String string2 = null;
        if (this.lastToken != null) {
            string2 = this.lastToken.getPostpunctuation();
        }
        if (this.lastToken == null || this.token == null) {
            return false;
        }
        if (string.indexOf(10) != string.lastIndexOf(10)) {
            return true;
        }
        if (string2.indexOf(58) != -1 || string2.indexOf(63) != -1 || string2.indexOf(33) != -1) {
            return true;
        }
        if (string2.indexOf(46) != -1 && string.length() > 1 && Character.isUpperCase(this.token.getWord().charAt(0))) {
            return true;
        }
        String string3 = this.lastToken.getWord();
        int n = string3.length();
        return string2.indexOf(46) != -1 && Character.isUpperCase(this.token.getWord().charAt(0)) && !Character.isUpperCase(string3.charAt(n - 1)) && (n >= 4 || !Character.isUpperCase(string3.charAt(0)));
    }
}

