/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment.tokenizer;

import edu.cmu.sphinx.alignment.tokenizer.Item;
import edu.cmu.sphinx.alignment.tokenizer.PathExtractor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DecisionTree {
    private static final Logger logger = Logger.getLogger(DecisionTree.class.getSimpleName());
    static final String TOTAL = "TOTAL";
    static final String NODE = "NODE";
    static final String LEAF = "LEAF";
    static final String OPERAND_MATCHES = "MATCHES";
    Node[] cart = null;
    transient int curNode = 0;

    public DecisionTree(URL uRL) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        String string = bufferedReader.readLine();
        while (string != null) {
            if (!string.startsWith("***")) {
                this.parseAndAdd(string);
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    public DecisionTree(BufferedReader bufferedReader, int n) throws IOException {
        this(n);
        for (int i = 0; i < n; ++i) {
            String string = bufferedReader.readLine();
            if (string.startsWith("***")) continue;
            this.parseAndAdd(string);
        }
    }

    private DecisionTree(int n) {
        this.cart = new Node[n];
    }

    public void dumpDot(PrintWriter printWriter) {
        printWriter.write("digraph \"CART Tree\" {\n");
        printWriter.write("rankdir = LR\n");
        for (Node node : this.cart) {
            printWriter.println("\t\"node" + node.hashCode() + "\" [ label=\"" + node.toString() + "\", color=" + this.dumpDotNodeColor(node) + ", shape=" + this.dumpDotNodeShape(node) + " ]\n");
            if (!(node instanceof DecisionNode)) continue;
            DecisionNode decisionNode = (DecisionNode)node;
            if (decisionNode.qtrue < this.cart.length && this.cart[decisionNode.qtrue] != null) {
                printWriter.write("\t\"node" + node.hashCode() + "\" -> \"node" + this.cart[decisionNode.qtrue].hashCode() + "\" [ label=" + "TRUE" + " ]\n");
            }
            if (decisionNode.qfalse >= this.cart.length || this.cart[decisionNode.qfalse] == null) continue;
            printWriter.write("\t\"node" + node.hashCode() + "\" -> \"node" + this.cart[decisionNode.qfalse].hashCode() + "\" [ label=" + "FALSE" + " ]\n");
        }
        printWriter.write("}\n");
        printWriter.close();
    }

    protected String dumpDotNodeColor(Node node) {
        if (node instanceof LeafNode) {
            return "green";
        }
        return "red";
    }

    protected String dumpDotNodeShape(Node node) {
        return "box";
    }

    protected void parseAndAdd(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        if (string2.equals(LEAF) || string2.equals(NODE)) {
            this.cart[this.curNode] = this.getNode(string2, stringTokenizer, this.curNode);
            this.cart[this.curNode].setCreationLine(string);
            ++this.curNode;
        } else if (string2.equals(TOTAL)) {
            this.cart = new Node[Integer.parseInt(stringTokenizer.nextToken())];
            this.curNode = 0;
        } else {
            throw new Error("Invalid CART type: " + string2);
        }
    }

    protected Node getNode(String string, StringTokenizer stringTokenizer, int n) {
        if (string.equals(NODE)) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            Object object = this.parseValue(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (string3.equals(OPERAND_MATCHES)) {
                return new MatchingNode(string2, object.toString(), n + 1, n2);
            }
            return new ComparisonNode(string2, object, string3, n + 1, n2);
        }
        if (string.equals(LEAF)) {
            return new LeafNode(this.parseValue(stringTokenizer.nextToken()));
        }
        return null;
    }

    protected Object parseValue(String string) {
        int n = string.indexOf("(");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length() - 1);
        if (string2.equals("String")) {
            return string3;
        }
        if (string2.equals("Float")) {
            return new Float(Float.parseFloat(string3));
        }
        if (string2.equals("Integer")) {
            return new Integer(Integer.parseInt(string3));
        }
        if (string2.equals("List")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            int n2 = stringTokenizer.countTokens();
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                float f = Float.parseFloat(stringTokenizer.nextToken());
                nArray[i] = Math.round(f);
            }
            return nArray;
        }
        throw new Error("Unknown type: " + string2);
    }

    public Object interpret(Item item) {
        int n = 0;
        while (!(this.cart[n] instanceof LeafNode)) {
            DecisionNode decisionNode = (DecisionNode)this.cart[n];
            n = decisionNode.getNextNode(item);
        }
        logger.fine("LEAF " + this.cart[n].getValue());
        return ((LeafNode)this.cart[n]).getValue();
    }

    static class LeafNode
    extends Node {
        public LeafNode(Object object) {
            super(object);
        }

        public String toString() {
            return "LEAF " + this.getValueString();
        }
    }

    static class MatchingNode
    extends DecisionNode {
        Pattern pattern;

        public MatchingNode(String string, String string2, int n, int n2) {
            super(string, string2, n, n2);
            this.pattern = Pattern.compile(string2);
        }

        @Override
        public int getNextNode(Object object) {
            return this.pattern.matcher((String)object).matches() ? this.qtrue : this.qfalse;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("NODE " + this.getFeature() + " " + DecisionTree.OPERAND_MATCHES);
            stringBuffer.append(this.getValueString() + " ");
            stringBuffer.append(Integer.toString(this.qtrue) + " ");
            stringBuffer.append(Integer.toString(this.qfalse));
            return stringBuffer.toString();
        }
    }

    static class ComparisonNode
    extends DecisionNode {
        static final String LESS_THAN = "<";
        static final String EQUALS = "=";
        static final String GREATER_THAN = ">";
        String comparisonType;

        public ComparisonNode(String string, Object object, String string2, int n, int n2) {
            super(string, object, n, n2);
            if (!(string2.equals(LESS_THAN) || string2.equals(EQUALS) || string2.equals(GREATER_THAN))) {
                throw new Error("Invalid comparison type: " + string2);
            }
            this.comparisonType = string2;
        }

        @Override
        public int getNextNode(Object object) {
            boolean bl = false;
            if (this.comparisonType.equals(LESS_THAN) || this.comparisonType.equals(GREATER_THAN)) {
                float f = this.value instanceof Float ? ((Float)this.value).floatValue() : Float.parseFloat(this.value.toString());
                float f2 = object instanceof Float ? ((Float)object).floatValue() : Float.parseFloat(object.toString());
                bl = this.comparisonType.equals(LESS_THAN) ? f2 < f : f2 > f;
            } else {
                String string = object.toString();
                String string2 = this.value.toString();
                bl = string.equals(string2);
            }
            int n = bl ? this.qtrue : this.qfalse;
            logger.fine(this.trace(object, bl, n));
            return n;
        }

        private String trace(Object object, boolean bl, int n) {
            return "NODE " + this.getFeature() + " [" + object + "] " + this.comparisonType + " [" + this.getValue() + "] " + (bl ? "Yes" : "No") + " next " + n;
        }

        public String toString() {
            return "NODE " + this.getFeature() + " " + this.comparisonType + " " + this.getValueString() + " " + Integer.toString(this.qtrue) + " " + Integer.toString(this.qfalse);
        }
    }

    static abstract class DecisionNode
    extends Node {
        private PathExtractor path;
        protected int qfalse;
        protected int qtrue;

        public String getFeature() {
            return this.path.toString();
        }

        public Object findFeature(Item item) {
            return this.path.findFeature(item);
        }

        public final int getNextNode(Item item) {
            return this.getNextNode(this.findFeature(item));
        }

        public DecisionNode(String string, Object object, int n, int n2) {
            super(object);
            this.path = new PathExtractor(string, true);
            this.qtrue = n;
            this.qfalse = n2;
        }

        public abstract int getNextNode(Object var1);
    }

    static abstract class Node {
        protected Object value;

        public Node(Object object) {
            this.value = object;
        }

        public Object getValue() {
            return this.value;
        }

        public String getValueString() {
            if (this.value == null) {
                return "NULL()";
            }
            if (this.value instanceof String) {
                return "String(" + this.value.toString() + ")";
            }
            if (this.value instanceof Float) {
                return "Float(" + this.value.toString() + ")";
            }
            if (this.value instanceof Integer) {
                return "Integer(" + this.value.toString() + ")";
            }
            return this.value.getClass().toString() + "(" + this.value.toString() + ")";
        }

        public void setCreationLine(String string) {
        }
    }
}

