/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment.tokenizer;

import edu.cmu.sphinx.alignment.tokenizer.FeatureSet;
import edu.cmu.sphinx.alignment.tokenizer.Item;
import edu.cmu.sphinx.alignment.tokenizer.WordRelation;

public class NumberExpander {
    private static final String[] digit2num = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
    private static final String[] digit2teen = new String[]{"ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    private static final String[] digit2enty = new String[]{"zero", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    private static final String[] ord2num = new String[]{"zeroth", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth"};
    private static final String[] ord2teen = new String[]{"tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", "sixteenth", "seventeenth", "eighteenth", "nineteenth"};
    private static final String[] ord2enty = new String[]{"zeroth", "tenth", "twentieth", "thirtieth", "fortieth", "fiftieth", "sixtieth", "seventieth", "eightieth", "ninetieth"};
    private static String[] digit2Numness = new String[]{"", "tens", "twenties", "thirties", "fourties", "fifties", "sixties", "seventies", "eighties", "nineties"};

    private NumberExpander() {
    }

    public static void expandNumber(String string, WordRelation wordRelation) {
        int n = string.length();
        if (n != 0) {
            if (n == 1) {
                NumberExpander.expandDigits(string, wordRelation);
            } else if (n == 2) {
                NumberExpander.expand2DigitNumber(string, wordRelation);
            } else if (n == 3) {
                NumberExpander.expand3DigitNumber(string, wordRelation);
            } else if (n < 7) {
                NumberExpander.expandBelow7DigitNumber(string, wordRelation);
            } else if (n < 10) {
                NumberExpander.expandBelow10DigitNumber(string, wordRelation);
            } else if (n < 13) {
                NumberExpander.expandBelow13DigitNumber(string, wordRelation);
            } else {
                NumberExpander.expandDigits(string, wordRelation);
            }
        }
    }

    private static void expand2DigitNumber(String string, WordRelation wordRelation) {
        if (string.charAt(0) == '0') {
            if (string.charAt(1) != '0') {
                String string2 = digit2num[string.charAt(1) - 48];
                wordRelation.addWord(string2);
            }
        } else if (string.charAt(1) == '0') {
            String string3 = digit2enty[string.charAt(0) - 48];
            wordRelation.addWord(string3);
        } else if (string.charAt(0) == '1') {
            String string4 = digit2teen[string.charAt(1) - 48];
            wordRelation.addWord(string4);
        } else {
            String string5 = digit2enty[string.charAt(0) - 48];
            wordRelation.addWord(string5);
            NumberExpander.expandDigits(string.substring(1, string.length()), wordRelation);
        }
    }

    private static void expand3DigitNumber(String string, WordRelation wordRelation) {
        if (string.charAt(0) == '0') {
            NumberExpander.expandNumberAt(string, 1, wordRelation);
        } else {
            String string2 = digit2num[string.charAt(0) - 48];
            wordRelation.addWord(string2);
            wordRelation.addWord("hundred");
            NumberExpander.expandNumberAt(string, 1, wordRelation);
        }
    }

    private static void expandBelow7DigitNumber(String string, WordRelation wordRelation) {
        NumberExpander.expandLargeNumber(string, "thousand", 3, wordRelation);
    }

    private static void expandBelow10DigitNumber(String string, WordRelation wordRelation) {
        NumberExpander.expandLargeNumber(string, "million", 6, wordRelation);
    }

    private static void expandBelow13DigitNumber(String string, WordRelation wordRelation) {
        NumberExpander.expandLargeNumber(string, "billion", 9, wordRelation);
    }

    private static void expandLargeNumber(String string, String string2, int n, WordRelation wordRelation) {
        int n2 = string.length();
        int n3 = n2 - n;
        String string3 = string.substring(0, n3);
        Item item = wordRelation.getTail();
        NumberExpander.expandNumber(string3, wordRelation);
        if (wordRelation.getTail() != item) {
            wordRelation.addWord(string2);
        }
        NumberExpander.expandNumberAt(string, n3, wordRelation);
    }

    private static void expandNumberAt(String string, int n, WordRelation wordRelation) {
        NumberExpander.expandNumber(string.substring(n, string.length()), wordRelation);
    }

    public static void expandDigits(String string, WordRelation wordRelation) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) {
                wordRelation.addWord(digit2num[string.charAt(i) - 48]);
                continue;
            }
            wordRelation.addWord("umpty");
        }
    }

    public static void expandOrdinal(String string, WordRelation wordRelation) {
        NumberExpander.expandNumber(string.replace(",", ""), wordRelation);
        Item item = wordRelation.getTail();
        if (item != null) {
            FeatureSet featureSet = item.getFeatures();
            String string2 = featureSet.getString("name");
            String string3 = NumberExpander.findMatchInArray(string2, digit2num, ord2num);
            if (string3 == null) {
                string3 = NumberExpander.findMatchInArray(string2, digit2teen, ord2teen);
            }
            if (string3 == null) {
                string3 = NumberExpander.findMatchInArray(string2, digit2enty, ord2enty);
            }
            if (string2.equals("hundred")) {
                string3 = "hundredth";
            } else if (string2.equals("thousand")) {
                string3 = "thousandth";
            } else if (string2.equals("billion")) {
                string3 = "billionth";
            }
            if (string3 != null) {
                wordRelation.setLastWord(string3);
            }
        }
    }

    public static void expandNumess(String string, WordRelation wordRelation) {
        if (string.length() == 4) {
            NumberExpander.expand2DigitNumber(string.substring(0, 2), wordRelation);
            NumberExpander.expandNumess(string.substring(2), wordRelation);
        } else {
            wordRelation.addWord(digit2Numness[string.charAt(0) - 48]);
        }
    }

    private static String findMatchInArray(String string, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            if (i < stringArray2.length) {
                return stringArray2[i];
            }
            return null;
        }
        return null;
    }

    public static void expandID(String string, WordRelation wordRelation) {
        int n = string.length();
        if (n == 4 && string.charAt(2) == '0' && string.charAt(3) == '0') {
            if (string.charAt(1) == '0') {
                NumberExpander.expandNumber(string, wordRelation);
            } else {
                NumberExpander.expandNumber(string.substring(0, 2), wordRelation);
                wordRelation.addWord("hundred");
            }
        } else if (n == 2 && string.charAt(0) == '0') {
            wordRelation.addWord("oh");
            NumberExpander.expandDigits(string.substring(1, 2), wordRelation);
        } else if (n == 4 && string.charAt(1) == '0' || n < 3) {
            NumberExpander.expandNumber(string, wordRelation);
        } else if (n % 2 == 1) {
            String string2 = digit2num[string.charAt(0) - 48];
            wordRelation.addWord(string2);
            NumberExpander.expandID(string.substring(1, n), wordRelation);
        } else {
            NumberExpander.expandNumber(string.substring(0, 2), wordRelation);
            NumberExpander.expandID(string.substring(2, n), wordRelation);
        }
    }

    public static void expandReal(String string, WordRelation wordRelation) {
        int n = string.length();
        if (string.charAt(0) == '-') {
            wordRelation.addWord("minus");
            NumberExpander.expandReal(string.substring(1, n), wordRelation);
        } else if (string.charAt(0) == '+') {
            wordRelation.addWord("plus");
            NumberExpander.expandReal(string.substring(1, n), wordRelation);
        } else {
            int n2 = string.indexOf(101);
            if (n2 != -1 || (n2 = string.indexOf(69)) != -1) {
                NumberExpander.expandReal(string.substring(0, n2), wordRelation);
                wordRelation.addWord("e");
                NumberExpander.expandReal(string.substring(n2 + 1), wordRelation);
            } else {
                n2 = string.indexOf(46);
                if (n2 != -1) {
                    String string2 = string.substring(0, n2);
                    if (string2.length() > 0) {
                        NumberExpander.expandReal(string2, wordRelation);
                    }
                    wordRelation.addWord("point");
                    String string3 = string.substring(n2 + 1);
                    if (string3.length() > 0) {
                        NumberExpander.expandDigits(string3, wordRelation);
                    }
                } else {
                    NumberExpander.expandNumber(string, wordRelation);
                }
            }
        }
    }

    public static void expandLetters(String string, WordRelation wordRelation) {
        string = string.toLowerCase();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) {
                wordRelation.addWord(digit2num[c - 48]);
                continue;
            }
            if (string.equals("a")) {
                wordRelation.addWord("_a");
                continue;
            }
            wordRelation.addWord(String.valueOf(c));
        }
    }

    public static int expandRoman(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == 'X') {
                n += 10;
                continue;
            }
            if (c == 'V') {
                n += 5;
                continue;
            }
            if (c != 'I') continue;
            if (i + 1 < string.length()) {
                char c2 = string.charAt(i + 1);
                if (c2 == 'V') {
                    n += 4;
                    ++i;
                    continue;
                }
                if (c2 == 'X') {
                    n += 9;
                    ++i;
                    continue;
                }
                ++n;
                continue;
            }
            ++n;
        }
        return n;
    }
}

