/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment.tokenizer;

import edu.cmu.sphinx.alignment.tokenizer.Item;
import edu.cmu.sphinx.alignment.tokenizer.OpEnum;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PathExtractor {
    private static final Logger LOGGER = Logger.getLogger(PathExtractor.class.getName());
    public static final String INTERPRET_PATHS_PROPERTY = "com.sun.speech.freetts.interpretCartPaths";
    public static final String LAZY_COMPILE_PROPERTY = "com.sun.speech.freetts.lazyCartCompile";
    private static final boolean INTERPRET_PATHS = System.getProperty("com.sun.speech.freetts.interpretCartPaths", "false").equals("true");
    private static final boolean LAZY_COMPILE = System.getProperty("com.sun.speech.freetts.lazyCartCompile", "true").equals("true");
    private String pathAndFeature;
    private String path;
    private String feature;
    private Object[] compiledPath;

    public PathExtractor(String string, boolean bl) {
        this.pathAndFeature = string;
        if (INTERPRET_PATHS) {
            this.path = string;
            return;
        }
        if (bl) {
            int n = string.lastIndexOf(".");
            if (n == -1) {
                this.feature = string;
                this.path = null;
            } else {
                this.feature = string.substring(n + 1);
                this.path = string.substring(0, n);
            }
        } else {
            this.path = string;
        }
        if (!LAZY_COMPILE) {
            this.compiledPath = this.compile(this.path);
        }
    }

    public Item findItem(Item item) {
        if (INTERPRET_PATHS) {
            return item.findItem(this.path);
        }
        if (this.compiledPath == null) {
            this.compiledPath = this.compile(this.path);
        }
        Item item2 = item;
        int n = 0;
        while (item2 != null && n < this.compiledPath.length) {
            OpEnum opEnum;
            if ((opEnum = (OpEnum)this.compiledPath[n++]) == OpEnum.NEXT) {
                item2 = item2.getNext();
                continue;
            }
            if (opEnum == OpEnum.PREV) {
                item2 = item2.getPrevious();
                continue;
            }
            if (opEnum == OpEnum.NEXT_NEXT) {
                if ((item2 = item2.getNext()) == null) continue;
                item2 = item2.getNext();
                continue;
            }
            if (opEnum == OpEnum.PREV_PREV) {
                if ((item2 = item2.getPrevious()) == null) continue;
                item2 = item2.getPrevious();
                continue;
            }
            if (opEnum == OpEnum.PARENT) {
                item2 = item2.getParent();
                continue;
            }
            if (opEnum == OpEnum.DAUGHTER) {
                item2 = item2.getDaughter();
                continue;
            }
            if (opEnum == OpEnum.LAST_DAUGHTER) {
                item2 = item2.getLastDaughter();
                continue;
            }
            if (opEnum == OpEnum.RELATION) {
                String string = (String)this.compiledPath[n++];
                item2 = item2.getSharedContents().getItemRelation(string);
                continue;
            }
            System.out.println("findItem: bad feature " + opEnum + " in " + this.path);
        }
        return item2;
    }

    public Object findFeature(Item item) {
        if (INTERPRET_PATHS) {
            return item.findFeature(this.path);
        }
        Item item2 = this.findItem(item);
        Object object = null;
        if (item2 != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("findFeature: Item [" + item2 + "], feature '" + this.feature + "'");
            }
            object = item2.getFeatures().getObject(this.feature);
        }
        Object object2 = object = object == null ? "0" : object;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("findFeature: ...results = '" + object + "'");
        }
        return object;
    }

    private Object[] compile(String string) {
        if (string == null) {
            return new Object[0];
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":.");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            OpEnum opEnum = OpEnum.getInstance(string2);
            if (opEnum == null) {
                throw new Error("Bad path compiled " + string);
            }
            arrayList.add(opEnum);
            if (opEnum != OpEnum.RELATION) continue;
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray();
    }

    public String toString() {
        return this.pathAndFeature;
    }
}

