/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment.tokenizer;

import edu.cmu.sphinx.alignment.Token;
import edu.cmu.sphinx.alignment.tokenizer.CharTokenizer;
import edu.cmu.sphinx.alignment.tokenizer.FeatureSet;
import edu.cmu.sphinx.alignment.tokenizer.Item;
import edu.cmu.sphinx.alignment.tokenizer.PathExtractor;
import edu.cmu.sphinx.alignment.tokenizer.Relation;
import java.util.Iterator;

public class Utterance {
    private FeatureSet features = new FeatureSet();
    private FeatureSet relations = new FeatureSet();

    public Utterance(CharTokenizer charTokenizer) {
        this.setTokenList(charTokenizer);
    }

    public Relation createRelation(String string) {
        Relation relation = new Relation(string, this);
        this.relations.setObject(string, relation);
        return relation;
    }

    public Relation getRelation(String string) {
        return (Relation)this.relations.getObject(string);
    }

    public boolean hasRelation(String string) {
        return this.relations.isPresent(string);
    }

    public void remove(String string) {
        this.features.remove(string);
    }

    public void setInt(String string, int n) {
        this.features.setInt(string, n);
    }

    public void setFloat(String string, float f) {
        this.features.setFloat(string, f);
    }

    public void setString(String string, String string2) {
        this.features.setString(string, string2);
    }

    public void setObject(String string, Object object) {
        this.features.setObject(string, object);
    }

    public Item getItem(String string, float f) {
        String string2 = null;
        if (string.equals("Word")) {
            string2 = "R:SylStructure.parent.parent.R:Word";
        } else if (string.equals("Token")) {
            string2 = "R:SylStructure.parent.parent.R:Token.parent";
        } else {
            throw new IllegalArgumentException("Utterance.getItem(): relation cannot be " + string);
        }
        PathExtractor pathExtractor = new PathExtractor(string2, false);
        Item item = Utterance.getItem(this.getRelation(string), f);
        if (item != null) {
            return pathExtractor.findItem(item);
        }
        return null;
    }

    private static Item getItem(Relation relation, float f) {
        Item item = relation.getTail();
        float f2 = Utterance.getSegmentEnd(item);
        if (f < 0.0f || f2 < f) {
            return null;
        }
        if (f2 - f > f) {
            return Utterance.findFromFront(relation, f);
        }
        return Utterance.findFromEnd(relation, f);
    }

    private static Item findFromEnd(Relation relation, float f) {
        Item item;
        for (item = relation.getTail(); item != null && Utterance.getSegmentEnd(item) > f; item = item.getPrevious()) {
        }
        if (item != relation.getTail()) {
            item = item.getNext();
        }
        return item;
    }

    private static Item findFromFront(Relation relation, float f) {
        Item item;
        for (item = relation.getHead(); item != null && f > Utterance.getSegmentEnd(item); item = item.getNext()) {
        }
        return item;
    }

    private static float getSegmentEnd(Item item) {
        FeatureSet featureSet = item.getFeatures();
        return featureSet.getFloat("end");
    }

    private void setTokenList(Iterator<Token> iterator) {
        Relation relation = this.createRelation("Token");
        while (iterator.hasNext()) {
            Token token = iterator.next();
            String string = token.getWord();
            if (string == null || string.length() <= 0) continue;
            Item item = relation.appendItem();
            FeatureSet featureSet = item.getFeatures();
            featureSet.setString("name", string);
            featureSet.setString("whitespace", token.getWhitespace());
            featureSet.setString("prepunctuation", token.getPrepunctuation());
            featureSet.setString("punc", token.getPostpunctuation());
            featureSet.setString("file_pos", String.valueOf(token.getPosition()));
            featureSet.setString("line_number", String.valueOf(token.getLineNumber()));
        }
    }
}

