/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment.tokenizer;

import edu.cmu.sphinx.alignment.USEnglishTokenizer;
import edu.cmu.sphinx.alignment.tokenizer.FeatureSet;
import edu.cmu.sphinx.alignment.tokenizer.Item;
import edu.cmu.sphinx.alignment.tokenizer.Relation;
import edu.cmu.sphinx.alignment.tokenizer.Utterance;

public class WordRelation {
    private Relation relation;
    private USEnglishTokenizer tokenToWords;

    private WordRelation(Relation relation, USEnglishTokenizer uSEnglishTokenizer) {
        this.relation = relation;
        this.tokenToWords = uSEnglishTokenizer;
    }

    public static WordRelation createWordRelation(Utterance utterance, USEnglishTokenizer uSEnglishTokenizer) {
        Relation relation = utterance.createRelation("Word");
        return new WordRelation(relation, uSEnglishTokenizer);
    }

    public void addBreak() {
        Item item = this.relation.getTail();
        if (item != null) {
            FeatureSet featureSet = item.getFeatures();
            featureSet.setString("break", "1");
        }
    }

    public void addWord(String string) {
        Item item = this.tokenToWords.getTokenItem();
        Item item2 = item.createDaughter();
        FeatureSet featureSet = item2.getFeatures();
        featureSet.setString("name", string);
        this.relation.appendItem(item2);
    }

    public void setLastWord(String string) {
        Item item = this.relation.getTail();
        FeatureSet featureSet = item.getFeatures();
        featureSet.setString("name", string);
    }

    public Item getTail() {
        return this.relation.getTail();
    }
}

