/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.api;

import edu.cmu.sphinx.api.Configuration;
import edu.cmu.sphinx.api.Context;
import edu.cmu.sphinx.api.SpeechResult;
import edu.cmu.sphinx.api.SpeechSourceProvider;
import edu.cmu.sphinx.decoder.adaptation.ClusteredDensityFileData;
import edu.cmu.sphinx.decoder.adaptation.Stats;
import edu.cmu.sphinx.decoder.adaptation.Transform;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Sphinx3Loader;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Result;
import java.io.IOException;

public class AbstractSpeechRecognizer {
    protected final Context context;
    protected final Recognizer recognizer;
    protected ClusteredDensityFileData clusters;
    protected final SpeechSourceProvider speechSourceProvider;

    public AbstractSpeechRecognizer(Configuration configuration) throws IOException {
        this(new Context(configuration));
    }

    protected AbstractSpeechRecognizer(Context context) throws IOException {
        this.context = context;
        this.recognizer = context.getInstance(Recognizer.class);
        this.speechSourceProvider = new SpeechSourceProvider();
    }

    public SpeechResult getResult() {
        Result result = this.recognizer.recognize();
        return null == result ? null : new SpeechResult(result);
    }

    public Stats createStats(int n) {
        this.clusters = new ClusteredDensityFileData(this.context.getLoader(), n);
        return new Stats(this.context.getLoader(), this.clusters);
    }

    public void setTransform(Transform transform) {
        if (this.clusters != null && transform != null) {
            this.context.getLoader().update(transform, this.clusters);
        }
    }

    public void loadTransform(String string, int n) throws Exception {
        this.clusters = new ClusteredDensityFileData(this.context.getLoader(), n);
        Transform transform = new Transform((Sphinx3Loader)this.context.getLoader(), n);
        transform.load(string);
        this.context.getLoader().update(transform, this.clusters);
    }
}

