/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.api;

import edu.cmu.sphinx.api.Configuration;
import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.util.TimeFrame;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;

public class Context {
    private final ConfigurationManager configurationManager;

    public Context(Configuration configuration) throws IOException, MalformedURLException {
        this("resource:/edu/cmu/sphinx/api/default.config.xml", configuration);
    }

    public Context(String string, Configuration configuration) throws IOException, MalformedURLException {
        this.configurationManager = new ConfigurationManager(ConfigurationManagerUtils.resourceToURL(string));
        this.setAcousticModel(configuration.getAcousticModelPath());
        this.setDictionary(configuration.getDictionaryPath());
        if (null != configuration.getGrammarPath() && configuration.getUseGrammar()) {
            this.setGrammar(configuration.getGrammarPath(), configuration.getGrammarName());
        }
        if (null != configuration.getLanguageModelPath() && !configuration.getUseGrammar()) {
            this.setLanguageModel(configuration.getLanguageModelPath());
        }
        this.setSampleRate(configuration.getSampleRate());
        this.configurationManager.lookup("recognizer");
    }

    public void setAcousticModel(String string) throws IOException {
        this.setLocalProperty("acousticModelLoader->location", string);
        this.setLocalProperty("dictionary->fillerPath", Utilities.pathJoin(string, "noisedict"));
    }

    public void setDictionary(String string) {
        this.setLocalProperty("dictionary->dictionaryPath", string);
    }

    public void setSampleRate(int n) {
        this.setLocalProperty("dataSource->sampleRate", Integer.toString(n));
    }

    public void setGrammar(String string, String string2) {
        if (string2.endsWith(".grxml")) {
            this.setLocalProperty("grXmlGrammar->grammarLocation", string + string2);
            this.setLocalProperty("flatLinguist->grammar", "grXmlGrammar");
        } else {
            this.setLocalProperty("jsgfGrammar->grammarLocation", string);
            this.setLocalProperty("jsgfGrammar->grammarName", string2);
            this.setLocalProperty("flatLinguist->grammar", "jsgfGrammar");
        }
        this.setLocalProperty("decoder->searchManager", "simpleSearchManager");
    }

    public void setLanguageModel(String string) {
        if (string.endsWith(".lm")) {
            this.setLocalProperty("simpleNGramModel->location", string);
            this.setLocalProperty("lexTreeLinguist->languageModel", "simpleNGramModel");
        } else if (string.endsWith(".dmp")) {
            this.setLocalProperty("largeTrigramModel->location", string);
            this.setLocalProperty("lexTreeLinguist->languageModel", "largeTrigramModel");
        } else if (string.endsWith(".bin")) {
            this.setLocalProperty("trieNgramModel->location", string);
            this.setLocalProperty("lexTreeLinguist->languageModel", "trieNgramModel");
        } else {
            throw new IllegalArgumentException("Unknown format extension: " + string);
        }
    }

    public void setSpeechSource(InputStream inputStream, TimeFrame timeFrame) {
        this.getInstance(StreamDataSource.class).setInputStream(inputStream, timeFrame);
        this.setLocalProperty("trivialScorer->frontend", "liveFrontEnd");
    }

    public void setSpeechSource(InputStream inputStream) {
        this.getInstance(StreamDataSource.class).setInputStream(inputStream);
        this.setLocalProperty("trivialScorer->frontend", "liveFrontEnd");
    }

    public void setLocalProperty(String string, Object object) {
        ConfigurationManagerUtils.setProperty(this.configurationManager, string, object.toString());
    }

    public void setGlobalProperty(String string, Object object) {
        this.configurationManager.setGlobalProperty(string, object.toString());
    }

    public <C extends Configurable> C getInstance(Class<C> clazz) {
        return this.configurationManager.lookup(clazz);
    }

    public Loader getLoader() {
        return (Loader)this.configurationManager.lookup("acousticModelLoader");
    }
}

