/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.api;

import edu.cmu.sphinx.alignment.LongTextAligner;
import edu.cmu.sphinx.alignment.SimpleTokenizer;
import edu.cmu.sphinx.alignment.TextTokenizer;
import edu.cmu.sphinx.api.Configuration;
import edu.cmu.sphinx.api.Context;
import edu.cmu.sphinx.linguist.language.grammar.AlignerGrammar;
import edu.cmu.sphinx.linguist.language.ngram.DynamicTrigramModel;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.result.WordResult;
import edu.cmu.sphinx.util.Range;
import edu.cmu.sphinx.util.TimeFrame;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.logging.Logger;

public class SpeechAligner {
    private final Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private static final int TUPLE_SIZE = 3;
    private final Context context;
    private final Recognizer recognizer;
    private final AlignerGrammar grammar;
    private final DynamicTrigramModel languageModel;
    private TextTokenizer tokenizer;

    public SpeechAligner(String string, String string2, String string3) throws MalformedURLException, IOException {
        Configuration configuration = new Configuration();
        configuration.setAcousticModelPath(string);
        configuration.setDictionaryPath(string2);
        this.context = new Context(configuration);
        if (string3 != null) {
            this.context.setLocalProperty("dictionary->g2pModelPath", string3);
            this.context.setLocalProperty("dictionary->g2pMaxPron", "2");
        }
        this.context.setLocalProperty("lexTreeLinguist->languageModel", "dynamicTrigramModel");
        this.recognizer = this.context.getInstance(Recognizer.class);
        this.grammar = this.context.getInstance(AlignerGrammar.class);
        this.languageModel = this.context.getInstance(DynamicTrigramModel.class);
        this.setTokenizer(new SimpleTokenizer());
    }

    public List<WordResult> align(URL uRL, String string) throws IOException {
        return this.align(uRL, this.getTokenizer().expand(string));
    }

    public List<WordResult> align(URL uRL, List<String> list) throws IOException {
        List<String> list2 = this.sentenceToWords(list);
        LongTextAligner longTextAligner = new LongTextAligner(list2, 3);
        TreeMap<Integer, WordResult> treeMap = new TreeMap<Integer, WordResult>();
        LinkedList<Range> linkedList = new LinkedList<Range>();
        ArrayDeque<List<String>> arrayDeque = new ArrayDeque<List<String>>();
        ArrayDeque<TimeFrame> arrayDeque2 = new ArrayDeque<TimeFrame>();
        linkedList.offer(new Range(0, list2.size()));
        arrayDeque.offer(list2);
        TimeFrame timeFrame = TimeFrame.INFINITE;
        arrayDeque2.offer(timeFrame);
        long l = TimeFrame.INFINITE.getEnd();
        this.languageModel.setText(list);
        for (int i = 0; i < 4; ++i) {
            if (i == 1) {
                this.context.setLocalProperty("decoder->searchManager", "alignerSearchManager");
            }
            while (!arrayDeque.isEmpty()) {
                Result result;
                assert (arrayDeque.size() == linkedList.size());
                assert (arrayDeque.size() == arrayDeque2.size());
                List list3 = (List)arrayDeque.poll();
                TimeFrame timeFrame2 = (TimeFrame)arrayDeque2.poll();
                Range range = (Range)linkedList.poll();
                this.logger.info("Aligning frame " + timeFrame2 + " to text " + list3 + " range " + range);
                this.recognizer.allocate();
                if (i >= 1) {
                    this.grammar.setWords(list3);
                }
                this.context.setSpeechSource(uRL.openStream(), timeFrame2);
                ArrayList<WordResult> arrayList = new ArrayList<WordResult>();
                while (null != (result = this.recognizer.recognize())) {
                    this.logger.info("Utterance result " + result.getTimedBestResult(true));
                    arrayList.addAll(result.getTimedBestResult(false));
                }
                if (i == 0 && arrayList.size() > 0) {
                    l = ((WordResult)arrayList.get(arrayList.size() - 1)).getTimeFrame().getEnd();
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (WordResult wordResult : arrayList) {
                    arrayList2.add(wordResult.getWord().getSpelling());
                }
                Object object3 = longTextAligner.align(arrayList2, range);
                ArrayList<WordResult> object2 = arrayList;
                this.logger.info("Decoding result is " + object2);
                this.dumpAlignmentStats(list2, (int[])object3, object2);
                for (int j = 0; j < ((Object)object3).length; ++j) {
                    if (object3[j] == -1) continue;
                    treeMap.put((int)object3[j], (WordResult)arrayList.get(j));
                }
                this.recognizer.deallocate();
            }
            this.scheduleNextAlignment(list2, treeMap, linkedList, arrayDeque, arrayDeque2, l);
        }
        return new ArrayList<WordResult>(treeMap.values());
    }

    public List<String> sentenceToWords(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\s+")) {
                if (string2.length() <= 0) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private void dumpAlignmentStats(List<String> list, int[] nArray, List<WordResult> list2) {
        int n = 0;
        int n2 = 0;
        int n3 = list.size();
        int[] nArray2 = nArray;
        int n4 = -1;
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == -1) {
                ++n;
                continue;
            }
            if (nArray2[i] - n4 > 1) {
                n2 += nArray2[i] - n4;
            }
            n4 = nArray2[i];
        }
        if (n4 >= 0 && list.size() - n4 > 1) {
            n2 += list.size() - n4;
        }
        this.logger.info(String.format("Size %d deletions %d insertions %d error rate %.2f", n3, n, n2, Float.valueOf((float)(n + n2) / (float)n3 * 100.0f)));
    }

    private void scheduleNextAlignment(List<String> list, Map<Integer, WordResult> map, Queue<Range> queue, Queue<List<String>> queue2, Queue<TimeFrame> queue3, long l) {
        int n = 0;
        long l2 = 0L;
        for (Map.Entry<Integer, WordResult> entry : map.entrySet()) {
            if (entry.getKey() - n > 1) {
                this.checkedOffer(list, queue2, queue3, queue, n, entry.getKey() + 1, l2, entry.getValue().getTimeFrame().getEnd());
            }
            n = entry.getKey();
            l2 = entry.getValue().getTimeFrame().getStart();
        }
        if (list.size() - n > 1) {
            this.checkedOffer(list, queue2, queue3, queue, n, list.size(), l2, l);
        }
    }

    public void dumpAlignment(List<String> list, int[] nArray, List<WordResult> list2) {
        this.logger.info("Alignment");
        int[] nArray2 = nArray;
        int n = -1;
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == -1) {
                this.logger.info(String.format("+ %s", list2.get(i)));
                continue;
            }
            if (nArray2[i] - n > 1) {
                for (String string : list.subList(n + 1, nArray2[i])) {
                    this.logger.info(String.format("- %-25s", string));
                }
            } else {
                this.logger.info(String.format("  %-25s", list.get(nArray2[i])));
            }
            n = nArray2[i];
        }
        if (n >= 0 && list.size() - n > 1) {
            for (String string : list.subList(n + 1, list.size())) {
                this.logger.info(String.format("- %-25s", string));
            }
        }
    }

    private void checkedOffer(List<String> list, Queue<List<String>> queue, Queue<TimeFrame> queue2, Queue<Range> queue3, int n, int n2, long l, long l2) {
        double d = (double)(l2 - l) / (double)(n2 - n);
        if (d < 10.0 && n2 - n > 3) {
            this.logger.info("Skipping text range due to a high density " + list.subList(n, n2).toString());
            return;
        }
        queue.offer(list.subList(n, n2));
        queue2.offer(new TimeFrame(l, l2));
        queue3.offer(new Range(n, n2 - 1));
    }

    public TextTokenizer getTokenizer() {
        return this.tokenizer;
    }

    public void setTokenizer(TextTokenizer textTokenizer) {
        this.tokenizer = textTokenizer;
    }
}

