/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder;

import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.decoder.ResultProducer;
import edu.cmu.sphinx.decoder.search.SearchManager;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4ComponentList;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractDecoder
implements ResultProducer,
Configurable {
    @S4Component(type=SearchManager.class)
    public static final String PROP_SEARCH_MANAGER = "searchManager";
    protected SearchManager searchManager;
    @S4ComponentList(type=ResultListener.class)
    public static final String PROP_RESULT_LISTENERS = "resultListeners";
    protected final List<ResultListener> resultListeners = new ArrayList<ResultListener>();
    @S4Boolean(defaultValue=false)
    public static final String AUTO_ALLOCATE = "autoAllocate";
    @S4Boolean(defaultValue=false)
    public static final String FIRE_NON_FINAL_RESULTS = "fireNonFinalResults";
    private boolean fireNonFinalResults;
    private String name;
    protected Logger logger;

    public AbstractDecoder() {
    }

    public AbstractDecoder(SearchManager searchManager, boolean bl, boolean bl2, List<ResultListener> list) {
        String string = this.getClass().getName();
        this.init(string, Logger.getLogger(string), searchManager, bl, bl2, list);
    }

    public abstract Result decode(String var1);

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.init(propertySheet.getInstanceName(), propertySheet.getLogger(), (SearchManager)propertySheet.getComponent(PROP_SEARCH_MANAGER), propertySheet.getBoolean(FIRE_NON_FINAL_RESULTS), propertySheet.getBoolean(AUTO_ALLOCATE), propertySheet.getComponentList(PROP_RESULT_LISTENERS, ResultListener.class));
    }

    private void init(String string, Logger logger, SearchManager searchManager, boolean bl, boolean bl2, List<ResultListener> list) {
        this.name = string;
        this.logger = logger;
        this.searchManager = searchManager;
        this.fireNonFinalResults = bl;
        if (bl2) {
            searchManager.allocate();
        }
        for (ResultListener resultListener : list) {
            this.addResultListener(resultListener);
        }
    }

    public void allocate() {
        this.searchManager.allocate();
    }

    public void deallocate() {
        this.searchManager.deallocate();
    }

    @Override
    public void addResultListener(ResultListener resultListener) {
        this.resultListeners.add(resultListener);
    }

    @Override
    public void removeResultListener(ResultListener resultListener) {
        this.resultListeners.remove(resultListener);
    }

    protected void fireResultListeners(Result result) {
        if (this.fireNonFinalResults || result.isFinal()) {
            for (ResultListener resultListener : this.resultListeners) {
                resultListener.newResult(result);
            }
        } else {
            this.logger.finer("skipping non-final result " + result);
        }
    }

    public String toString() {
        return this.name;
    }
}

