/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder;

import edu.cmu.sphinx.decoder.AbstractDecoder;
import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.decoder.search.SearchManager;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.List;

public class Decoder
extends AbstractDecoder {
    @S4Integer(defaultValue=0x7FFFFFFF)
    public static final String PROP_FEATURE_BLOCK_SIZE = "featureBlockSize";
    private int featureBlockSize;

    public Decoder() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.featureBlockSize = propertySheet.getInt(PROP_FEATURE_BLOCK_SIZE);
    }

    public Decoder(SearchManager searchManager, boolean bl, boolean bl2, List<ResultListener> list, int n) {
        super(searchManager, bl, bl2, list);
        this.featureBlockSize = n;
    }

    @Override
    public Result decode(String string) {
        Result result;
        this.searchManager.startRecognition();
        do {
            if ((result = this.searchManager.recognize(this.featureBlockSize)) == null) continue;
            result.setReferenceText(string);
            this.fireResultListeners(result);
        } while (result != null && !result.isFinal());
        this.searchManager.stopRecognition();
        return result;
    }
}

