/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder;

import edu.cmu.sphinx.decoder.AbstractDecoder;
import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.decoder.search.SearchManager;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataProcessor;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.frontend.endpoint.SpeechStartSignal;
import edu.cmu.sphinx.result.Result;
import java.util.List;

public class FrameDecoder
extends AbstractDecoder
implements DataProcessor {
    private DataProcessor predecessor;
    private boolean isRecognizing;
    private Result result;

    public FrameDecoder(SearchManager searchManager, boolean bl, boolean bl2, List<ResultListener> list) {
        super(searchManager, bl, bl2, list);
    }

    public FrameDecoder() {
    }

    @Override
    public Result decode(String string) {
        return this.searchManager.recognize(1);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        if (this.isRecognizing && (data instanceof FloatData || data instanceof DoubleData || data instanceof SpeechEndSignal)) {
            this.result = this.decode(null);
            if (this.result != null) {
                this.fireResultListeners(this.result);
                this.result = null;
            }
        }
        if (data instanceof DataEndSignal) {
            this.searchManager.stopRecognition();
        }
        if (data instanceof SpeechStartSignal) {
            this.searchManager.startRecognition();
            this.isRecognizing = true;
            this.result = null;
        }
        if (data instanceof SpeechEndSignal) {
            this.searchManager.stopRecognition();
            if (this.result != null) {
                this.fireResultListeners(this.result);
            }
            this.isRecognizing = false;
        }
        return data;
    }

    @Override
    public DataProcessor getPredecessor() {
        return this.predecessor;
    }

    @Override
    public void setPredecessor(DataProcessor dataProcessor) {
        this.predecessor = dataProcessor;
    }

    @Override
    public void initialize() {
    }
}

