/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.adaptation;

import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.math3.util.FastMath;

public class ClusteredDensityFileData {
    private int numberOfClusters;
    private int[] corespondingClass;

    public ClusteredDensityFileData(Loader loader, int n) {
        this.numberOfClusters = n;
        this.kMeansClustering(loader, 30);
    }

    public int getNumberOfClusters() {
        return this.numberOfClusters;
    }

    public int getClassIndex(int n) {
        return this.corespondingClass[n];
    }

    private float euclidianDistance(float[] fArray, float[] fArray2) {
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            double d2 = fArray[i] - fArray2[i];
            d += d2 * d2;
        }
        return (float)FastMath.sqrt((double)d);
    }

    private boolean isEqual(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            return false;
        }
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == fArray2[i]) continue;
            return false;
        }
        return true;
    }

    private void kMeansClustering(Loader loader, int n) {
        int n2;
        int n3;
        Pool<float[]> pool = loader.getMeansPool();
        ArrayList<Object> arrayList = new ArrayList<Object>(this.numberOfClusters);
        ArrayList<float[]> arrayList2 = new ArrayList<float[]>(this.numberOfClusters);
        int n4 = pool.size();
        int n5 = n;
        int[] nArray = new int[this.numberOfClusters];
        float[][][] fArray = new float[this.numberOfClusters][n4][];
        boolean bl = false;
        Random random = new Random();
        for (n3 = 0; n3 < this.numberOfClusters; ++n3) {
            n2 = random.nextInt(n4);
            arrayList2.add(pool.get(n2));
            arrayList.add(pool.get(n2));
            nArray[n3] = 0;
        }
        n2 = 0;
        while (!bl && n5 > 0) {
            int n6;
            this.corespondingClass = new int[pool.size()];
            fArray = new float[this.numberOfClusters][n4][];
            for (n3 = 0; n3 < this.numberOfClusters; ++n3) {
                arrayList.set(n3, arrayList2.get(n3));
                nArray[n3] = 0;
            }
            for (n3 = 0; n3 < pool.size(); ++n3) {
                float[] fArray2 = pool.get(n3);
                double d = this.euclidianDistance((float[])arrayList.get(0), fArray2);
                n2 = 0;
                for (n6 = 1; n6 < this.numberOfClusters; ++n6) {
                    double d2 = this.euclidianDistance((float[])arrayList.get(n6), fArray2);
                    if (!(d2 < d)) continue;
                    d = d2;
                    n2 = n6;
                }
                fArray[n2][nArray[n2]] = fArray2;
                this.corespondingClass[n3] = n2;
                int n7 = n2;
                nArray[n7] = nArray[n7] + 1;
            }
            for (n3 = 0; n3 < this.numberOfClusters; ++n3) {
                float[] fArray3 = new float[pool.get(0).length];
                if (nArray[n3] <= 0) continue;
                for (n6 = 0; n6 < nArray[n3]; ++n6) {
                    for (int i = 0; i < pool.get(0).length; ++i) {
                        int n8 = i;
                        fArray3[n8] = fArray3[n8] + fArray[n3][n6][i];
                    }
                }
                n6 = 0;
                while (n6 < pool.get(0).length) {
                    int n9 = n6++;
                    fArray3[n9] = fArray3[n9] / (float)nArray[n3];
                }
                arrayList2.set(n3, fArray3);
            }
            bl = true;
            for (n3 = 0; n3 < this.numberOfClusters; ++n3) {
                bl = bl && this.isEqual((float[])arrayList2.get(n3), (float[])arrayList.get(n3));
            }
            --n5;
        }
    }
}

