/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.adaptation;

import edu.cmu.sphinx.api.SpeechResult;
import edu.cmu.sphinx.decoder.adaptation.ClusteredDensityFileData;
import edu.cmu.sphinx.decoder.adaptation.Transform;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.linguist.HMMSearchState;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Sphinx3Loader;
import edu.cmu.sphinx.util.LogMath;

public class Stats {
    private static final int MIN_FRAMES = 300;
    private ClusteredDensityFileData means;
    private double[][][][][] regLs;
    private double[][][][] regRs;
    private int nClusters;
    private Sphinx3Loader loader;
    private float varFlor;
    private LogMath logMath = LogMath.getLogMath();
    private int nFrames;

    public Stats(Loader loader, ClusteredDensityFileData clusteredDensityFileData) {
        this.loader = (Sphinx3Loader)loader;
        this.nClusters = clusteredDensityFileData.getNumberOfClusters();
        this.means = clusteredDensityFileData;
        this.varFlor = 1.0E-5f;
        this.invertVariances();
        this.init();
        this.nFrames = 0;
    }

    private void init() {
        int n = this.loader.getVectorLength()[0];
        this.regLs = new double[this.nClusters][][][][];
        this.regRs = new double[this.nClusters][][][];
        for (int i = 0; i < this.nClusters; ++i) {
            this.regLs[i] = new double[this.loader.getNumStreams()][][][];
            this.regRs[i] = new double[this.loader.getNumStreams()][][];
            for (int j = 0; j < this.loader.getNumStreams(); ++j) {
                n = this.loader.getVectorLength()[j];
                this.regLs[i][j] = new double[n][n + 1][n + 1];
                this.regRs[i][j] = new double[n][n + 1];
            }
        }
    }

    public ClusteredDensityFileData getClusteredData() {
        return this.means;
    }

    public double[][][][][] getRegLs() {
        return this.regLs;
    }

    public double[][][][] getRegRs() {
        return this.regRs;
    }

    private void invertVariances() {
        for (int i = 0; i < this.loader.getNumStates(); ++i) {
            for (int j = 0; j < this.loader.getNumGaussiansPerState(); ++j) {
                for (int k = 0; k < this.loader.getVectorLength()[0]; ++k) {
                    this.loader.getVariancePool().get((int)(i * this.loader.getNumGaussiansPerState() + j))[k] = (double)this.loader.getVariancePool().get(i * this.loader.getNumGaussiansPerState() + j)[k] <= 0.0 ? 0.5f : (this.loader.getVariancePool().get(i * this.loader.getNumGaussiansPerState() + j)[k] < this.varFlor ? (float)(1.0 / (double)this.varFlor) : (float)(1.0 / (double)this.loader.getVariancePool().get(i * this.loader.getNumGaussiansPerState() + j)[k]));
                }
            }
        }
    }

    private float[] computePosterios(float[] fArray, int n) {
        float[] fArray2 = fArray;
        int n2 = fArray.length / n;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4;
            float f = fArray2[n3];
            for (n4 = n3 + 1; n4 < n3 + n2; ++n4) {
                if (!(fArray2[n4] > f)) continue;
                f = fArray2[n4];
            }
            for (n4 = n3; n4 < n3 + n2; ++n4) {
                fArray2[n4] = (float)this.logMath.logToLinear(fArray2[n4] - f);
            }
            n3 += n2;
        }
        return fArray2;
    }

    public void collect(SpeechResult speechResult) throws Exception {
        Token token = speechResult.getResult().getBestToken();
        if (token == null) {
            throw new Exception("Best token not found!");
        }
        do {
            FloatData floatData = (FloatData)token.getData();
            SearchState searchState = token.getSearchState();
            if (!(searchState instanceof HMMSearchState) || !searchState.isEmitting()) {
                token = token.getPredecessor();
                continue;
            }
            ++this.nFrames;
            float[] fArray = token.calculateComponentScore(floatData);
            float[] fArray2 = FloatData.toFloatData(floatData).getValues();
            int n = (int)((HMMSearchState)token.getSearchState()).getHMMState().getMixtureId();
            if (this.loader instanceof Sphinx3Loader && this.loader.hasTiedMixtures()) {
                n = this.loader.getSenone2Ci()[n];
            }
            int[] nArray = this.loader.getVectorLength();
            int n2 = this.loader.getNumStreams();
            int n3 = this.loader.getNumGaussiansPerState();
            float[] fArray3 = this.computePosterios(fArray, n2);
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n5 = this.means.getClassIndex(n * n2 * n3 + i * n3 + j);
                    float f = fArray3[i * n3 + j];
                    if (!((double)f > 0.0)) continue;
                    float[] fArray4 = this.loader.getMeansPool().get(n * n2 * n3 + i * n3 + j);
                    for (int k = 0; k < nArray[i]; ++k) {
                        float f2 = fArray3[i * n3 + j] * fArray2[k + n4];
                        float f3 = f2 * this.loader.getVariancePool().get(n * n2 * n3 + i * n3 + j)[k];
                        float f4 = f * this.loader.getVariancePool().get(n * n2 * n3 + i * n3 + j)[k];
                        for (int i2 = 0; i2 < nArray[i]; ++i2) {
                            float f5 = f4 * fArray4[i2];
                            for (int i3 = i2; i3 < nArray[i]; ++i3) {
                                double[] dArray = this.regLs[n5][i][k][i2];
                                int n6 = i3;
                                dArray[n6] = dArray[n6] + (double)(f5 * fArray4[i3]);
                            }
                            double[] dArray = this.regLs[n5][i][k][i2];
                            int n7 = nArray[i];
                            dArray[n7] = dArray[n7] + (double)f5;
                            double[] dArray2 = this.regRs[n5][i][k];
                            int n8 = i2;
                            dArray2[n8] = dArray2[n8] + (double)(f3 * fArray4[i2]);
                        }
                        double[] dArray = this.regLs[n5][i][k][nArray[i]];
                        int n9 = nArray[i];
                        dArray[n9] = dArray[n9] + (double)f4;
                        double[] dArray3 = this.regRs[n5][i][k];
                        int n10 = nArray[i];
                        dArray3[n10] = dArray3[n10] + (double)f3;
                    }
                }
                n4 += nArray[i];
            }
            token = token.getPredecessor();
        } while (token != null);
    }

    public void fillRegLowerPart() {
        for (int i = 0; i < this.nClusters; ++i) {
            for (int j = 0; j < this.loader.getNumStreams(); ++j) {
                for (int k = 0; k < this.loader.getVectorLength()[j]; ++k) {
                    for (int i2 = 0; i2 <= this.loader.getVectorLength()[j]; ++i2) {
                        for (int i3 = i2 + 1; i3 <= this.loader.getVectorLength()[j]; ++i3) {
                            this.regLs[i][j][k][i3][i2] = this.regLs[i][j][k][i2][i3];
                        }
                    }
                }
            }
        }
    }

    public Transform createTransform() {
        if (this.nFrames < 300 * this.nClusters) {
            return null;
        }
        Transform transform = new Transform(this.loader, this.nClusters);
        transform.update(this);
        return transform;
    }

    public int getFrames() {
        return this.nFrames;
    }
}

