/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.adaptation;

import edu.cmu.sphinx.decoder.adaptation.Stats;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Sphinx3Loader;
import java.io.File;
import java.io.PrintWriter;
import java.util.Scanner;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class Transform {
    private float[][][][] As;
    private float[][][] Bs;
    private Sphinx3Loader loader;
    private int nrOfClusters;

    public Transform(Sphinx3Loader sphinx3Loader, int n) {
        this.loader = sphinx3Loader;
        this.nrOfClusters = n;
    }

    public float[][][][] getAs() {
        return this.As;
    }

    public float[][][] getBs() {
        return this.Bs;
    }

    public void store(String string, int n) throws Exception {
        PrintWriter printWriter = new PrintWriter(string, "UTF-8");
        printWriter.println("1");
        printWriter.println(this.loader.getNumStreams());
        for (int i = 0; i < this.loader.getNumStreams(); ++i) {
            int n2;
            printWriter.println(this.loader.getVectorLength()[i]);
            for (n2 = 0; n2 < this.loader.getVectorLength()[i]; ++n2) {
                for (int j = 0; j < this.loader.getVectorLength()[i]; ++j) {
                    printWriter.print(this.As[n][i][n2][j]);
                    printWriter.print(" ");
                }
                printWriter.println();
            }
            for (n2 = 0; n2 < this.loader.getVectorLength()[i]; ++n2) {
                printWriter.print(this.Bs[n][i][n2]);
                printWriter.print(" ");
            }
            printWriter.println();
            for (n2 = 0; n2 < this.loader.getVectorLength()[i]; ++n2) {
                printWriter.print("1.0 ");
            }
            printWriter.println();
        }
        printWriter.close();
    }

    private void computeMllrTransforms(double[][][][][] dArray, double[][][][] dArray2) {
        for (int i = 0; i < this.nrOfClusters; ++i) {
            this.As[i] = new float[this.loader.getNumStreams()][][];
            this.Bs[i] = new float[this.loader.getNumStreams()][];
            for (int j = 0; j < this.loader.getNumStreams(); ++j) {
                int n = this.loader.getVectorLength()[j];
                this.As[i][j] = new float[n][n];
                this.Bs[i][j] = new float[n];
                for (int k = 0; k < n; ++k) {
                    Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(dArray[i][j][k], false);
                    DecompositionSolver decompositionSolver = new LUDecomposition((RealMatrix)array2DRowRealMatrix).getSolver();
                    ArrayRealVector arrayRealVector = new ArrayRealVector(dArray2[i][j][k], false);
                    RealVector realVector = decompositionSolver.solve((RealVector)arrayRealVector);
                    for (int i2 = 0; i2 < n; ++i2) {
                        this.As[i][j][k][i2] = (float)realVector.getEntry(i2);
                    }
                    this.Bs[i][j][k] = (float)realVector.getEntry(n);
                }
            }
        }
    }

    public void load(String string) throws Exception {
        Scanner scanner = new Scanner(new File(string));
        int n = scanner.nextInt();
        assert (n == 1);
        int n2 = scanner.nextInt();
        this.As = new float[n][n2][][];
        this.Bs = new float[n][n2][];
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = scanner.nextInt();
            this.As[0][i] = new float[n4][n4];
            this.Bs[0][i] = new float[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                for (int j = 0; j < n4; ++j) {
                    this.As[0][i][n3][j] = scanner.nextFloat();
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                this.Bs[0][i][n3] = scanner.nextFloat();
            }
            for (n3 = 0; n3 < n4; ++n3) {
                scanner.nextFloat();
            }
        }
        scanner.close();
    }

    public void update(Stats stats) {
        stats.fillRegLowerPart();
        this.As = new float[this.nrOfClusters][][][];
        this.Bs = new float[this.nrOfClusters][][];
        this.computeMllrTransforms(stats.getRegLs(), stats.getRegRs());
    }
}

