/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.scorer;

import edu.cmu.sphinx.decoder.scorer.AcousticScorer;
import edu.cmu.sphinx.decoder.scorer.ScoreNormalizer;
import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.Signal;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.frontend.util.DataUtil;
import edu.cmu.sphinx.util.props.ConfigurableAdapter;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.util.LinkedList;
import java.util.List;

public class SimpleAcousticScorer
extends ConfigurableAdapter
implements AcousticScorer {
    @S4Component(type=BaseDataProcessor.class)
    public static final String FEATURE_FRONTEND = "frontend";
    protected BaseDataProcessor frontEnd;
    @S4Component(type=ScoreNormalizer.class, mandatory=false)
    public static final String SCORE_NORMALIZER = "scoreNormalizer";
    protected ScoreNormalizer scoreNormalizer;
    private LinkedList<Data> storedData;
    private boolean seenEnd = false;

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.frontEnd = (BaseDataProcessor)propertySheet.getComponent(FEATURE_FRONTEND);
        this.scoreNormalizer = (ScoreNormalizer)propertySheet.getComponent(SCORE_NORMALIZER);
        this.storedData = new LinkedList();
    }

    public SimpleAcousticScorer(BaseDataProcessor baseDataProcessor, ScoreNormalizer scoreNormalizer) {
        this.initLogger();
        this.frontEnd = baseDataProcessor;
        this.scoreNormalizer = scoreNormalizer;
        this.storedData = new LinkedList();
    }

    public SimpleAcousticScorer() {
    }

    @Override
    public Data calculateScores(List<? extends Scoreable> list) {
        Data data;
        if (this.storedData.isEmpty()) {
            while ((data = this.getNextData()) instanceof Signal) {
                if (data instanceof SpeechEndSignal) {
                    this.seenEnd = true;
                    break;
                }
                if (!(data instanceof DataEndSignal)) continue;
                if (!this.seenEnd) break;
                return null;
            }
            if (data == null) {
                return null;
            }
        } else {
            data = this.storedData.poll();
        }
        return this.calculateScoresForData(list, data);
    }

    @Override
    public Data calculateScoresAndStoreData(List<? extends Scoreable> list) {
        Data data;
        while ((data = this.getNextData()) instanceof Signal) {
            if (data instanceof SpeechEndSignal) {
                this.seenEnd = true;
                break;
            }
            if (!(data instanceof DataEndSignal)) continue;
            if (!this.seenEnd) break;
            return null;
        }
        if (data == null) {
            return null;
        }
        this.storedData.add(data);
        return this.calculateScoresForData(list, data);
    }

    protected Data calculateScoresForData(List<? extends Scoreable> list, Data data) {
        if (data instanceof SpeechEndSignal || data instanceof DataEndSignal) {
            return data;
        }
        if (list.isEmpty()) {
            return null;
        }
        if (data instanceof DoubleData) {
            data = DataUtil.DoubleData2FloatData((DoubleData)data);
        }
        Scoreable scoreable = this.doScoring(list, data);
        if (this.scoreNormalizer != null && scoreable instanceof Token) {
            scoreable = this.scoreNormalizer.normalize(list, scoreable);
        }
        return scoreable;
    }

    protected Data getNextData() {
        Data data = this.frontEnd.getData();
        return data;
    }

    @Override
    public void startRecognition() {
        this.storedData.clear();
    }

    @Override
    public void stopRecognition() {
    }

    protected <T extends Scoreable> T doScoring(List<T> list, Data data) {
        Scoreable scoreable = null;
        float f = -3.4028235E38f;
        for (Scoreable scoreable2 : list) {
            scoreable2.calculateScore(data);
            if (!(scoreable2.getScore() > f)) continue;
            f = scoreable2.getScore();
            scoreable = scoreable2;
        }
        return (T)scoreable;
    }

    @Override
    public void allocate() {
    }

    @Override
    public void deallocate() {
    }
}

