/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.scorer;

import edu.cmu.sphinx.decoder.scorer.ScoreNormalizer;
import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.decoder.scorer.SimpleAcousticScorer;
import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.util.CustomThreadFactory;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ThreadedAcousticScorer
extends SimpleAcousticScorer {
    @S4Integer(defaultValue=5)
    public static final String PROP_THREAD_PRIORITY = "threadPriority";
    @S4Integer(defaultValue=0)
    public static final String PROP_NUM_THREADS = "numThreads";
    @S4Boolean(defaultValue=true)
    public static final String PROP_IS_CPU_RELATIVE = "isCpuRelative";
    @S4Integer(defaultValue=10)
    public static final String PROP_MIN_SCOREABLES_PER_THREAD = "minScoreablesPerThread";
    private static final String className = ThreadedAcousticScorer.class.getSimpleName();
    private int numThreads;
    private int threadPriority;
    private int minScoreablesPerThread;
    private ExecutorService executorService;

    public ThreadedAcousticScorer(BaseDataProcessor baseDataProcessor, ScoreNormalizer scoreNormalizer, int n, boolean bl, int n2, int n3) {
        super(baseDataProcessor, scoreNormalizer);
        this.init(n, bl, n2, n3);
    }

    public ThreadedAcousticScorer() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.init(propertySheet.getInt(PROP_MIN_SCOREABLES_PER_THREAD), propertySheet.getBoolean(PROP_IS_CPU_RELATIVE), propertySheet.getInt(PROP_NUM_THREADS), propertySheet.getInt(PROP_THREAD_PRIORITY));
    }

    private void init(int n, boolean bl, int n2, int n3) {
        this.minScoreablesPerThread = n;
        if (bl) {
            n2 += Runtime.getRuntime().availableProcessors();
        }
        this.numThreads = n2;
        this.threadPriority = n3;
    }

    @Override
    public void allocate() {
        super.allocate();
        if (this.executorService == null) {
            if (this.numThreads > 1) {
                this.logger.fine("# of scoring threads: " + this.numThreads);
                this.executorService = Executors.newFixedThreadPool(this.numThreads, new CustomThreadFactory(className, true, this.threadPriority));
            } else {
                this.logger.fine("no scoring threads");
            }
        }
    }

    @Override
    public void deallocate() {
        super.deallocate();
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }

    @Override
    protected <T extends Scoreable> T doScoring(List<T> list, final Data data) {
        int n;
        int n2;
        if (this.numThreads > 1 && (n2 = Math.max(((n = list.size()) + this.numThreads - 1) / this.numThreads, this.minScoreablesPerThread)) < n) {
            ArrayList<1> arrayList = new ArrayList<1>();
            int n3 = 0;
            int n4 = n2;
            while (n3 < n) {
                final List<T> object = list.subList(n3, Math.min(n4, n));
                arrayList.add(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return ThreadedAcousticScorer.super.doScoring(object, data);
                    }
                });
                n3 = n4;
                n4 += n2;
            }
            ArrayList arrayList2 = new ArrayList(arrayList.size());
            try {
                for (Future future : this.executorService.invokeAll(arrayList)) {
                    arrayList2.add(future.get());
                }
            }
            catch (Exception exception) {
                throw new DataProcessingException("No scoring jobs ended", exception);
            }
            return (T)Collections.min(arrayList2, Scoreable.COMPARATOR);
        }
        return super.doScoring(list, data);
    }
}

