/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;

public abstract class ActiveListFactory
implements Configurable {
    @S4Integer(defaultValue=-1)
    public static final String PROP_ABSOLUTE_BEAM_WIDTH = "absoluteBeamWidth";
    @S4Double(defaultValue=1.0E-80)
    public static final String PROP_RELATIVE_BEAM_WIDTH = "relativeBeamWidth";
    @S4Boolean(defaultValue=true)
    public static final String PROP_STRICT_PRUNING = "strictPruning";
    protected LogMath logMath;
    protected int absoluteBeamWidth;
    protected float logRelativeBeamWidth;

    public ActiveListFactory(int n, double d) {
        this.logMath = LogMath.getLogMath();
        this.absoluteBeamWidth = n;
        this.logRelativeBeamWidth = this.logMath.linearToLog(d);
    }

    public ActiveListFactory() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logMath = LogMath.getLogMath();
        this.absoluteBeamWidth = propertySheet.getInt(PROP_ABSOLUTE_BEAM_WIDTH);
        double d = propertySheet.getDouble(PROP_RELATIVE_BEAM_WIDTH);
        this.logRelativeBeamWidth = this.logMath.linearToLog(d);
    }

    public abstract ActiveList newInstance();
}

