/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.decoder.search.Token;
import java.util.Arrays;

public class Partitioner {
    private final int MAX_DEPTH = 50;

    private int endPointPartition(Token[] tokenArray, int n, int n2) {
        Token token = tokenArray[n2];
        float f = token.getScore();
        int n3 = n;
        int n4 = n2 - 1;
        while (true) {
            if (n3 < n2 && tokenArray[n3].getScore() >= f) {
                ++n3;
                continue;
            }
            while (n4 > n3 && tokenArray[n4].getScore() < f) {
                --n4;
            }
            if (n4 <= n3) break;
            Token token2 = tokenArray[n4];
            this.setToken(tokenArray, n4, tokenArray[n3]);
            this.setToken(tokenArray, n3, token2);
        }
        this.setToken(tokenArray, n2, tokenArray[n3]);
        this.setToken(tokenArray, n3, token);
        return n3;
    }

    private int midPointPartition(Token[] tokenArray, int n, int n2) {
        int n3 = n + n2 >>> 1;
        Token token = tokenArray[n2];
        this.setToken(tokenArray, n2, tokenArray[n3]);
        this.setToken(tokenArray, n3, token);
        return this.endPointPartition(tokenArray, n, n2);
    }

    public int partition(Token[] tokenArray, int n, int n2) {
        if (tokenArray.length > n2) {
            return this.midPointSelect(tokenArray, 0, n - 1, n2, 0);
        }
        return this.findBest(tokenArray, n);
    }

    private int findBest(Token[] tokenArray, int n) {
        int n2;
        int n3 = -1;
        float f = Float.MAX_VALUE;
        for (n2 = 0; n2 < tokenArray.length; ++n2) {
            float f2 = tokenArray[n2].getScore();
            if (!(f2 <= f)) continue;
            f = f2;
            n3 = n2;
        }
        n2 = n - 1;
        if (n2 >= 0) {
            Token token = tokenArray[n2];
            this.setToken(tokenArray, n2, tokenArray[n3]);
            this.setToken(tokenArray, n3, token);
        }
        return n2;
    }

    private void setToken(Token[] tokenArray, int n, Token token) {
        tokenArray[n] = token;
    }

    private int midPointSelect(Token[] tokenArray, int n, int n2, int n3, int n4) {
        if (n4 > 50) {
            return this.simplePointSelect(tokenArray, n, n2, n3);
        }
        if (n == n2) {
            return n;
        }
        int n5 = this.midPointPartition(tokenArray, n, n2);
        int n6 = n5 - n + 1;
        if (n3 == n6) {
            return n5;
        }
        if (n3 < n6) {
            return this.midPointSelect(tokenArray, n, n5 - 1, n3, n4 + 1);
        }
        return this.midPointSelect(tokenArray, n5 + 1, n2, n3 - n6, n4 + 1);
    }

    private int simplePointSelect(Token[] tokenArray, int n, int n2, int n3) {
        Arrays.sort(tokenArray, n, n2 + 1, Scoreable.COMPARATOR);
        return n + n3 - 1;
    }
}

