/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.decoder.search.ActiveListFactory;
import edu.cmu.sphinx.decoder.search.ActiveListManager;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4ComponentList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

public class SimpleActiveListManager
implements ActiveListManager {
    @S4Boolean(defaultValue=false)
    public static final String PROP_CHECK_PRIOR_LISTS_EMPTY = "checkPriorListsEmpty";
    @S4ComponentList(type=ActiveListFactory.class)
    public static final String PROP_ACTIVE_LIST_FACTORIES = "activeListFactories";
    private Logger logger;
    private boolean checkPriorLists;
    private List<ActiveListFactory> activeListFactories;
    private ActiveList[] currentActiveLists;

    public SimpleActiveListManager(List<ActiveListFactory> list, boolean bl) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.activeListFactories = list;
        this.checkPriorLists = bl;
    }

    public SimpleActiveListManager() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logger = propertySheet.getLogger();
        this.activeListFactories = propertySheet.getComponentList(PROP_ACTIVE_LIST_FACTORIES, ActiveListFactory.class);
        this.checkPriorLists = propertySheet.getBoolean(PROP_CHECK_PRIOR_LISTS_EMPTY);
    }

    @Override
    public void setNumStateOrder(int n) {
        this.currentActiveLists = new ActiveList[n];
        if (this.activeListFactories.isEmpty()) {
            this.logger.severe("No active list factories configured");
            throw new Error("No active list factories configured");
        }
        if (this.activeListFactories.size() != this.currentActiveLists.length) {
            this.logger.warning("Need " + this.currentActiveLists.length + " active list factories, found " + this.activeListFactories.size());
        }
        this.createActiveLists();
    }

    private void createActiveLists() {
        int n = this.activeListFactories.size();
        for (int i = 0; i < this.currentActiveLists.length; ++i) {
            int n2 = i;
            if (n2 >= n) {
                n2 = n - 1;
            }
            ActiveListFactory activeListFactory = this.activeListFactories.get(n2);
            this.currentActiveLists[i] = activeListFactory.newInstance();
        }
    }

    @Override
    public void add(Token token) {
        ActiveList activeList = this.findListFor(token);
        if (activeList == null) {
            throw new Error("Cannot find ActiveList for " + token.getSearchState().getClass());
        }
        activeList.add(token);
    }

    private ActiveList findListFor(Token token) {
        return this.currentActiveLists[token.getSearchState().getOrder()];
    }

    @Override
    public ActiveList getEmittingList() {
        ActiveList activeList = this.currentActiveLists[this.currentActiveLists.length - 1];
        return activeList;
    }

    @Override
    public void clearEmittingList() {
        ActiveList activeList = this.currentActiveLists[this.currentActiveLists.length - 1];
        this.currentActiveLists[this.currentActiveLists.length - 1] = activeList.newInstance();
    }

    @Override
    public Iterator<ActiveList> getNonEmittingListIterator() {
        return new NonEmittingListIterator();
    }

    @Override
    public void dump() {
        System.out.println("--------------------");
        for (ActiveList activeList : this.currentActiveLists) {
            this.dumpList(activeList);
        }
    }

    private void dumpList(ActiveList activeList) {
        System.out.println("Size: " + activeList.size() + " Best token: " + activeList.getBestToken());
    }

    private class NonEmittingListIterator
    implements Iterator<ActiveList> {
        private int listPtr = -1;

        @Override
        public boolean hasNext() {
            return this.listPtr + 1 < SimpleActiveListManager.this.currentActiveLists.length - 1;
        }

        @Override
        public ActiveList next() throws NoSuchElementException {
            ++this.listPtr;
            if (this.listPtr >= SimpleActiveListManager.this.currentActiveLists.length) {
                throw new NoSuchElementException();
            }
            if (SimpleActiveListManager.this.checkPriorLists) {
                this.checkPriorLists();
            }
            return SimpleActiveListManager.this.currentActiveLists[this.listPtr];
        }

        private void checkPriorLists() {
            for (int i = 0; i < this.listPtr; ++i) {
                ActiveList activeList = SimpleActiveListManager.this.currentActiveLists[i];
                if (activeList.size() <= 0) continue;
                throw new Error("At while processing state order" + this.listPtr + ", state order " + i + " not empty");
            }
        }

        @Override
        public void remove() {
            ((SimpleActiveListManager)SimpleActiveListManager.this).currentActiveLists[this.listPtr] = SimpleActiveListManager.this.currentActiveLists[this.listPtr].newInstance();
        }
    }
}

